/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.CacheTopologyInfoImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;

public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class, Log.class);
    private Collection<SocketAddress> servers = new ArrayList<SocketAddress>();
    private Map<byte[], ConsistentHash> consistentHashes = CollectionFactory.makeMap((Equivalence)ByteArrayEquivalence.INSTANCE, (Equivalence)AnyEquivalence.getInstance());
    private Map<byte[], Integer> segmentsByCache = CollectionFactory.makeMap((Equivalence)ByteArrayEquivalence.INSTANCE, (Equivalence)AnyEquivalence.getInstance());
    private volatile AtomicInteger topologyId;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();

    public TopologyInfo(AtomicInteger topologyId, Collection<SocketAddress> servers, Configuration configuration) {
        this.topologyId = topologyId;
        this.servers = servers;
        this.hashFactory.init(configuration);
    }

    private Map<SocketAddress, Set<Integer>> getSegmentsByServer(byte[] cacheName) {
        ConsistentHash consistentHash = this.consistentHashes.get(cacheName);
        if (consistentHash != null) {
            return consistentHash.getSegmentsByServer();
        }
        Optional<Integer> numSegments = Optional.ofNullable(this.segmentsByCache.get(cacheName));
        Optional<Set> segments = numSegments.map(n -> IntStream.range(0, n).boxed().collect(Collectors.toSet()));
        return Immutables.immutableMapWrap(this.servers.stream().collect(Collectors.toMap(Function.identity(), s -> segments.orElse(InfinispanCollections.emptySet()))));
    }

    public Collection<SocketAddress> getServers() {
        return this.servers;
    }

    public void updateTopology(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace, byte[] cacheName) {
        Object hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
        if (hash == null) {
            log.noHasHFunctionConfigured(hashFunctionVersion);
        } else {
            hash.init(servers2Hash, numKeyOwners, hashSpace);
        }
        this.consistentHashes.put(cacheName, (ConsistentHash)hash);
    }

    public void updateTopology(SocketAddress[][] segmentOwners, int numSegments, short hashFunctionVersion, byte[] cacheName) {
        if (hashFunctionVersion > 0) {
            SegmentConsistentHash hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
            this.consistentHashes.put(cacheName, hash);
        }
        this.segmentsByCache.put(cacheName, numSegments);
    }

    public Optional<SocketAddress> getHashAwareServer(byte[] key, byte[] cacheName) {
        Optional<SocketAddress> server = Optional.empty();
        ConsistentHash consistentHash = this.consistentHashes.get(cacheName);
        if (consistentHash != null) {
            server = Optional.of(consistentHash.getServer(key));
            if (log.isTraceEnabled()) {
                log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
            }
        }
        return server;
    }

    public void updateServers(Collection<SocketAddress> updatedServers) {
        this.servers = updatedServers;
    }

    public ConsistentHash getConsistentHash(byte[] cacheName) {
        return this.consistentHashes.get(cacheName);
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public void setTopologyId(int topologyId) {
        this.topologyId.set(topologyId);
    }

    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        return new CacheTopologyInfoImpl(this.getSegmentsByServer(cacheName), this.segmentsByCache.get(cacheName), this.topologyId.get());
    }
}

