/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.commons.configuration.Builder;

public class ClusterConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ClusterConfiguration> {
    private final List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private final String clusterName;

    protected ClusterConfigurationBuilder(ConfigurationBuilder builder, String clusterName) {
        super(builder);
        this.clusterName = clusterName;
    }

    public ClusterConfigurationBuilder addClusterNode(String host, int port) {
        ServerConfigurationBuilder serverBuilder = new ServerConfigurationBuilder(this.builder);
        this.servers.add(serverBuilder.host(host).port(port));
        return this;
    }

    public void validate() {
    }

    public ClusterConfiguration create() {
        List<ServerConfiguration> serverCluster = this.servers.stream().map(ServerConfigurationBuilder::create).collect(Collectors.toList());
        return new ClusterConfiguration(serverCluster, this.clusterName);
    }

    public Builder<?> read(ClusterConfiguration template) {
        template.getCluster().stream().forEach(server -> this.addClusterNode(server.host(), server.port()));
        return this;
    }
}

