/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

public class RemoveClientListenerOperation
extends HotRodOperation {
    private final ClientListenerNotifier listenerNotifier;
    private final Object listener;
    protected final TransportFactory transportFactory;

    protected RemoveClientListenerOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags, ClientListenerNotifier listenerNotifier, Object listener) {
        super(codec, flags, cacheName, topologyId);
        this.transportFactory = transportFactory;
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        byte[] listenerId = this.listenerNotifier.findListenerId(this.listener);
        if (listenerId != null) {
            SocketAddress address = this.listenerNotifier.findTransport(listenerId).getRemoteSocketAddress();
            Transport transport = this.transportFactory.getAddressTransport(address);
            try {
                HeaderParams params = this.writeHeader(transport, (short)39);
                transport.writeArray(listenerId);
                transport.flush();
                short status = this.readHeaderAndValidate(transport, params);
                if (HotRodConstants.isSuccess(status)) {
                    this.listenerNotifier.removeClientListener(listenerId);
                }
            }
            finally {
                this.transportFactory.releaseTransport(transport);
            }
        }
        return null;
    }
}

