/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.ExtendDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.Log;

public final class FileDescriptor {
    private static final Log log = Log.LogFactory.getLog(FileDescriptor.class);
    protected Configuration configuration;
    private final String name;
    private final String packageName;
    private final List<String> dependencies;
    private final List<String> publicDependencies;
    private final List<Option> options;
    private final List<Descriptor> messageTypes;
    private final List<FieldDescriptor> extensions;
    private final List<EnumDescriptor> enumTypes;
    private final List<ExtendDescriptor> extendTypes;
    private final Map<String, ExtendDescriptor> extendDescriptors = new HashMap<String, ExtendDescriptor>();
    private final Map<String, FileDescriptor> dependants = new HashMap<String, FileDescriptor>();
    private Status status = Status.UNRESOLVED;
    private final Map<String, GenericDescriptor> typeRegistry = new HashMap<String, GenericDescriptor>();
    private final Map<String, GenericDescriptor> exportedTypes = new HashMap<String, GenericDescriptor>();
    private final Map<String, GenericDescriptor> types = new LinkedHashMap<String, GenericDescriptor>();

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private FileDescriptor(Builder builder) {
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.dependencies = Collections.unmodifiableList(builder.dependencies);
        this.publicDependencies = Collections.unmodifiableList(builder.publicDependencies);
        this.options = Collections.unmodifiableList(builder.options);
        this.enumTypes = Collections.unmodifiableList(builder.enumTypes);
        this.messageTypes = Collections.unmodifiableList(builder.messageTypes);
        this.extensions = builder.extensions;
        this.extendTypes = Collections.unmodifiableList(builder.extendDescriptors);
    }

    public Map<String, FileDescriptor> getDependants() {
        return this.dependants;
    }

    public boolean isResolved() {
        return this.status == Status.RESOLVED;
    }

    public void markUnresolved() {
        this.status = Status.UNRESOLVED;
    }

    public void clearErrors() {
        if (this.status != Status.RESOLVED) {
            this.status = Status.UNRESOLVED;
            this.typeRegistry.clear();
            this.exportedTypes.clear();
            this.types.clear();
            this.extendDescriptors.clear();
            for (FileDescriptor fd : this.dependants.values()) {
                fd.clearErrors();
            }
            this.dependants.clear();
        }
    }

    public boolean resolveDependencies(FileDescriptorSource.ProgressCallback progressCallback, Map<String, FileDescriptor> fileDescriptorMap, Map<String, GenericDescriptor> allTypes) throws DescriptorParserException {
        if (this.status == Status.UNRESOLVED) {
            this.resolveDependencies(progressCallback, fileDescriptorMap, allTypes, new HashSet<String>());
        }
        return this.status == Status.RESOLVED;
    }

    private void resolveDependencies(FileDescriptorSource.ProgressCallback progressCallback, Map<String, FileDescriptor> fileDescriptorMap, Map<String, GenericDescriptor> allTypes, Set<String> processedFiles) throws DescriptorParserException {
        if (this.status != Status.UNRESOLVED) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Resolving dependencies of %s", this.name);
        }
        try {
            List<FileDescriptor> pubDeps = this.resolveImports(progressCallback, fileDescriptorMap, allTypes, processedFiles, this.publicDependencies);
            if (pubDeps == null) {
                return;
            }
            List<FileDescriptor> deps = this.resolveImports(progressCallback, fileDescriptorMap, allTypes, processedFiles, this.dependencies);
            if (deps == null) {
                return;
            }
            for (FileDescriptor dep : pubDeps) {
                this.typeRegistry.putAll(dep.exportedTypes);
                this.exportedTypes.putAll(dep.exportedTypes);
            }
            for (FileDescriptor dep : deps) {
                this.typeRegistry.putAll(dep.exportedTypes);
            }
            for (Descriptor desc : this.messageTypes) {
                this.collectDescriptors(desc);
            }
            for (EnumDescriptor enumDesc : this.enumTypes) {
                this.collectEnumDescriptors(enumDesc);
            }
            for (ExtendDescriptor extendDescriptor : this.extendTypes) {
                this.collectExtensions(extendDescriptor);
            }
            for (Descriptor descriptor : this.messageTypes) {
                this.resolveTypes(descriptor);
            }
            for (ExtendDescriptor extendDescriptor : this.extendTypes) {
                GenericDescriptor res = this.searchType(extendDescriptor.getName(), null);
                if (res == null) {
                    throw new DescriptorParserException("Extension error: type " + extendDescriptor.getName() + " not found");
                }
                extendDescriptor.setExtendedMessage((Descriptor)res);
            }
            for (String typeName : this.types.keySet()) {
                GenericDescriptor existing = allTypes.get(typeName);
                if (existing == null) continue;
                List<String> locations = Arrays.asList(this.name, existing.getFileDescriptor().getName());
                Collections.sort(locations);
                throw new DescriptorParserException("Duplicate definition of " + typeName + " in " + locations.get(0) + " and " + locations.get(1));
            }
            for (FileDescriptor fd : pubDeps) {
                fd.dependants.put(this.name, this);
            }
            for (FileDescriptor fd : deps) {
                fd.dependants.put(this.name, this);
            }
        }
        catch (DescriptorParserException dpe) {
            this.status = Status.ERROR;
            if (progressCallback != null) {
                log.debugf("File has errors : %s", this.name);
                progressCallback.handleError(this.name, dpe);
                return;
            }
            throw dpe;
        }
        this.status = Status.RESOLVED;
        if (progressCallback != null) {
            log.debugf("File resolved successfully : %s", this.name);
            progressCallback.handleSuccess(this.name);
        }
    }

    private List<FileDescriptor> resolveImports(FileDescriptorSource.ProgressCallback progressCallback, Map<String, FileDescriptor> fileDescriptorMap, Map<String, GenericDescriptor> allTypes, Set<String> processedFiles, List<String> dependencies) throws DescriptorParserException {
        ArrayList<FileDescriptor> fileDescriptors = new ArrayList<FileDescriptor>(dependencies.size());
        HashSet<String> uniqueDependencies = new HashSet<String>(dependencies.size());
        for (String dependency : dependencies) {
            if (!uniqueDependencies.add(dependency)) {
                throw new DescriptorParserException("Duplicate import : " + dependency);
            }
            FileDescriptor fd = fileDescriptorMap.get(dependency);
            if (fd == null) {
                throw new DescriptorParserException("Import '" + dependency + "' not found");
            }
            if (fd.status == Status.UNRESOLVED) {
                if (!processedFiles.add(dependency)) {
                    throw new DescriptorParserException("Cyclic import detected at " + this.name + ", import " + dependency);
                }
                fd.resolveDependencies(progressCallback, fileDescriptorMap, allTypes, processedFiles);
            }
            if (fd.status == Status.ERROR) {
                this.status = Status.ERROR;
                return null;
            }
            fileDescriptors.add(fd);
        }
        return fileDescriptors;
    }

    private void collectDescriptors(Descriptor descriptor) {
        descriptor.setFileDescriptor(this);
        this.checkValidDefinition(descriptor);
        this.typeRegistry.put(descriptor.getFullName(), descriptor);
        this.types.put(descriptor.getFullName(), descriptor);
        this.exportedTypes.put(descriptor.getFullName(), descriptor);
        for (EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
            enumDescriptor.setContainingType(descriptor);
            this.collectEnumDescriptors(enumDescriptor);
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.collectDescriptors(nested);
        }
    }

    private void collectEnumDescriptors(EnumDescriptor enumDescriptor) {
        enumDescriptor.setFileDescriptor(this);
        this.checkValidDefinition(enumDescriptor);
        this.typeRegistry.put(enumDescriptor.getFullName(), enumDescriptor);
        this.types.put(enumDescriptor.getFullName(), enumDescriptor);
        this.exportedTypes.put(enumDescriptor.getFullName(), enumDescriptor);
    }

    private void checkValidDefinition(GenericDescriptor descriptor) {
        GenericDescriptor existing = this.types.get(descriptor.getFullName());
        if (existing != null) {
            String location = existing.getFileDescriptor().getName();
            if (!location.equals(this.getName())) {
                location = location + ", " + this.getName();
            }
            throw new DescriptorParserException(descriptor.getFullName() + " is already defined in " + location);
        }
    }

    private void collectExtensions(ExtendDescriptor extendDescriptor) {
        extendDescriptor.setFileDescriptor(this);
        this.extendDescriptors.put(extendDescriptor.getFullName(), extendDescriptor);
    }

    private void resolveTypes(Descriptor descriptor) {
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (fieldDescriptor.getType() != null) continue;
            GenericDescriptor res = this.searchType(fieldDescriptor.getTypeName(), descriptor);
            if (res instanceof EnumDescriptor) {
                fieldDescriptor.setEnumType((EnumDescriptor)res);
                continue;
            }
            if (res instanceof Descriptor) {
                fieldDescriptor.setMessageType((Descriptor)res);
                continue;
            }
            throw new DescriptorParserException("Field type " + fieldDescriptor.getTypeName() + " not found");
        }
        for (Descriptor nested : descriptor.getNestedTypes()) {
            this.resolveTypes(nested);
        }
    }

    private String getScopedName(String name) {
        if (this.packageName == null) {
            return name;
        }
        return this.packageName.concat(".").concat(name);
    }

    private GenericDescriptor searchType(String name, Descriptor scope) {
        GenericDescriptor fullyQualified = this.typeRegistry.get(this.getScopedName(name));
        if (fullyQualified != null) {
            return fullyQualified;
        }
        GenericDescriptor relativeName = this.typeRegistry.get(name);
        if (relativeName != null) {
            return relativeName;
        }
        if (scope != null) {
            Descriptor containingType;
            String searchScope = scope.getFullName().concat(".").concat(name);
            GenericDescriptor o = this.typeRegistry.get(searchScope);
            if (o != null) {
                return o;
            }
            while ((containingType = scope.getContainingType()) != null) {
                GenericDescriptor res = this.searchType(name, containingType);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.enumTypes;
    }

    public List<Descriptor> getMessageTypes() {
        return this.messageTypes;
    }

    public List<ExtendDescriptor> getExtensionsTypes() {
        return this.extendTypes;
    }

    public Map<String, GenericDescriptor> getTypes() {
        if (this.status != Status.RESOLVED) {
            throw new IllegalStateException("File " + this.name + " is not resolved yet");
        }
        return this.types;
    }

    public static final class Builder {
        private String name;
        private String packageName;
        private List<String> dependencies = new ArrayList<String>();
        private List<String> publicDependencies = new ArrayList<String>();
        private List<FieldDescriptor> extensions;
        private List<Option> options;
        private List<EnumDescriptor> enumTypes;
        private List<Descriptor> messageTypes;
        private List<ExtendDescriptor> extendDescriptors;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder withDependencies(List<String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder withPublicDependencies(List<String> publicDependencies) {
            this.publicDependencies = publicDependencies;
            return this;
        }

        public Builder withExtendDescriptors(List<ExtendDescriptor> extendDescriptors) {
            this.extendDescriptors = extendDescriptors;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withExtensions(List<FieldDescriptor> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> enumTypes) {
            this.enumTypes = enumTypes;
            return this;
        }

        public Builder withMessageTypes(List<Descriptor> messageTypes) {
            this.messageTypes = messageTypes;
            return this;
        }

        public FileDescriptor build() {
            return new FileDescriptor(this);
        }
    }

    private static enum Status {
        UNRESOLVED,
        RESOLVED,
        ERROR;

    }
}

