/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.TypedProperties;

@BuiltBy(value=ConfigurationBuilder.class)
public class Configuration {
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final Class<? extends FailoverRequestBalancingStrategy> balancingStrategyClass;
    private final FailoverRequestBalancingStrategy balancingStrategy;
    private final WeakReference<ClassLoader> classLoader;
    private final ConnectionPoolConfiguration connectionPool;
    private final int connectionTimeout;
    private final Class<? extends ConsistentHash>[] consistentHashImpl;
    private final boolean forceReturnValues;
    private final int keySizeEstimate;
    private final Class<? extends Marshaller> marshallerClass;
    private final Marshaller marshaller;
    private final String protocolVersion;
    private final List<ServerConfiguration> servers;
    private final int socketTimeout;
    private final SecurityConfiguration security;
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final Class<? extends TransportFactory> transportFactory;
    private final int valueSizeEstimate;
    private final int maxRetries;
    private final NearCacheConfiguration nearCache;
    private final List<ClusterConfiguration> clusters;

    Configuration(ExecutorFactoryConfiguration asyncExecutorFactory, Class<? extends FailoverRequestBalancingStrategy> balancingStrategyClass, FailoverRequestBalancingStrategy balancingStrategy, ClassLoader classLoader, ConnectionPoolConfiguration connectionPool, int connectionTimeout, Class<? extends ConsistentHash>[] consistentHashImpl, boolean forceReturnValues, int keySizeEstimate, Class<? extends Marshaller> marshallerClass, String protocolVersion, List<ServerConfiguration> servers, int socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, Class<? extends TransportFactory> transportFactory, int valueSizeEstimate, int maxRetries, NearCacheConfiguration nearCache, List<ClusterConfiguration> clusters) {
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyClass = balancingStrategyClass;
        this.balancingStrategy = balancingStrategy;
        this.maxRetries = maxRetries;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.consistentHashImpl = consistentHashImpl;
        this.forceReturnValues = forceReturnValues;
        this.keySizeEstimate = keySizeEstimate;
        this.marshallerClass = marshallerClass;
        this.marshaller = null;
        this.protocolVersion = protocolVersion;
        this.servers = Collections.unmodifiableList(servers);
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.transportFactory = transportFactory;
        this.valueSizeEstimate = valueSizeEstimate;
        this.nearCache = nearCache;
        this.clusters = clusters;
    }

    Configuration(ExecutorFactoryConfiguration asyncExecutorFactory, Class<? extends FailoverRequestBalancingStrategy> balancingStrategyClass, FailoverRequestBalancingStrategy balancingStrategy, ClassLoader classLoader, ConnectionPoolConfiguration connectionPool, int connectionTimeout, Class<? extends ConsistentHash>[] consistentHashImpl, boolean forceReturnValues, int keySizeEstimate, Marshaller marshaller, String protocolVersion, List<ServerConfiguration> servers, int socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, Class<? extends TransportFactory> transportFactory, int valueSizeEstimate, int maxRetries, NearCacheConfiguration nearCache, List<ClusterConfiguration> clusters) {
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyClass = balancingStrategyClass;
        this.balancingStrategy = balancingStrategy;
        this.maxRetries = maxRetries;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.consistentHashImpl = consistentHashImpl;
        this.forceReturnValues = forceReturnValues;
        this.keySizeEstimate = keySizeEstimate;
        this.marshallerClass = null;
        this.marshaller = marshaller;
        this.protocolVersion = protocolVersion;
        this.servers = Collections.unmodifiableList(servers);
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.transportFactory = transportFactory;
        this.valueSizeEstimate = valueSizeEstimate;
        this.nearCache = nearCache;
        this.clusters = clusters;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public Class<? extends FailoverRequestBalancingStrategy> balancingStrategyClass() {
        return this.balancingStrategyClass;
    }

    public FailoverRequestBalancingStrategy balancingStrategy() {
        return this.balancingStrategy;
    }

    public ClassLoader classLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public Class<? extends ConsistentHash>[] consistentHashImpl() {
        return Arrays.copyOf(this.consistentHashImpl, this.consistentHashImpl.length);
    }

    public Class<? extends ConsistentHash> consistentHashImpl(int version) {
        return this.consistentHashImpl[version - 1];
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues;
    }

    public int keySizeEstimate() {
        return this.keySizeEstimate;
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public Class<? extends Marshaller> marshallerClass() {
        return this.marshallerClass;
    }

    public NearCacheConfiguration nearCache() {
        return this.nearCache;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public List<ClusterConfiguration> clusters() {
        return this.clusters;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public Class<? extends TransportFactory> transportFactory() {
        return this.transportFactory;
    }

    public int valueSizeEstimate() {
        return this.valueSizeEstimate;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public String toString() {
        return "Configuration [asyncExecutorFactory=" + (Object)((Object)this.asyncExecutorFactory) + ", balancingStrategyClass=" + this.balancingStrategyClass + ", balancingStrategy=" + this.balancingStrategy + ",classLoader=" + this.classLoader + ", connectionPool=" + this.connectionPool + ", connectionTimeout=" + this.connectionTimeout + ", consistentHashImpl=" + Arrays.toString(this.consistentHashImpl) + ", forceReturnValues=" + this.forceReturnValues + ", keySizeEstimate=" + this.keySizeEstimate + ", marshallerClass=" + this.marshallerClass + ", marshaller=" + this.marshaller + ", protocolVersion=" + this.protocolVersion + ", servers=" + this.servers + ", socketTimeout=" + this.socketTimeout + ", security=" + this.security + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive + ", transportFactory=" + this.transportFactory + ", valueSizeEstimate=" + this.valueSizeEstimate + ", maxRetries=" + this.maxRetries + "nearCache=" + this.nearCache + "]";
    }

    public Properties properties() {
        Properties properties = new Properties();
        if (this.asyncExecutorFactory().factoryClass() != null) {
            properties.setProperty("infinispan.client.hotrod.async_executor_factory", this.asyncExecutorFactory().factoryClass().getName());
            TypedProperties aefProps = this.asyncExecutorFactory().properties();
            for (String string : Arrays.asList("infinispan.client.hotrod.default_executor_factory.pool_size", "infinispan.client.hotrod.default_executor_factory.queue_size")) {
                if (!aefProps.containsKey((Object)string)) continue;
                properties.setProperty(string, aefProps.getProperty(string));
            }
        }
        properties.setProperty("infinispan.client.hotrod.request_balancing_strategy", this.balancingStrategyClass().getName());
        properties.setProperty("infinispan.client.hotrod.connect_timeout", Integer.toString(this.connectionTimeout()));
        for (int i = 0; i < this.consistentHashImpl().length; ++i) {
            int version = i + 1;
            if (this.consistentHashImpl(version) == null) continue;
            properties.setProperty("infinispan.client.hotrod.hash_function_impl." + version, this.consistentHashImpl(version).getName());
        }
        properties.setProperty("infinispan.client.hotrod.force_return_values", Boolean.toString(this.forceReturnValues()));
        properties.setProperty("infinispan.client.hotrod.key_size_estimate", Integer.toString(this.keySizeEstimate()));
        properties.setProperty("infinispan.client.hotrod.marshaller", this.marshallerClass().getName());
        properties.setProperty("infinispan.client.hotrod.protocol_version", this.protocolVersion());
        properties.setProperty("infinispan.client.hotrod.socket_timeout", Integer.toString(this.socketTimeout()));
        properties.setProperty("infinispan.client.hotrod.tcp_no_delay", Boolean.toString(this.tcpNoDelay()));
        properties.setProperty("infinispan.client.hotrod.tcp_keep_alive", Boolean.toString(this.tcpKeepAlive()));
        properties.setProperty("infinispan.client.hotrod.transport_factory", this.transportFactory().getName());
        properties.setProperty("infinispan.client.hotrod.value_size_estimate", Integer.toString(this.valueSizeEstimate()));
        properties.setProperty("infinispan.client.hotrod.max_retries", Integer.toString(this.maxRetries()));
        properties.setProperty("exhaustedAction", Integer.toString(this.connectionPool().exhaustedAction().ordinal()));
        properties.setProperty("maxActive", Integer.toString(this.connectionPool().maxActive()));
        properties.setProperty("maxTotal", Integer.toString(this.connectionPool().maxTotal()));
        properties.setProperty("maxWait", Long.toString(this.connectionPool().maxWait()));
        properties.setProperty("maxIdle", Integer.toString(this.connectionPool().maxIdle()));
        properties.setProperty("minIdle", Integer.toString(this.connectionPool().minIdle()));
        properties.setProperty("numTestsPerEvictionRun", Integer.toString(this.connectionPool().numTestsPerEvictionRun()));
        properties.setProperty("minEvictableIdleTimeMillis", Long.toString(this.connectionPool().minEvictableIdleTime()));
        properties.setProperty("timeBetweenEvictionRunsMillis", Long.toString(this.connectionPool().timeBetweenEvictionRuns()));
        properties.setProperty("lifo", Boolean.toString(this.connectionPool().lifo()));
        properties.setProperty("testOnBorrow", Boolean.toString(this.connectionPool().testOnBorrow()));
        properties.setProperty("testOnReturn", Boolean.toString(this.connectionPool().testOnReturn()));
        properties.setProperty("testWhileIdle", Boolean.toString(this.connectionPool().testWhileIdle()));
        StringBuilder servers = new StringBuilder();
        for (ServerConfiguration serverConfiguration : this.servers()) {
            if (servers.length() > 0) {
                servers.append(";");
            }
            servers.append(serverConfiguration.host()).append(":").append(serverConfiguration.port());
        }
        properties.setProperty("infinispan.client.hotrod.server_list", servers.toString());
        properties.setProperty("infinispan.client.hotrod.use_ssl", Boolean.toString(this.security.ssl().enabled()));
        if (this.security.ssl().keyStoreFileName() != null) {
            properties.setProperty("infinispan.client.hotrod.key_store_file_name", this.security.ssl().keyStoreFileName());
        }
        if (this.security.ssl().keyStorePassword() != null) {
            properties.setProperty("infinispan.client.hotrod.key_store_password", new String(this.security.ssl().keyStorePassword()));
        }
        if (this.security.ssl().keyStoreCertificatePassword() != null) {
            properties.setProperty("infinispan.client.hotrod.key_store_certificate_password", new String(this.security.ssl().keyStoreCertificatePassword()));
        }
        if (this.security.ssl().trustStoreFileName() != null) {
            properties.setProperty("infinispan.client.hotrod.trust_store_file_name", this.security.ssl().trustStoreFileName());
        }
        if (this.security.ssl().trustStorePassword() != null) {
            properties.setProperty("infinispan.client.hotrod.trust_store_password", new String(this.security.ssl().trustStorePassword()));
        }
        if (this.security.ssl().sniHostName() != null) {
            properties.setProperty("infinispan.client.hotrod.sni_host_name", new String(this.security.ssl().sniHostName()));
        }
        if (this.security.ssl().sslContext() != null) {
            properties.put("infinispan.client.hotrod.ssl_context", this.security.ssl().sslContext());
        }
        properties.setProperty("infinispan.client.hotrod.use_auth", Boolean.toString(this.security.authentication().enabled()));
        if (this.security.authentication().saslMechanism() != null) {
            properties.setProperty("infinispan.client.hotrod.sasl_mechanism", this.security.authentication().saslMechanism());
        }
        if (this.security.authentication().callbackHandler() != null) {
            properties.put("infinispan.client.hotrod.auth_callback_handler", this.security.authentication().callbackHandler());
        }
        if (this.security.authentication().serverName() != null) {
            properties.setProperty("infinispan.client.hotrod.auth_server_name", this.security.authentication().serverName());
        }
        if (this.security.authentication().clientSubject() != null) {
            properties.put("infinispan.client.hotrod.auth_client_subject", this.security.authentication().clientSubject());
        }
        for (Map.Entry entry : this.security.authentication().saslProperties().entrySet()) {
            properties.setProperty("infinispan.client.hotrod.sasl_properties." + (String)entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }
}

