/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.Stats;

@MBean(objectName="CacheContainerStats", description="General cache container statistics such as timings, hit/miss ratio, etc.")
public class CacheContainerStatsImpl
implements CacheContainerStats,
JmxStatisticsExposer {
    private EmbeddedCacheManager cm;
    private boolean statisticsEnabled = false;

    public CacheContainerStatsImpl(EmbeddedCacheManager cm) {
        this.cm = cm;
        cm.getGlobalComponentRegistry().registerComponent((Object)this, CacheContainerStats.class);
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            for (String cn : this.cm.getCacheNames()) {
                if (!this.cm.cacheExists(cn)) continue;
                this.cm.getCache(cn).getAdvancedCache().getStats().setStatisticsEnabled(true);
            }
        }
        this.statisticsEnabled = enabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void resetStatistics() {
        if (this.getStatisticsEnabled()) {
            for (String cn : this.cm.getCacheNames()) {
                if (!this.cm.cacheExists(cn)) continue;
                this.cm.getCache(cn).getAdvancedCache().getStats().reset();
            }
        }
    }

    @Start(priority=9)
    private void start() {
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all read operation in this cache container", displayName="Cache container total average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long totalAverageReadTime = 0L;
        int existingCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            ++existingCacheCounter;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalAverageReadTime += stats.getAverageReadTime();
        }
        if (existingCacheCounter > 0) {
            return totalAverageReadTime / (long)existingCacheCounter;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all remove operation in this cache container", displayName="Cache container total average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long totalAverageRemoveTime = 0L;
        int existingCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            ++existingCacheCounter;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalAverageRemoveTime += stats.getAverageRemoveTime();
        }
        if (existingCacheCounter > 0) {
            return totalAverageRemoveTime / (long)existingCacheCounter;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cache container average number of milliseconds for all write operation in this cache container", displayName="Cache container average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        long totalAverageWriteTime = 0L;
        int existingCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            ++existingCacheCounter;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalAverageWriteTime += stats.getAverageWriteTime();
        }
        if (existingCacheCounter > 0) {
            return totalAverageWriteTime / (long)existingCacheCounter;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache eviction operations", displayName="Cache container total number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        long totalEvictions = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalEvictions += stats.getEvictions();
        }
        return totalEvictions;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute hits", displayName="Cache container total number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        long totalHits = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalHits += stats.getHits();
        }
        return totalHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total percentage hit/(hit+miss) ratio for this cache", displayName="Cache container total hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        double totalHitsOverMisses = 0.0;
        int existingCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            ++existingCacheCounter;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            long misses = stats.getMisses();
            if (misses <= 0L) continue;
            totalHitsOverMisses += (double)(stats.getHits() / misses);
        }
        if (existingCacheCounter > 0) {
            return totalHitsOverMisses / (double)existingCacheCounter;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute misses", displayName="Cache container total number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        long totalMisses = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalMisses += stats.getMisses();
        }
        return totalMisses;
    }

    @ManagedAttribute(description="Cache container total number of entries currently in all caches from this cache container", displayName="Cache container total number of all cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        int totalEntries = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalEntries += stats.getCurrentNumberOfEntries();
        }
        return totalEntries;
    }

    @Override
    @ManagedAttribute(description="Cache container read/writes ratio in all caches from this cache container", displayName="Cache container read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        double totalRWRatio = 0.0;
        int existingCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            ++existingCacheCounter;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            long stores = stats.getStores();
            if (stores <= 0L) continue;
            totalRWRatio += (double)((stats.getHits() + stats.getMisses()) / stores);
        }
        if (existingCacheCounter > 0) {
            return totalRWRatio / (double)existingCacheCounter;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removal hits", displayName="Cache container total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        long removeHits = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            removeHits += stats.getRemoveHits();
        }
        return removeHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removals where keys were not found", displayName="Cache container total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        long removeMisses = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            removeMisses += stats.getRemoveMisses();
        }
        return removeMisses;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute put operations", displayName="Cache container total number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        long totalStores = 0L;
        for (String cn : this.cm.getCacheNames()) {
            if (!this.cm.cacheExists(cn)) continue;
            Stats stats = this.cm.getCache(cn).getAdvancedCache().getStats();
            totalStores += stats.getStores();
        }
        return totalStores;
    }

    @Override
    public long getTimeSinceStart() {
        long longestRunning = 0L;
        for (String cn : this.cm.getCacheNames()) {
            Stats stats;
            long runningTime;
            if (!this.cm.cacheExists(cn) || (runningTime = (stats = this.cm.getCache(cn).getAdvancedCache().getStats()).getTimeSinceStart()) <= longestRunning) continue;
            longestRunning = runningTime;
        }
        return longestRunning;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.getStores();
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }
}

