/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.WorkerFactory;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.DefaultTimingSource;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.ImmutableSearchFactory;
import org.hibernate.search.engine.impl.IncrementalSearchConfiguration;
import org.hibernate.search.engine.impl.MappingModelMetadataProvider;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.engine.impl.MutableSearchFactoryState;
import org.hibernate.search.engine.impl.ReflectionReplacingSearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.impl.MRUFilterCachingStrategy;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SearchIntegratorBuilder {
    private static final Log log;
    private SearchConfiguration cfg;
    private MutableSearchFactory rootFactory;
    private final List<Class<?>> classes = new ArrayList();
    private final MutableSearchFactoryState factoryState = new MutableSearchFactoryState();

    public SearchIntegratorBuilder configuration(SearchConfiguration configuration) {
        this.cfg = configuration;
        return this;
    }

    public SearchIntegratorBuilder currentSearchIntegrator(SearchIntegrator factory) {
        this.rootFactory = factory.unwrap(MutableSearchFactory.class);
        return this;
    }

    public SearchIntegratorBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public SearchIntegrator buildSearchIntegrator() {
        ExtendedSearchIntegrator extendedIntegrator;
        if (this.rootFactory == null) {
            if (this.classes.size() > 0) {
                throw new SearchException("Cannot add a class if the original SearchFactory is not passed");
            }
            extendedIntegrator = this.buildNewSearchFactory();
        } else {
            extendedIntegrator = this.buildIncrementalSearchFactory();
        }
        return extendedIntegrator;
    }

    private ExtendedSearchIntegrator buildIncrementalSearchFactory() {
        this.removeClassesAlreadyManaged();
        if (this.classes.size() == 0) {
            return this.rootFactory;
        }
        this.factoryState.copyStateFromOldFactory(this.rootFactory);
        Properties configurationProperties = this.factoryState.getConfigurationProperties();
        BuildContext buildContext = new BuildContext();
        IncrementalSearchConfiguration searchConfiguration = new IncrementalSearchConfiguration(this.classes, configurationProperties, this.factoryState);
        this.applySearchMappingToMetadata(searchConfiguration.getReflectionManager(), searchConfiguration.getProgrammaticMapping());
        this.initDocumentBuilders(searchConfiguration, buildContext, searchConfiguration.getProgrammaticMapping());
        Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        Set<Class<?>> indexedClasses = documentBuildersIndexedEntities.keySet();
        for (EntityIndexBinding entityIndexBinding : documentBuildersIndexedEntities.values()) {
            entityIndexBinding.postInitialize(indexedClasses);
        }
        Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this.factoryState);
        this.factoryState.setActiveSearchIntegrator(factory);
        this.rootFactory.setDelegate(factory);
        return this.rootFactory;
    }

    private void removeClassesAlreadyManaged() {
        HashSet remove = new HashSet();
        Map<Class<?>, DocumentBuilderContainedEntity> containedEntities = this.rootFactory.getDocumentBuildersContainedEntities();
        Map<Class<?>, EntityIndexBinding> indexedEntities = this.rootFactory.getIndexBindings();
        for (Class<Object> entity : this.classes) {
            if (!indexedEntities.containsKey(entity) && !containedEntities.containsKey(entity)) continue;
            remove.add(entity);
        }
        for (Class<Object> entity : remove) {
            this.classes.remove(entity);
        }
    }

    private ExtendedSearchIntegrator buildNewSearchFactory() {
        BuildContext buildContext = new BuildContext();
        this.createCleanFactoryState(this.cfg, buildContext);
        ReflectionManager reflectionManager = this.getReflectionManager(this.cfg);
        if (reflectionManager != this.cfg.getReflectionManager()) {
            this.cfg = new ReflectionReplacingSearchConfiguration(reflectionManager, this.cfg);
        }
        SearchMapping mapping = SearchMappingHelper.extractSearchMapping(this.cfg);
        this.applySearchMappingToMetadata(reflectionManager, mapping);
        this.factoryState.setSearchMapping(mapping);
        this.factoryState.setIndexingStrategy(SearchIntegratorBuilder.defineIndexingStrategy(this.cfg));
        this.initDocumentBuilders(this.cfg, buildContext, mapping);
        Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        Set<Class<?>> indexedClasses = documentBuildersIndexedEntities.keySet();
        for (EntityIndexBinding entityIndexBinding : documentBuildersIndexedEntities.values()) {
            entityIndexBinding.postInitialize(indexedClasses);
        }
        Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        for (DocumentBuilderContainedEntity builder : documentBuildersContainedEntities.values()) {
            builder.postInitialize(indexedClasses);
        }
        BatchedQueueingProcessor queueingProcessor = new BatchedQueueingProcessor(documentBuildersIndexedEntities, this.cfg.getProperties());
        this.factoryState.setWorker(WorkerFactory.createWorker(this.cfg, buildContext, queueingProcessor));
        this.factoryState.setFilterCachingStrategy(this.buildFilterCachingStrategy(this.cfg));
        this.factoryState.setCacheBitResultsSize(ConfigurationParseHelper.getIntValue(this.cfg.getProperties(), "hibernate.search.filter.cache_docidresults.size", 5));
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this.factoryState);
        this.factoryState.setActiveSearchIntegrator(factory);
        this.rootFactory.setDelegate(factory);
        return this.rootFactory;
    }

    private void applySearchMappingToMetadata(ReflectionManager reflectionManager, SearchMapping mapping) {
        if (mapping != null) {
            if (!(reflectionManager instanceof MetadataProviderInjector)) {
                throw new SearchException("Programmatic mapping model used but ReflectionManager does not implement " + MetadataProviderInjector.class.getName());
            }
            MetadataProviderInjector injector = (MetadataProviderInjector)reflectionManager;
            MetadataProvider original = injector.getMetadataProvider();
            injector.setMetadataProvider((MetadataProvider)new MappingModelMetadataProvider(original, mapping));
        }
    }

    private FilterCachingStrategy buildFilterCachingStrategy(SearchConfiguration searchConfiguration) {
        FilterCachingStrategy filterCachingStrategy;
        String filterCachingStrategyName = searchConfiguration.getProperties().getProperty("hibernate.search.filter.cache_strategy");
        if (StringHelper.isEmpty(filterCachingStrategyName) || "mru".equalsIgnoreCase(filterCachingStrategyName)) {
            filterCachingStrategy = new MRUFilterCachingStrategy();
        } else {
            Class filterCachingStrategyClass = searchConfiguration.getClassLoaderService().classForName(filterCachingStrategyName);
            filterCachingStrategy = ClassLoaderHelper.instanceFromClass(FilterCachingStrategy.class, filterCachingStrategyClass, "filterCachingStrategy");
        }
        filterCachingStrategy.initialize(searchConfiguration.getProperties());
        return filterCachingStrategy;
    }

    private void createCleanFactoryState(SearchConfiguration cfg, BuildContext buildContext) {
        if (this.rootFactory == null) {
            this.rootFactory = new MutableSearchFactory();
            this.factoryState.setDocumentBuildersIndexedEntities(new ConcurrentHashMap());
            this.factoryState.setDocumentBuildersContainedEntities(new ConcurrentHashMap());
            this.factoryState.setFilterDefinitions(new ConcurrentHashMap<String, FilterDef>());
            this.factoryState.setIndexHierarchy(new PolymorphicIndexHierarchy());
            this.factoryState.setConfigurationProperties(cfg.getProperties());
            this.factoryState.setServiceManager(new StandardServiceManager(cfg, buildContext, Environment.DEFAULT_SERVICES_MAP));
            this.factoryState.setAllIndexesManager(new IndexManagerHolder());
            this.factoryState.setErrorHandler(this.createErrorHandler(cfg));
            this.factoryState.setInstanceInitializer(cfg.getInstanceInitializer());
            this.factoryState.setTimingSource(new DefaultTimingSource());
            this.factoryState.setIndexMetadataComplete(cfg.isIndexMetadataComplete());
            this.factoryState.setTransactionManagerExpected(cfg.isTransactionManagerExpected());
            this.factoryState.setDeleteByTermEnforced(cfg.isDeleteByTermEnforced());
            this.factoryState.setIdProvidedImplicit(cfg.isIdProvidedImplicit());
        }
    }

    private void initDocumentBuilders(SearchConfiguration searchConfiguration, BuildContext buildContext, SearchMapping searchMapping) {
        Class<?> mappedClass;
        ConfigContext configContext = new ConfigContext(searchConfiguration, buildContext, searchMapping);
        this.initProgrammaticAnalyzers(configContext, searchConfiguration.getReflectionManager());
        this.initProgrammaticallyDefinedFilterDef(searchConfiguration.getReflectionManager());
        PolymorphicIndexHierarchy indexingHierarchy = this.factoryState.getIndexHierarchy();
        Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities = this.factoryState.getIndexBindings();
        Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities = this.factoryState.getDocumentBuildersContainedEntities();
        HashSet<XClass> optimizationBlackListedTypes = new HashSet<XClass>();
        Map<XClass, Class<?>> classMappings = SearchIntegratorBuilder.initializeClassMappings(searchConfiguration, searchConfiguration.getReflectionManager());
        LinkedList<XClass> rootIndexedEntities = new LinkedList<XClass>();
        AnnotationMetadataProvider metadataProvider = new AnnotationMetadataProvider(searchConfiguration.getReflectionManager(), configContext);
        for (Map.Entry<XClass, Class<?>> mapping : classMappings.entrySet()) {
            TypeMetadata typeMetadata;
            DocumentBuilderContainedEntity documentBuilder;
            XClass mappedXClass = mapping.getKey();
            mappedClass = mapping.getValue();
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                if (mappedXClass.isAbstract()) {
                    log.abstractClassesCannotInsertDocuments(mappedXClass.getName());
                    continue;
                }
                rootIndexedEntities.add(mappedXClass);
                indexingHierarchy.addIndexedClass(mappedClass);
            } else if (metadataProvider.containsSearchMetadata(mappedClass) && (documentBuilder = new DocumentBuilderContainedEntity(mappedXClass, typeMetadata = metadataProvider.getTypeMetadataFor(mappedClass), searchConfiguration.getReflectionManager(), optimizationBlackListedTypes, searchConfiguration.getInstanceInitializer())).getEntityState() != EntityState.NON_INDEXABLE) {
                documentBuildersContainedEntities.put(mappedClass, documentBuilder);
            }
            this.bindFilterDefs(mappedXClass);
        }
        IndexManagerHolder indexesFactory = this.factoryState.getAllIndexesManager();
        for (XClass mappedXClass : rootIndexedEntities) {
            MutableEntityIndexBinding entityIndexBinding = indexesFactory.buildEntityIndexBinding(mappedXClass, mappedClass = classMappings.get(mappedXClass), searchConfiguration, buildContext);
            if (entityIndexBinding.getEntityIndexingInterceptor() != null) {
                optimizationBlackListedTypes.add(mappedXClass);
            }
            TypeMetadata typeMetadata = metadataProvider.getTypeMetadataFor(mappedClass);
            DocumentBuilderIndexedEntity documentBuilder = new DocumentBuilderIndexedEntity(mappedXClass, typeMetadata, configContext, searchConfiguration.getReflectionManager(), optimizationBlackListedTypes, searchConfiguration.getInstanceInitializer());
            entityIndexBinding.setDocumentBuilderIndexedEntity(documentBuilder);
            documentBuildersIndexedEntities.put(mappedClass, entityIndexBinding);
        }
        this.disableBlackListedTypesOptimization(classMappings, optimizationBlackListedTypes, documentBuildersIndexedEntities, documentBuildersContainedEntities);
        this.factoryState.setAnalyzers(configContext.initLazyAnalyzers());
    }

    private void disableBlackListedTypesOptimization(Map<XClass, Class<?>> classMappings, Set<XClass> optimizationBlackListX, Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities, Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities) {
        for (XClass xClass : optimizationBlackListX) {
            DocumentBuilderContainedEntity documentBuilderContainedEntity;
            Class<?> type = classMappings.get(xClass);
            if (type == null) continue;
            EntityIndexBinding entityIndexBinding = documentBuildersIndexedEntities.get(type);
            if (entityIndexBinding != null) {
                log.tracef("Dirty checking optimizations disabled for class %s", type);
                entityIndexBinding.getDocumentBuilder().forceStateInspectionOptimizationsDisabled();
            }
            if ((documentBuilderContainedEntity = documentBuildersContainedEntities.get(type)) == null) continue;
            log.tracef("Dirty checking optimizations disabled for class %s", type);
            documentBuilderContainedEntity.forceStateInspectionOptimizationsDisabled();
        }
    }

    private static Map<XClass, Class<?>> initializeClassMappings(SearchConfiguration cfg, ReflectionManager reflectionManager) {
        Iterator<Class<?>> iter = cfg.getClassMappings();
        HashMap map = new HashMap();
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            map.put(mappedXClass, mappedClass);
        }
        return map;
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = (FullTextFilterDef)mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = (FullTextFilterDefs)mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.factoryState.getFilterDefinitions().containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        this.bindFullTextFilterDef(defAnn);
    }

    private void bindFullTextFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        Map<String, FilterDef> filterDefinition = this.factoryState.getFilterDefinitions();
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            filterDefinition.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        filterDefinition.put(defAnn.name(), filterDef);
    }

    private void initProgrammaticAnalyzers(ConfigContext context, ReflectionManager reflectionManager) {
        AnalyzerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (AnalyzerDef[])defaults.get(AnalyzerDefs.class)) != null) {
            for (AnalyzerDef def : defs) {
                context.addGlobalAnalyzerDef(def);
            }
        }
    }

    private void initProgrammaticallyDefinedFilterDef(ReflectionManager reflectionManager) {
        Map defaults = reflectionManager.getDefaults();
        FullTextFilterDef[] filterDefs = (FullTextFilterDef[])defaults.get(FullTextFilterDefs.class);
        if (filterDefs != null && filterDefs.length != 0) {
            Map<String, FilterDef> filterDefinitions = this.factoryState.getFilterDefinitions();
            for (FullTextFilterDef defAnn : filterDefs) {
                if (filterDefinitions.containsKey(defAnn.name())) {
                    throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name());
                }
                this.bindFullTextFilterDef(defAnn);
            }
        }
    }

    private ReflectionManager getReflectionManager(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        return this.getReflectionManager(reflectionManager);
    }

    private ReflectionManager getReflectionManager(ReflectionManager reflectionManager) {
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    private static String defineIndexingStrategy(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if (!"event".equals(indexingStrategy) && !"manual".equals(indexingStrategy)) {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
        return indexingStrategy;
    }

    private ErrorHandler createErrorHandler(SearchConfiguration searchConfiguration) {
        String errorHandlerClassName = searchConfiguration.getProperty("hibernate.search.error_handler");
        if (StringHelper.isEmpty(errorHandlerClassName)) {
            return new LogErrorHandler();
        }
        if ("log".equals(errorHandlerClassName.trim())) {
            return new LogErrorHandler();
        }
        Class errorHandlerClass = searchConfiguration.getClassLoaderService().classForName(errorHandlerClassName);
        return ClassLoaderHelper.instanceFromClass(ErrorHandler.class, errorHandlerClass, "Error Handler");
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }

    private class BuildContext
    implements WorkerBuildContext {
        private final SearchFactoryState factoryState;

        private BuildContext() {
            this.factoryState = SearchIntegratorBuilder.this.factoryState;
        }

        @Override
        public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
            return SearchIntegratorBuilder.this.rootFactory;
        }

        @Override
        public String getIndexingStrategy() {
            return this.factoryState.getIndexingStrategy();
        }

        @Override
        public boolean isTransactionManagerExpected() {
            return SearchIntegratorBuilder.this.cfg.isTransactionManagerExpected();
        }

        @Override
        public IndexManagerHolder getAllIndexesManager() {
            return this.factoryState.getAllIndexesManager();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.factoryState.getErrorHandler();
        }

        @Override
        public InstanceInitializer getInstanceInitializer() {
            return this.factoryState.getInstanceInitializer();
        }

        @Override
        public boolean isIndexMetadataComplete() {
            return this.factoryState.isIndexMetadataComplete();
        }

        @Override
        public boolean isDeleteByTermEnforced() {
            return this.factoryState.isDeleteByTermEnforced();
        }

        @Override
        public ServiceManager getServiceManager() {
            return this.factoryState.getServiceManager();
        }
    }
}

