/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.UUID;

public class JDBC_PING
extends Discovery {
    @Property(description="The JDBC connection URL", writable=false)
    protected String connection_url = null;
    @Property(description="The JDBC connection username", writable=false)
    protected String connection_username = null;
    @Property(description="The JDBC connection password", writable=false, exposeAsManagedAttribute=false)
    protected String connection_password = null;
    @Property(description="The JDBC connection driver name", writable=false)
    protected String connection_driver = null;
    @Property(description="If not empty, this SQL statement will be performed at startup.Customize it to create the needed table on those databases which permit table creation attempt without loosing data, such as PostgreSQL and MySQL (using IF NOT EXISTS). To allow for creation attempts, errors performing this statement will be loggedbut not considered fatal. To avoid any DDL operation, set this to an empty string.")
    protected String initialize_sql = "CREATE TABLE JGROUPSPING (own_addr varchar(200) NOT NULL, cluster_name varchar(200) NOT NULL, ping_data varbinary(5000) DEFAULT NULL, PRIMARY KEY (own_addr, cluster_name) )";
    @Property(description="SQL used to insert a new row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String 3)Serialized PingData as byte[]")
    protected String insert_single_sql = "INSERT INTO JGROUPSPING (own_addr, cluster_name, ping_data) values (?, ?, ?)";
    @Property(description="SQL used to delete a row. Customizable, but keep the order of parameters and pick compatible types: 1)Own Address, as String 2)Cluster name, as String")
    protected String delete_single_sql = "DELETE FROM JGROUPSPING WHERE own_addr=? AND cluster_name=?";
    @Property(description="SQL used to fetch all node's PingData. Customizable, but keep the order of parameters and pick compatible types: only one parameter needed, String compatible, representing the Cluster name. Must return a byte[], the Serialized PingData as it was stored by the insert_single_sql statement")
    protected String select_all_pingdata_sql = "SELECT ping_data FROM JGROUPSPING WHERE cluster_name=?";
    @Property(description="To use a DataSource registered in JNDI, specify the JNDI name here. This is an alternative to all connection_* configuration options: if this property is not empty, then all connection relatedproperties must be empty.")
    protected String datasource_jndi_name;
    private DataSource dataSourceFromJNDI = null;

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.verifyconfigurationParameters();
        if (JDBC_PING.stringIsEmpty(this.datasource_jndi_name)) {
            this.loadDriver();
        } else {
            this.dataSourceFromJNDI = this.getDataSourceFromJNDI(this.datasource_jndi_name.trim());
        }
        this.attemptSchemaInitialization();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JDBC_PING.this.remove(JDBC_PING.this.cluster_name, JDBC_PING.this.local_addr);
            }
        });
    }

    @Override
    public void stop() {
        try {
            this.deleteSelf();
        }
        catch (SQLException e) {
            this.log.error("Error while unregistering of our own Address from JDBC_PING database during shutdown", e);
        }
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View old_view = this.view;
                boolean previous_coord = this.is_coord;
                Object retval = super.down(evt);
                View new_view = (View)evt.getArg();
                this.handleView(new_view, old_view, previous_coord != this.is_coord);
                return retval;
            }
        }
        return super.down(evt);
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        this.readAll(members, this.cluster_name, responses);
        this.writeOwnInformation();
    }

    protected void handleView(View new_view, View old_view, boolean coord_changed) {
        if (this.is_coord && old_view != null && new_view != null) {
            Address[] left_mbrs;
            Address[][] diff = View.diff(old_view, new_view);
            for (Address left_mbr : left_mbrs = diff[1]) {
                if (left_mbr == null || new_view.containsMember(left_mbr)) continue;
                this.remove(this.cluster_name, left_mbr);
            }
        }
        if (coord_changed) {
            this.writeOwnInformation();
        }
    }

    protected void writeOwnInformation() {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, this.is_server, UUID.get(this.local_addr), physical_addr).coord(this.is_coord);
        this.writeToDB(data, this.cluster_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToDB(PingData data, String clustername) {
        String ownAddress = JDBC_PING.addressAsString(data.getAddress());
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.delete(connection, clustername, ownAddress);
                this.insert(connection, data, clustername, ownAddress);
            }
            catch (SQLException e) {
                this.log.error("Error updating JDBC_PING table", e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error("Failed to store PingData in database");
        }
    }

    protected void remove(String clustername, Address addr) {
        String addressAsString = JDBC_PING.addressAsString(addr);
        try {
            this.delete(clustername, addressAsString);
        }
        catch (SQLException e) {
            this.log.error("Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.readAll(connection, members, clustername, responses);
            }
            catch (SQLException e) {
                this.log.error("Error reading JDBC_PING table", e);
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll(Connection connection, List<Address> members, String clustername, Responses rsps) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(this.select_all_pingdata_sql);
        try {
            ps.setString(1, clustername);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                byte[] bytes = resultSet.getBytes(1);
                try {
                    PingData data = JDBC_PING.deserialize(bytes);
                    if (data == null || members != null && !members.contains(data.getAddress())) continue;
                    rsps.addResponse(data, false);
                    if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                    this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                }
                catch (Exception e) {
                    int row = resultSet.getRow();
                    this.log.error("%s: failed deserializing row %d: %s; removing it from the table", this.local_addr, row, e);
                    try {
                        resultSet.deleteRow();
                    }
                    catch (Throwable t) {
                        this.log.error("%s: failed removing row %d: %s; please delete it manually", this.local_addr, row, e);
                    }
                }
            }
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSchemaInitialization() {
        if (JDBC_PING.stringIsEmpty(this.initialize_sql)) {
            this.log.debug("Table creation step skipped: initialize_sql property is missing");
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        try {
            connection.prepareStatement(this.initialize_sql).execute();
            this.log.debug("Table created for JDBC_PING Discovery Protocol");
        }
        catch (SQLException e) {
            this.log.debug("Could not execute initialize_sql statement; not necessarily an error, we always attempt to create the schema. To suppress this message, set initialize_sql to an empty value. Cause: %s", e.getMessage());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.error("Error closing connection", e);
            }
        }
    }

    protected void loadDriver() {
        if (JDBC_PING.stringIsEmpty(this.connection_driver)) {
            return;
        }
        this.log.debug("Registering JDBC Driver named '%s'", this.connection_driver);
        try {
            Class.forName(this.connection_driver);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("JDBC Driver required for JDBC_PING protocol could not be loaded: '" + this.connection_driver + "'");
        }
    }

    protected Connection getConnection() {
        if (this.dataSourceFromJNDI == null) {
            Connection connection;
            try {
                connection = DriverManager.getConnection(this.connection_url, this.connection_username, this.connection_password);
            }
            catch (SQLException e) {
                this.log.error("Could not open connection to database", e);
                return null;
            }
            if (connection == null) {
                this.log.error("Received null connection from the DriverManager!");
            }
            return connection;
        }
        try {
            return this.dataSourceFromJNDI.getConnection();
        }
        catch (SQLException e) {
            this.log.error("Could not open connection to database", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void insert(Connection connection, PingData data, String clustername, String address) throws SQLException {
        byte[] serializedPingData = this.serializeWithoutView(data);
        PreparedStatement ps = connection.prepareStatement(this.insert_single_sql);
        try {
            ps.setString(1, address);
            ps.setString(2, clustername);
            ps.setBytes(3, serializedPingData);
            ps.executeUpdate();
            this.log.debug("Registered %s for clustername %s into database", address, clustername);
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void delete(Connection connection, String clustername, String addressToDelete) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(this.delete_single_sql);
        try {
            ps.setString(1, addressToDelete);
            ps.setString(2, clustername);
            ps.executeUpdate();
            this.log.debug("Removed %s for clustername %s from database", addressToDelete, clustername);
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(String clustername, String addressToDelete) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                this.delete(connection, clustername, addressToDelete);
            }
            catch (SQLException e) {
                this.log.error("Error updating JDBC_PING table", e);
            }
            finally {
                this.closeConnection(connection);
            }
        } else {
            this.log.error("Failed to delete PingData in database");
        }
    }

    protected void deleteSelf() throws SQLException {
        String ownAddress = JDBC_PING.addressAsString(this.local_addr);
        this.delete(this.cluster_name, ownAddress);
    }

    protected void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            this.log.error("Error closing connection to JDBC_PING database", e);
        }
    }

    protected DataSource getDataSourceFromJNDI(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object wathever = ctx.lookup(name);
            if (wathever == null) {
                throw new IllegalArgumentException("JNDI name " + name + " is not bound");
            }
            if (!(wathever instanceof DataSource)) {
                throw new IllegalArgumentException("JNDI name " + name + " was found but is not a DataSource");
            }
            DataSource dataSource = (DataSource)wathever;
            this.log.debug("Datasource found via JNDI lookup via name: '%s'", name);
            DataSource dataSource2 = dataSource;
            return dataSource2;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Could not lookup datasource " + name, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.log.warn("Failed to close naming context.", e);
                }
            }
        }
    }

    protected void verifyconfigurationParameters() {
        if ((JDBC_PING.stringIsEmpty(this.connection_url) || JDBC_PING.stringIsEmpty(this.connection_driver) || JDBC_PING.stringIsEmpty(this.connection_username)) && JDBC_PING.stringIsEmpty(this.datasource_jndi_name)) {
            throw new IllegalArgumentException("Either the 4 configuration properties starting with 'connection_' or the datasource_jndi_name must be set");
        }
        if ((JDBC_PING.stringNotEmpty(this.connection_url) || JDBC_PING.stringNotEmpty(this.connection_driver) || JDBC_PING.stringNotEmpty(this.connection_username)) && JDBC_PING.stringNotEmpty(this.datasource_jndi_name)) {
            throw new IllegalArgumentException("When using the 'datasource_jndi_name' configuration property, all properties starting with 'connection_' must not be set");
        }
        if (JDBC_PING.stringIsEmpty(this.insert_single_sql)) {
            throw new IllegalArgumentException("The insert_single_sql configuration property is mandatory");
        }
        if (JDBC_PING.stringIsEmpty(this.delete_single_sql)) {
            throw new IllegalArgumentException("The delete_single_sql configuration property is mandatory");
        }
        if (JDBC_PING.stringIsEmpty(this.select_all_pingdata_sql)) {
            throw new IllegalArgumentException("The select_all_pingdata_sql configuration property is mandatory");
        }
    }

    private static final boolean stringIsEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static final boolean stringNotEmpty(String value) {
        return !JDBC_PING.stringIsEmpty(value);
    }
}

