/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.LinkedHashMap;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LookupObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make();
    public static final LookupObjectInitializer INSTANCE = new LookupObjectInitializer();

    private LookupObjectInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        boolean traceEnabled = log.isTraceEnabled();
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            if (traceEnabled) {
                log.tracef("No object to initialize", (Object)maxResults);
            }
            return;
        }
        for (EntityInfo entityInfo : entityInfos) {
            Object o = ObjectLoaderHelper.load(entityInfo, objectInitializationContext.getSession());
            if (o == null) continue;
            EntityInfoLoadKey key = new EntityInfoLoadKey(entityInfo.getClazz(), entityInfo.getId());
            idToObjectMap.put(key, o);
        }
        if (traceEnabled) {
            log.tracef("Initialized %d objects by lookup method.", (Object)maxResults);
        }
    }
}

