/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql.predicate;

import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;

class FilterComparisonPredicate
extends ComparisonPredicate<BooleanExpr> {
    private final boolean isRepeatedProperty;

    public FilterComparisonPredicate(String propertyName, boolean isRepeatedProperty, ComparisonPredicate.Type comparisonType, Object comparisonValue) {
        super(propertyName, comparisonType, comparisonValue);
        this.isRepeatedProperty = isRepeatedProperty;
    }

    protected BooleanExpr getStrictlyLessQuery() {
        return new ComparisonExpr(new PropertyValueExpr(this.propertyName, this.isRepeatedProperty), new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.LESS);
    }

    protected BooleanExpr getLessOrEqualsQuery() {
        return new ComparisonExpr(new PropertyValueExpr(this.propertyName, this.isRepeatedProperty), new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.LESS_OR_EQUAL);
    }

    protected BooleanExpr getEqualsQuery() {
        return new ComparisonExpr(new PropertyValueExpr(this.propertyName, this.isRepeatedProperty), new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.EQUAL);
    }

    protected BooleanExpr getGreaterOrEqualsQuery() {
        return new ComparisonExpr(new PropertyValueExpr(this.propertyName, this.isRepeatedProperty), new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.GREATER_OR_EQUAL);
    }

    protected BooleanExpr getStrictlyGreaterQuery() {
        return new ComparisonExpr(new PropertyValueExpr(this.propertyName, this.isRepeatedProperty), new ConstantValueExpr((Comparable)this.value), ComparisonExpr.Type.GREATER);
    }
}

