/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

public abstract class AbstractMarshaller
extends AbstractExternalizer
implements Marshaller {
    private static final byte RECORD = 0;
    private static final byte SCHEMA = 1;
    private static final byte OTHER = 2;

    protected abstract DatumReader reader(String var1) throws InterruptedException, IOException, ClassNotFoundException;

    public void writeObject(ObjectOutput output, Object o) throws IOException {
        byte[] out = this.objectToByteBuffer(o);
        output.writeObject(out);
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        byte[] buf = this.objectToByteBuffer(o);
        return new ByteBufferImpl(buf, 0, buf.length);
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        return this.objectToByteBuffer(obj);
    }

    public byte[] objectToByteBuffer(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        if (o instanceof GenericContainer) {
            oos.write(0);
            GenericContainer container = (GenericContainer)o;
            oos.writeObject(container.getSchema().getFullName());
            GenericDatumWriter datumWriter = new GenericDatumWriter(container.getSchema());
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)baos, null);
            datumWriter.write((Object)container, (Encoder)encoder);
            encoder.flush();
        } else if (o instanceof Schema) {
            oos.write(1);
            oos.writeObject(o.toString());
        } else {
            oos.write(2);
            oos.writeObject(o);
        }
        return baos.toByteArray();
    }

    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer((byte[])input.readObject());
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        if (offset != 0 || length != buf.length) {
            this.objectFromByteBuffer(Arrays.copyOfRange(buf, offset, length));
        }
        return this.objectFromByteBuffer(buf);
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Byte header = ois.readByte();
            switch (header) {
                case 0: {
                    String schemaName = (String)ois.readObject();
                    BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)bais, null);
                    DatumReader reader = this.reader(schemaName);
                    return reader.read(null, (Decoder)decoder);
                }
                case 1: {
                    return Schema.parse((String)((String)ois.readObject()));
                }
                case 2: {
                    return ois.readObject();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IOException("cannot unmarshall");
    }

    public Set<Class<? extends Object>> getTypeClasses() {
        HashSet<Class<? extends Object>> set = new HashSet<Class<? extends Object>>();
        set.add(GenericData.Record.class);
        set.add(Schema.class);
        set.add(Serializable.class);
        return set;
    }

    public boolean isMarshallable(Object o) throws Exception {
        return o instanceof GenericData.Record || o instanceof Schema || o instanceof Serializable;
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return null;
    }
}

