/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.bdbje;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.ExceptionUnwrapper;
import java.io.File;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loader.AbstractCacheStore;
import org.infinispan.loader.CacheLoaderConfig;
import org.infinispan.loader.CacheLoaderException;
import org.infinispan.loader.CacheStore;
import org.infinispan.loader.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loader.bdbje.BdbjeResourceFactory;
import org.infinispan.loader.bdbje.ModificationsTransactionWorker;
import org.infinispan.loader.bdbje.PreparableTransactionRunner;
import org.infinispan.loader.modifications.Modification;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbjeCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(BdbjeCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private BdbjeCacheStoreConfig cfg;
    private Cache cache;
    private Environment env;
    private StoredClassCatalog catalog;
    private Database cacheDb;
    private StoredMap<Object, InternalCacheEntry> cacheMap;
    private PreparableTransactionRunner transactionRunner;
    private Map<Transaction, com.sleepycat.je.Transaction> txnMap;
    private CurrentTransaction currentTransaction;
    private BdbjeResourceFactory factory;

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        BdbjeCacheStoreConfig cfg = (BdbjeCacheStoreConfig)config;
        this.init(cfg, new BdbjeResourceFactory(cfg), cache);
    }

    public void init(BdbjeCacheStoreConfig cfg, BdbjeResourceFactory factory, Cache cache) {
        if (trace) {
            log.trace((Object)"initializing BdbjeCacheStore");
        }
        this.printLicense();
        super.init((CacheLoaderConfig)cfg, cache, null);
        this.cfg = cfg;
        this.factory = factory;
        this.cache = cache;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return BdbjeCacheStoreConfig.class;
    }

    public void start() throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"starting BdbjeCacheStore");
        }
        this.openSleepyCatResources();
        this.openTransactionServices();
        super.start();
        log.debug((Object)"started cache store {1}", new Object[]{this});
    }

    private void openTransactionServices() {
        this.txnMap = new ConcurrentHashMap<Transaction, com.sleepycat.je.Transaction>();
        this.currentTransaction = this.factory.createCurrentTransaction(this.env);
        this.transactionRunner = this.factory.createPreparableTransactionRunner(this.env);
    }

    private void openSleepyCatResources() throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"creating je environment with home dir {0}", new Object[]{this.cfg.getLocation()});
        }
        if (this.cfg.getCacheDbName() == null) {
            this.cfg.setCacheDbName(this.cache.getName());
        }
        if (this.cfg.getCatalogDbName() == null) {
            this.cfg.setCatalogDbName(this.cfg.getCacheDbName() + "_class_catalog");
        }
        File location = this.verifyOrCreateEnvironmentDirectory(new File(this.cfg.getLocation()));
        try {
            this.env = this.factory.createEnvironment(location);
            this.cacheDb = this.factory.createDatabase(this.env, this.cfg.getCacheDbName());
            Database catalogDb = this.factory.createDatabase(this.env, this.cfg.getCatalogDbName());
            this.catalog = this.factory.createStoredClassCatalog(catalogDb);
            this.cacheMap = this.factory.createStoredMapViewOfDatabase(this.cacheDb, this.catalog);
        }
        catch (DatabaseException e) {
            throw this.convertToCacheLoaderException("could not open sleepycat je resource", (Exception)((Object)e));
        }
    }

    File verifyOrCreateEnvironmentDirectory(File location) throws CacheLoaderException {
        boolean created;
        if (!location.exists() && !(created = location.mkdirs())) {
            throw new CacheLoaderException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new CacheLoaderException("Cache loader location [" + location + "] is not a directory!");
        }
        return location;
    }

    public void stop() throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"stopping BdbjeCacheStore");
        }
        super.stop();
        this.closeTransactionServices();
        this.closeSleepyCatResources();
        log.debug((Object)"started cache store {1}", new Object[]{this});
    }

    private void closeTransactionServices() {
        this.transactionRunner = null;
        this.currentTransaction = null;
        this.txnMap = null;
    }

    private void closeSleepyCatResources() throws CacheLoaderException {
        this.cacheMap = null;
        this.closeDatabases();
        this.closeEnvironment();
    }

    private void closeDatabases() {
        if (trace) {
            log.trace((Object)"closing databases");
        }
        try {
            this.cacheDb.close();
        }
        catch (Exception e) {
            log.error((Object)"Error closing database", (Throwable)e);
        }
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            log.error((Object)"Error closing catalog", (Throwable)e);
        }
        this.cacheMap = null;
        this.catalog = null;
        this.cacheDb = null;
    }

    private void closeEnvironment() throws CacheLoaderException {
        if (this.env != null) {
            try {
                this.env.close();
            }
            catch (DatabaseException e) {
                throw new CacheLoaderException("Unexpected exception closing cacheStore", (Throwable)e);
            }
        }
        this.env = null;
    }

    public void prepare(List<? extends Modification> mods, Transaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.applyModifications(mods);
        } else {
            this.prepare(mods, tx);
        }
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"performing one phase transaction");
        }
        try {
            this.transactionRunner.run(new ModificationsTransactionWorker((CacheStore)this, mods));
        }
        catch (Exception caught) {
            throw this.convertToCacheLoaderException("Problem committing modifications: " + mods, caught);
        }
    }

    protected void prepare(List<? extends Modification> mods, Transaction tx) throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"preparing transaction {0}", new Object[]{tx});
        }
        try {
            this.transactionRunner.prepare(new ModificationsTransactionWorker((CacheStore)this, mods));
            com.sleepycat.je.Transaction txn = this.currentTransaction.getTransaction();
            if (trace) {
                log.trace((Object)"transaction {0} == sleepycat transaction {1}", new Object[]{tx, txn});
            }
            this.txnMap.put(tx, txn);
            ReflectionUtil.setValue((Object)this.currentTransaction, (String)"localTrans", new ThreadLocal());
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Problem preparing transaction", e);
        }
    }

    public void rollback(Transaction tx) {
        try {
            this.completeTransaction(tx, false);
        }
        catch (Exception e) {
            log.error((Object)"Error rolling back transaction", (Throwable)e);
        }
    }

    public void commit(Transaction tx) throws CacheLoaderException {
        this.completeTransaction(tx, true);
    }

    protected void completeTransaction(Transaction tx, boolean commit) throws CacheLoaderException {
        com.sleepycat.je.Transaction txn = this.txnMap.remove(tx);
        if (txn != null) {
            if (trace) {
                log.trace((Object)"{0} sleepycat transaction {1}", new Object[]{commit ? "committing" : "aborting", txn});
            }
            try {
                if (commit) {
                    txn.commit();
                }
                txn.abort();
            }
            catch (Exception caught) {
                throw this.convertToCacheLoaderException("Problem completing transaction", caught);
            }
        } else if (trace) {
            log.trace((Object)"no sleepycat transaction associated  transaction {0}", new Object[]{tx});
        }
    }

    private void completeCurrentTransaction(boolean commit) throws CacheLoaderException {
        try {
            if (trace) {
                log.trace((Object)"{0} current sleepycat transaction {1}", new Object[]{commit ? "committing" : "aborting", this.currentTransaction.getTransaction()});
            }
            if (commit) {
                this.currentTransaction.commitTransaction();
            } else {
                this.currentTransaction.abortTransaction();
            }
        }
        catch (Exception caught) {
            throw this.convertToCacheLoaderException("Problem completing transaction", caught);
        }
    }

    public boolean remove(Object key) throws CacheLoaderException {
        try {
            if (this.cacheMap.containsKey(key)) {
                this.cacheMap.remove(key);
                return true;
            }
            return false;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error removing key " + key, caught);
        }
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        try {
            InternalCacheEntry s = (InternalCacheEntry)this.cacheMap.get(key);
            if (s != null && s.isExpired()) {
                this.cacheMap.remove(key);
                s = null;
            }
            return s;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading key " + key, caught);
        }
    }

    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        try {
            this.cacheMap.put(ed.getKey(), (Object)ed);
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error storing entry " + ed, caught);
        }
    }

    public void clear() throws CacheLoaderException {
        try {
            this.cacheMap.clear();
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error clearing store", caught);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        try {
            return new HashSet<InternalCacheEntry>(this.cacheMap.values());
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading all entries", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromStream(ObjectInput ois) throws CacheLoaderException {
        try {
            long recordCount = ois.readLong();
            this.currentTransaction.beginTransaction(null);
            log.debug((Object)"clearing and reading {0} records from stream", new Object[]{recordCount});
            this.cacheMap.clear();
            Cursor cursor = null;
            try {
                cursor = this.cacheDb.openCursor(this.currentTransaction.getTransaction(), null);
                int i = 0;
                while ((long)i < recordCount) {
                    byte[] keyBytes = (byte[])ois.readObject();
                    byte[] dataBytes = (byte[])ois.readObject();
                    DatabaseEntry key = new DatabaseEntry(keyBytes);
                    DatabaseEntry data = new DatabaseEntry(dataBytes);
                    cursor.put(key, data);
                    ++i;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.completeCurrentTransaction(true);
        }
        catch (Exception caught) {
            this.completeCurrentTransaction(false);
            this.clear();
            throw this.convertToCacheLoaderException("Problems reading from stream", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(ObjectOutput oos) throws CacheLoaderException {
        try {
            this.currentTransaction.beginTransaction(null);
            long recordCount = this.cacheDb.count();
            if (trace) {
                log.trace((Object)"writing {0} records to stream", new Object[]{recordCount});
            }
            oos.writeLong(recordCount);
            Cursor cursor = null;
            try {
                cursor = this.cacheDb.openCursor(this.currentTransaction.getTransaction(), null);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                int recordsWritten = 0;
                while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                    oos.writeObject(key.getData());
                    oos.writeObject(data.getData());
                    ++recordsWritten;
                }
                if (trace) {
                    log.trace((Object)"wrote {0} records to stream", new Object[]{recordsWritten});
                }
                if ((long)recordsWritten != recordCount) {
                    log.warn((Object)"expected to write {0} records, but wrote {1}", new Object[]{recordCount, recordsWritten});
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.completeCurrentTransaction(true);
        }
        catch (Exception caught) {
            this.completeCurrentTransaction(false);
            throw this.convertToCacheLoaderException("Problems writing to stream", caught);
        }
    }

    CacheLoaderException convertToCacheLoaderException(String message, Exception caught) {
        return (caught = ExceptionUnwrapper.unwrap((Exception)caught)) instanceof CacheLoaderException ? (CacheLoaderException)caught : new CacheLoaderException(message, (Throwable)caught);
    }

    protected void purgeInternal() throws CacheLoaderException {
        try {
            Iterator i = this.cacheMap.entrySet().iterator();
            while (i.hasNext()) {
                if (!((InternalCacheEntry)((Map.Entry)i.next()).getValue()).isExpired()) continue;
                i.remove();
            }
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error purging expired entries", caught);
        }
    }

    public void printLicense() {
        String license = "\n*************************************************************************************\nBerkeley DB Java Edition version: " + JEVersion.CURRENT_VERSION.toString() + "\n" + "JBoss Cache can use Berkeley DB Java Edition from Oracle \n" + "(http://www.oracle.com/database/berkeley-db/je/index.html)\n" + "for persistent, reliable and transaction-protected data storage.\n" + "If you choose to use Berkeley DB Java Edition with JBoss Cache, you must comply with the terms\n" + "of Oracle's public license, included in the file LICENSE.txt.\n" + "If you prefer not to release the source code for your own application in order to comply\n" + "with the Oracle public license, you may purchase a different license for use of\n" + "Berkeley DB Java Edition with JBoss Cache.\n" + "See http://www.oracle.com/database/berkeley-db/je/index.html for pricing and license terms\n" + "*************************************************************************************";
        System.out.println(license);
    }
}

