/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.bdbje;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.util.ExceptionUnwrapper;
import java.io.File;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loader.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loader.bdbje.PreparableTransactionRunner;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

public class BdbjeResourceFactory {
    private static final Log log = LogFactory.getLog(BdbjeResourceFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private BdbjeCacheStoreConfig config;

    public BdbjeResourceFactory(BdbjeCacheStoreConfig config) {
        this.config = config;
    }

    public PreparableTransactionRunner createPreparableTransactionRunner(Environment env) {
        return new PreparableTransactionRunner(env, this.config.getMaxTxRetries(), null);
    }

    public CurrentTransaction createCurrentTransaction(Environment env) {
        return CurrentTransaction.getInstance((Environment)env);
    }

    public Environment createEnvironment(File envLocation) throws DatabaseException {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setLockTimeout(this.config.getLockAcquistionTimeout() * 1000L);
        if (trace) {
            log.trace((Object)"opening or creating je environment at {0}", new Object[]{envLocation});
        }
        Environment env = new Environment(envLocation, envConfig);
        log.debug((Object)"opened je environment at {0}", new Object[]{envLocation});
        return env;
    }

    public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
        StoredClassCatalog catalog = new StoredClassCatalog(catalogDb);
        log.debug((Object)"created stored class catalog from database {0}", new Object[]{this.config.getCatalogDbName()});
        return catalog;
    }

    public Database createDatabase(Environment env, String name) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        if (trace) {
            log.trace((Object)"opening or creating database {0}", new Object[]{name});
        }
        Database db = env.openDatabase(null, name, dbConfig);
        log.debug((Object)"opened database {0}", new Object[]{name});
        return db;
    }

    public StoredMap createStoredMapViewOfDatabase(Database database, StoredClassCatalog classCatalog) throws DatabaseException {
        SerialBinding storedEntryKeyBinding = new SerialBinding((ClassCatalog)classCatalog, Object.class);
        SerialBinding storedEntryValueBinding = new SerialBinding((ClassCatalog)classCatalog, InternalCacheEntry.class);
        try {
            return new StoredMap(database, (EntryBinding)storedEntryKeyBinding, (EntryBinding)storedEntryValueBinding, true);
        }
        catch (Exception caught) {
            caught = ExceptionUnwrapper.unwrap((Exception)caught);
            throw new DatabaseException("error opening stored map", (Throwable)caught);
        }
    }
}

