/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.bdbje;

import com.sleepycat.collections.TransactionWorker;
import java.util.List;
import org.infinispan.loader.CacheStore;
import org.infinispan.loader.modifications.Modification;
import org.infinispan.loader.modifications.Remove;
import org.infinispan.loader.modifications.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationsTransactionWorker
implements TransactionWorker {
    private List<? extends Modification> mods;
    private CacheStore cs;

    public ModificationsTransactionWorker(CacheStore store, List<? extends Modification> mods) {
        this.cs = store;
        this.mods = mods;
    }

    public void doWork() throws Exception {
        block6: for (Modification modification : this.mods) {
            switch (modification.getType()) {
                case STORE: {
                    Store s = (Store)modification;
                    this.cs.store(s.getStoredEntry());
                    continue block6;
                }
                case CLEAR: {
                    this.cs.clear();
                    continue block6;
                }
                case REMOVE: {
                    Remove r = (Remove)modification;
                    this.cs.remove(r.getKey());
                    continue block6;
                }
                case PURGE_EXPIRED: {
                    this.cs.purgeExpired();
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown modification type " + modification.getType());
        }
    }
}

