/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import org.infinispan.config.ConfigurationElement;
import org.infinispan.config.ConfigurationElements;
import org.infinispan.config.ConfigurationProperty;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.bdbje.BdbjeCacheStore;

@ConfigurationElements(elements={@ConfigurationElement(name="loader", parent="loaders", description="org.infinispan.loaders.bdbje.BdbjeCacheStore", cardinalityInParent=ConfigurationElement.Cardinality.UNBOUNDED), @ConfigurationElement(name="properties", parent="loader")})
public class BdbjeCacheStoreConfig
extends AbstractCacheStoreConfig {
    private String location = "Infinispan-BdbjeCacheStore";
    private long lockAcquistionTimeout = 60000L;
    private int maxTxRetries = 5;
    private String cacheDbNamePrefix;
    private String catalogDbName;
    private String expiryDbPrefix;
    private String cacheName;

    public String getExpiryDbPrefix() {
        return this.expiryDbPrefix;
    }

    public String getExpiryDbName() {
        if (this.expiryDbPrefix != null) {
            return this.expiryDbPrefix + "_" + this.cacheName;
        }
        return this.cacheName + "_expiry";
    }

    @ConfigurationProperty(name="expiryDbNamePrefix", parentElement="properties")
    public void setExpiryDbNamePrefix(String expiryDbName) {
        this.expiryDbPrefix = expiryDbName;
    }

    public BdbjeCacheStoreConfig() {
        this.setCacheLoaderClassName(BdbjeCacheStore.class.getName());
    }

    public int getMaxTxRetries() {
        return this.maxTxRetries;
    }

    @ConfigurationProperty(name="maxTxRetries", parentElement="properties")
    public void setMaxTxRetries(int maxTxRetries) {
        this.maxTxRetries = maxTxRetries;
    }

    public long getLockAcquistionTimeout() {
        return this.lockAcquistionTimeout;
    }

    @ConfigurationProperty(name="lockAcquistionTimeout", parentElement="properties")
    public void setLockAcquistionTimeout(long lockAcquistionTimeout) {
        this.lockAcquistionTimeout = lockAcquistionTimeout;
    }

    public String getLocation() {
        return this.location;
    }

    @ConfigurationProperty(name="location", parentElement="properties")
    public void setLocation(String location) {
        this.testImmutability("location");
        this.location = location;
    }

    public String getCacheDbNamePrefix() {
        return this.cacheDbNamePrefix;
    }

    @ConfigurationProperty(name="cacheDbNamePrefix", parentElement="properties")
    public void setCacheDbNamePrefix(String cacheDbNamePrefix) {
        this.cacheDbNamePrefix = cacheDbNamePrefix;
    }

    public String getCatalogDbName() {
        return this.catalogDbName;
    }

    @ConfigurationProperty(name="catalogDbName", parentElement="properties")
    public void setCatalogDbName(String catalogDbName) {
        this.catalogDbName = catalogDbName;
    }

    void setCacheName(String name) {
        this.cacheName = name;
    }

    public String getCacheDbName() {
        if (this.cacheDbNamePrefix != null) {
            return this.cacheDbNamePrefix + "_" + this.cacheName;
        }
        return this.cacheName;
    }
}

