/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.BdbjeCacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.BdbjeCacheStoreConfigTest")
public class BdbjeCacheStoreConfigTest {
    private BdbjeCacheStoreConfig config;

    @BeforeMethod
    public void setUp() throws Exception {
        this.config = new BdbjeCacheStoreConfig();
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        this.config = null;
    }

    @Test
    public void testGetClassNameDefault() {
        assert (this.config.getCacheLoaderClassName().equals(BdbjeCacheStore.class.getName()));
    }

    @Test
    public void testGetMaxTxRetries() {
        assert (this.config.getMaxTxRetries() == 5);
    }

    @Test
    public void testSetMaxTxRetries() {
        this.config.setMaxTxRetries(1);
        assert (this.config.getMaxTxRetries() == 1);
    }

    @Test
    public void testGetLockAcquistionTimeout() {
        assert (this.config.getLockAcquistionTimeout() == 60000L);
    }

    @Test
    public void testSetLockAcquistionTimeoutMicros() {
        this.config.setLockAcquistionTimeout(1L);
        assert (this.config.getLockAcquistionTimeout() == 1L);
    }

    @Test
    public void testGetLocationDefault() {
        assert (this.config.getLocation().equals("Infinispan-BdbjeCacheStore"));
    }

    @Test
    public void testSetLocation() {
        this.config.setLocation("foo");
        assert (this.config.getLocation().equals("foo"));
    }

    @Test
    public void testSetCacheDb() {
        this.config.setCacheDbNamePrefix("foo");
        assert (this.config.getCacheDbNamePrefix().equals("foo"));
    }

    @Test
    public void testSetCatalogDb() {
        this.config.setCatalogDbName("foo");
        assert (this.config.getCatalogDbName().equals("foo"));
    }

    @Test
    public void testSetExpiryDb() {
        this.config.setExpiryDbNamePrefix("foo");
        assert (this.config.getExpiryDbPrefix().equals("foo"));
    }
}

