/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import java.util.Collections;
import org.easymock.classextension.EasyMock;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.bdbje.ModificationsTransactionWorker;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.PurgeExpired;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.ModificationsTransactionWorkerTest")
public class ModificationsTransactionWorkerTest {
    @Test
    public void testDoWorkOnStore() throws Exception {
        CacheStore cs = (CacheStore)EasyMock.createMock(CacheStore.class);
        Store store = (Store)EasyMock.createMock(Store.class);
        InternalCacheEntry entry = InternalEntryFactory.create((Object)"1", (Object)"2");
        EasyMock.expect((Object)store.getType()).andReturn((Object)Modification.Type.STORE);
        EasyMock.expect((Object)store.getStoredEntry()).andReturn((Object)entry);
        cs.store(entry);
        EasyMock.replay((Object[])new Object[]{cs});
        EasyMock.replay((Object[])new Object[]{store});
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(store));
        worker.doWork();
        EasyMock.verify((Object[])new Object[]{cs});
        EasyMock.verify((Object[])new Object[]{store});
    }

    @Test
    public void testDoWorkOnRemove() throws Exception {
        CacheStore cs = (CacheStore)EasyMock.createMock(CacheStore.class);
        Remove store = (Remove)EasyMock.createMock(Remove.class);
        EasyMock.expect((Object)store.getType()).andReturn((Object)Modification.Type.REMOVE);
        EasyMock.expect((Object)store.getKey()).andReturn((Object)"1");
        EasyMock.expect((Object)cs.remove((Object)"1")).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cs});
        EasyMock.replay((Object[])new Object[]{store});
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(store));
        worker.doWork();
        EasyMock.verify((Object[])new Object[]{cs});
        EasyMock.verify((Object[])new Object[]{store});
    }

    @Test
    public void testDoWorkOnClear() throws Exception {
        CacheStore cs = (CacheStore)EasyMock.createMock(CacheStore.class);
        Clear clear = (Clear)EasyMock.createMock(Clear.class);
        EasyMock.expect((Object)clear.getType()).andReturn((Object)Modification.Type.CLEAR);
        cs.clear();
        EasyMock.replay((Object[])new Object[]{cs});
        EasyMock.replay((Object[])new Object[]{clear});
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(clear));
        worker.doWork();
        EasyMock.verify((Object[])new Object[]{cs});
        EasyMock.verify((Object[])new Object[]{clear});
    }

    @Test
    public void testDoWorkOnPurgeExpired() throws Exception {
        CacheStore cs = (CacheStore)EasyMock.createMock(CacheStore.class);
        PurgeExpired purge = (PurgeExpired)EasyMock.createMock(PurgeExpired.class);
        EasyMock.expect((Object)purge.getType()).andReturn((Object)Modification.Type.PURGE_EXPIRED);
        cs.purgeExpired();
        EasyMock.replay((Object[])new Object[]{cs});
        EasyMock.replay((Object[])new Object[]{purge});
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(purge));
        worker.doWork();
        EasyMock.verify((Object[])new Object[]{cs});
        EasyMock.verify((Object[])new Object[]{purge});
    }
}

