/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.txn.Locker;
import org.easymock.classextension.EasyMock;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.PreparableTransactionRunnerTest")
public class PreparableTransactionRunnerTest {
    PreparableTransactionRunner runner;
    Environment env;
    EnvironmentConfig config;
    TransactionWorker worker;
    Transaction transaction;

    @BeforeMethod
    public void setUp() throws Exception {
        this.config = (EnvironmentConfig)EasyMock.createMock(EnvironmentConfig.class);
        org.easymock.EasyMock.expect((Object)this.config.getTransactional()).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)this.config.getLocking()).andReturn((Object)true);
        this.transaction = (Transaction)EasyMock.createMock(Transaction.class);
        this.env = (Environment)EasyMock.createMock(Environment.class);
        org.easymock.EasyMock.expect((Object)this.env.getConfig()).andReturn((Object)this.config);
        org.easymock.EasyMock.expect((Object)this.env.beginTransaction(null, null)).andReturn((Object)this.transaction);
        this.worker = (TransactionWorker)EasyMock.createMock(TransactionWorker.class);
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        this.runner = null;
        this.env = null;
        this.config = null;
    }

    @Test
    public void testMoreDeadlocks() throws Exception {
        Locker mockLocker = (Locker)EasyMock.createNiceMock(Locker.class);
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new LockTimeoutException(mockLocker, ""));
        this.transaction.abort();
        org.easymock.EasyMock.expect((Object)this.env.beginTransaction(null, null)).andReturn((Object)this.transaction);
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new LockTimeoutException(mockLocker, ""));
        this.transaction.abort();
        org.easymock.EasyMock.expect((Object)this.env.beginTransaction(null, null)).andReturn((Object)this.transaction);
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new LockTimeoutException(mockLocker, ""));
        this.transaction.abort();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env, 2, null);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten a deadlock exception";
        }
        catch (LockTimeoutException lockTimeoutException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testPrepare() throws Exception {
        this.worker.doWork();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.prepare(this.worker);
        this.verifyAll();
    }

    @Test
    public void testRun() throws Exception {
        this.transaction.commit();
        this.worker.doWork();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.run(this.worker);
        this.verifyAll();
    }

    @Test
    public void testOneArgConstructorSetsCurrentTxn() throws Exception {
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        assert (CurrentTransaction.getInstance((Environment)this.env) == this.runner.currentTxn);
    }

    @Test
    public void testSetMaxRetries() throws Exception {
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setMaxRetries(1);
        assert (this.runner.getMaxRetries() == 1);
    }

    @Test
    public void testSetAllowNestedTransactions() throws Exception {
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setAllowNestedTransactions(false);
        assert (!this.runner.getAllowNestedTransactions());
        try {
            this.runner.setAllowNestedTransactions(true);
            assert (false) : "should have gotten Exception";
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTransactionConfig() throws Exception {
        this.replayAll();
        TransactionConfig config = new TransactionConfig();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setTransactionConfig(config);
        assert (this.runner.getTransactionConfig().equals(config));
    }

    @Test
    public void testExceptionThrownInPrepare() throws Exception {
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException());
        this.transaction.abort();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testErrorThrownInPrepare() throws Exception {
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new Error());
        this.transaction.abort();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (Error error) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testExceptionThrownInRun() throws Exception {
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException());
        this.transaction.abort();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.verifyAll();
    }

    @Test
    public void testErrorThrownInRun() throws Exception {
        this.worker.doWork();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new Error());
        this.transaction.abort();
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.run(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (Error error) {
            // empty catch block
        }
        this.verifyAll();
    }

    public void testRethrowIfNotDeadLockDoesntThrowWhenGivenDeadlockException() throws Exception {
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.rethrowIfNotDeadLock((Throwable)EasyMock.createNiceMock(LockTimeoutException.class));
    }

    public void testThrowableDuringAbort() throws Exception {
        this.transaction.abort();
        org.easymock.EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException());
        this.replayAll();
        this.runner = new PreparableTransactionRunner(this.env);
        CurrentTransaction.getInstance((Environment)this.env).beginTransaction(null);
        int max = this.runner.abortOverflowingCurrentTriesOnError(this.transaction, 2);
        assert (max == Integer.MAX_VALUE) : "should have overflowed max tries, but got " + max;
        this.verifyAll();
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.replay((Object[])new Object[]{this.env});
        EasyMock.replay((Object[])new Object[]{this.transaction});
        EasyMock.replay((Object[])new Object[]{this.worker});
    }

    private void verifyAll() {
        EasyMock.verify((Object[])new Object[]{this.config});
        EasyMock.verify((Object[])new Object[]{this.env});
        EasyMock.verify((Object[])new Object[]{this.transaction});
        EasyMock.verify((Object[])new Object[]{this.worker});
    }
}

