/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.util.ExceptionUnwrapper;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.bdbje.InternalCacheEntryBinding;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BdbjeResourceFactory {
    private static final Log log = LogFactory.getLog(BdbjeResourceFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private BdbjeCacheStoreConfig config;

    public BdbjeResourceFactory(BdbjeCacheStoreConfig config) {
        this.config = config;
    }

    public PreparableTransactionRunner createPreparableTransactionRunner(Environment env) {
        return new PreparableTransactionRunner(env, this.config.getMaxTxRetries(), null);
    }

    public CurrentTransaction createCurrentTransaction(Environment env) {
        return CurrentTransaction.getInstance((Environment)env);
    }

    public Environment createEnvironment(File envLocation, Properties environmentProperties) throws DatabaseException {
        EnvironmentConfig envConfig = environmentProperties == null ? new EnvironmentConfig() : new EnvironmentConfig(environmentProperties);
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setLockTimeout(this.config.getLockAcquistionTimeout(), TimeUnit.MILLISECONDS);
        if (trace) {
            log.trace((Object)"opening or creating je environment at %s", new Object[]{envLocation});
        }
        Environment env = new Environment(envLocation, envConfig);
        log.debug((Object)"opened je environment at %s", new Object[]{envLocation});
        return env;
    }

    public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
        StoredClassCatalog catalog = new StoredClassCatalog(catalogDb);
        log.debug((Object)"created stored class catalog from database %s", new Object[]{this.config.getCatalogDbName()});
        return catalog;
    }

    public Database createDatabase(Environment env, String name) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        if (trace) {
            log.trace((Object)"opening or creating database %s", new Object[]{name});
        }
        Database db = env.openDatabase(null, name, dbConfig);
        log.debug((Object)"opened database %s", new Object[]{name});
        return db;
    }

    public StoredMap<Object, InternalCacheEntry> createStoredMapViewOfDatabase(Database database, StoredClassCatalog classCatalog, StreamingMarshaller m) throws DatabaseException {
        SerialBinding storedEntryKeyBinding = new SerialBinding((ClassCatalog)classCatalog, Object.class);
        InternalCacheEntryBinding storedEntryValueBinding = new InternalCacheEntryBinding(m);
        try {
            return new StoredMap(database, (EntryBinding)storedEntryKeyBinding, (EntryBinding)storedEntryValueBinding, true);
        }
        catch (Exception caught) {
            caught = ExceptionUnwrapper.unwrap((Exception)caught);
            throw new CacheException("Error opening stored map", (Throwable)caught);
        }
    }

    public StoredSortedMap<Long, Object> createStoredSortedMapForKeyExpiry(Database database, StoredClassCatalog classCatalog, StreamingMarshaller marshaller) throws DatabaseException {
        SerialBinding expiryKeyBinding = new SerialBinding((ClassCatalog)classCatalog, Long.class);
        SerialBinding expiryValueBinding = new SerialBinding((ClassCatalog)classCatalog, Object.class);
        try {
            return new StoredSortedMap(database, (EntryBinding)expiryKeyBinding, (EntryBinding)expiryValueBinding, true);
        }
        catch (Exception caught) {
            caught = ExceptionUnwrapper.unwrap((Exception)caught);
            throw new CacheException("error opening stored map", (Throwable)caught);
        }
    }
}

