/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.TransactionRunner;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.transaction.Transaction;
import org.easymock.EasyMock;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.InternalCacheEntryBinding;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.BdbjeLearningTest")
public class BdbjeLearningTest
extends AbstractInfinispanTest {
    Environment env;
    private static final String CLASS_CATALOG = "java_class_catalog";
    private StoredClassCatalog javaCatalog;
    private static final String STORED_ENTRIES = "storedEntriesDb";
    private Database storedEntriesDb;
    private StoredMap<Object, InternalCacheEntry> cacheMap;
    private String tmpDirectory;
    private static final Log log = LogFactory.getLog(BdbjeLearningTest.class);
    Map<Transaction, com.sleepycat.je.Transaction> txnMap = new HashMap<Transaction, com.sleepycat.je.Transaction>();

    @BeforeTest
    @Parameters(value={"basedir"})
    protected void setUpTempDir(@Optional(value="/tmp") String basedir) {
        this.tmpDirectory = TestingUtil.tmpDirectory((String)basedir, (AbstractInfinispanTest)this);
    }

    @AfterTest
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    @BeforeMethod
    public void setUp() throws Exception {
        new File(this.tmpDirectory).mkdirs();
        System.out.println("Opening environment in: " + this.tmpDirectory);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        this.env = new Environment(new File(this.tmpDirectory), envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        Database catalogDb = this.env.openDatabase(null, CLASS_CATALOG, dbConfig);
        this.javaCatalog = new StoredClassCatalog(catalogDb);
        SerialBinding storedEntryKeyBinding = new SerialBinding((ClassCatalog)this.javaCatalog, Object.class);
        InternalCacheEntryBinding storedEntryValueBinding = new InternalCacheEntryBinding((StreamingMarshaller)new TestObjectStreamMarshaller());
        this.storedEntriesDb = this.env.openDatabase(null, STORED_ENTRIES, dbConfig);
        this.cacheMap = new StoredMap(this.storedEntriesDb, (EntryBinding)storedEntryKeyBinding, (EntryBinding)storedEntryValueBinding, true);
    }

    public void testTransactionWorker() throws Exception {
        TransactionRunner runner = new TransactionRunner(this.env);
        runner.run((TransactionWorker)new PopulateDatabase());
        runner.run((TransactionWorker)new PrintDatabase());
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.storedEntriesDb.close();
        this.javaCatalog.close();
        this.env.close();
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
    }

    private void store(InternalCacheEntry se) {
        this.cacheMap.put(se.getKey(), (Object)se);
    }

    private InternalCacheEntry load(Object key) {
        InternalCacheEntry s = (InternalCacheEntry)this.cacheMap.get(key);
        if (s == null) {
            return null;
        }
        if (!s.isExpired()) {
            return s;
        }
        this.cacheMap.remove(key);
        return null;
    }

    private Set loadAll() {
        return new HashSet(this.cacheMap.values());
    }

    private void purgeExpired() {
        Iterator i = this.cacheMap.entrySet().iterator();
        while (i.hasNext()) {
            if (!((InternalCacheEntry)((Map.Entry)i.next()).getValue()).isExpired()) continue;
            i.remove();
        }
    }

    private void toStream(OutputStream outputStream) throws CacheLoaderException {
        ObjectOutputStream oos = null;
        Cursor cursor = null;
        try {
            oos = outputStream instanceof ObjectOutputStream ? (ObjectOutputStream)outputStream : new ObjectOutputStream(outputStream);
            long recordCount = this.storedEntriesDb.count();
            log.trace((Object)"writing {0} records to stream", new Object[]{recordCount});
            oos.writeLong(recordCount);
            cursor = this.storedEntriesDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                oos.writeObject(key.getData());
                oos.writeObject(data.getData());
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException("Error writing to object stream", (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new CacheLoaderException("Error accessing database", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException e) {
                    throw new CacheLoaderException("Error closing cursor", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fromStream(InputStream inputStream) throws CacheLoaderException {
        ObjectInputStream ois = null;
        try {
            ois = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : new ObjectInputStream(inputStream);
            long recordCount = ois.readLong();
            log.info((Object)"reading {0} records from stream", new Object[]{recordCount});
            log.info((Object)"clearing all records");
            this.cacheMap.clear();
            Cursor cursor = null;
            com.sleepycat.je.Transaction txn = this.env.beginTransaction(null, null);
            try {
                cursor = this.storedEntriesDb.openCursor(txn, null);
                int i = 0;
                while ((long)i < recordCount) {
                    byte[] keyBytes = (byte[])ois.readObject();
                    byte[] dataBytes = (byte[])ois.readObject();
                    DatabaseEntry key = new DatabaseEntry(keyBytes);
                    DatabaseEntry data = new DatabaseEntry(dataBytes);
                    cursor.put(key, data);
                    ++i;
                }
                cursor.close();
                cursor = null;
                txn.commit();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (Exception e) {
            throw e instanceof CacheLoaderException ? (CacheLoaderException)((Object)e) : new CacheLoaderException("Problems reading from stream", (Throwable)e);
        }
    }

    private void prepare(List<Modification> mods, Transaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            TransactionRunner runner = new TransactionRunner(this.env);
            try {
                runner.run((TransactionWorker)new ModificationsTransactionWorker(mods));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PreparableTransactionRunner runner = new PreparableTransactionRunner(this.env);
            com.sleepycat.je.Transaction txn = null;
            try {
                runner.prepare((TransactionWorker)new ModificationsTransactionWorker(mods));
                txn = CurrentTransaction.getInstance((Environment)this.env).getTransaction();
                this.txnMap.put(tx, txn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void commit(Transaction tx) {
        com.sleepycat.je.Transaction txn = this.txnMap.remove(tx);
        CurrentTransaction currentTransaction = CurrentTransaction.getInstance((Environment)this.env);
        if (txn != null) {
            if (currentTransaction.getTransaction() == txn) {
                try {
                    currentTransaction.commitTransaction();
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            } else {
                log.error((Object)"Transactions must be committed on the same thread");
            }
        }
    }

    private void rollback(Transaction tx) {
        com.sleepycat.je.Transaction txn = this.txnMap.remove(tx);
        CurrentTransaction currentTransaction = CurrentTransaction.getInstance((Environment)this.env);
        if (txn != null) {
            if (currentTransaction.getTransaction() == txn) {
                try {
                    currentTransaction.abortTransaction();
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            } else {
                log.error((Object)"Transactions must be committed on the same thread");
            }
        }
    }

    public void testLoadAndStore() throws InterruptedException, CacheLoaderException {
        assert (!this.cacheMap.containsKey((Object)"k"));
        InternalCacheEntry se = InternalEntryFactory.create((Object)"k", (Object)"v");
        this.store(se);
        assert (this.load("k").getValue().equals("v"));
        assert (this.load("k").getLifespan() == -1L);
        assert (!this.load("k").isExpired());
        assert (this.cacheMap.containsKey((Object)"k"));
        long lifespan = 120000L;
        se = InternalEntryFactory.create((Object)"k", (Object)"v", (long)lifespan);
        this.store(se);
        assert (this.load("k").getValue().equals("v"));
        assert (this.load("k").getLifespan() == lifespan);
        assert (!this.load("k").isExpired());
        assert (this.cacheMap.containsKey((Object)"k"));
        lifespan = 1L;
        se = InternalEntryFactory.create((Object)"k", (Object)"v", (long)lifespan);
        this.store(se);
        Thread.sleep(100L);
        assert (se.isExpired());
        assert (this.load("k") == null);
        assert (!this.cacheMap.containsKey((Object)"k"));
    }

    public void testOnePhaseCommit() throws CacheLoaderException {
        ArrayList<Object> mods = new ArrayList<Modification>();
        mods.add(new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Remove((Object)"k1"));
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.prepare(mods, tx, true);
        Set s = this.loadAll();
        assert (this.load("k2").getValue().equals("v2"));
        assert (!this.cacheMap.containsKey((Object)"k1"));
        this.cacheMap.clear();
        mods = new ArrayList();
        mods.add((Modification)new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Clear());
        mods.add(new Store(InternalEntryFactory.create((Object)"k3", (Object)"v3")));
        this.prepare(mods, tx, true);
        assert (!this.cacheMap.containsKey((Object)"k1"));
        assert (!this.cacheMap.containsKey((Object)"k2"));
        assert (this.cacheMap.containsKey((Object)"k3"));
    }

    public void testTwoPhaseCommit() throws Throwable {
        final ArrayList throwables = new ArrayList();
        ArrayList<Object> mods = new ArrayList<Modification>();
        mods.add(new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Remove((Object)"k1"));
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.prepare(mods, tx, false);
        Thread gets1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (BdbjeLearningTest.this.load("k2").getValue().equals("v2"));
                    assert (!BdbjeLearningTest.this.cacheMap.containsKey((Object)"k1"));
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
        });
        gets1.start();
        this.commit(tx);
        gets1.join();
        if (!throwables.isEmpty()) {
            throw (Throwable)throwables.get(0);
        }
        this.cacheMap.clear();
        mods = new ArrayList();
        mods.add((Modification)new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Clear());
        mods.add(new Store(InternalEntryFactory.create((Object)"k3", (Object)"v3")));
        this.prepare(mods, tx, false);
        Thread gets2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (!BdbjeLearningTest.this.cacheMap.containsKey((Object)"k1"));
                    assert (!BdbjeLearningTest.this.cacheMap.containsKey((Object)"k2"));
                    assert (BdbjeLearningTest.this.cacheMap.containsKey((Object)"k3"));
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
        });
        gets2.start();
        this.commit(tx);
        gets2.join();
        if (!throwables.isEmpty()) {
            throw (Throwable)throwables.get(0);
        }
        assert (!this.cacheMap.containsKey((Object)"k1"));
        assert (!this.cacheMap.containsKey((Object)"k2"));
        assert (this.cacheMap.containsKey((Object)"k3"));
    }

    public void testRollback() throws Throwable {
        this.store(InternalEntryFactory.create((Object)"old", (Object)"old"));
        ArrayList<Object> mods = new ArrayList<Modification>();
        mods.add(new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Remove((Object)"k1"));
        mods.add(new Remove((Object)"old"));
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.prepare(mods, tx, false);
        this.rollback(tx);
        assert (!this.cacheMap.containsKey((Object)"k1"));
        assert (!this.cacheMap.containsKey((Object)"k2"));
        assert (this.cacheMap.containsKey((Object)"old"));
        mods = new ArrayList();
        mods.add((Modification)new Store(InternalEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(InternalEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Clear());
        mods.add(new Store(InternalEntryFactory.create((Object)"k3", (Object)"v3")));
        this.prepare(mods, tx, false);
        this.rollback(tx);
        assert (!this.cacheMap.containsKey((Object)"k1"));
        assert (!this.cacheMap.containsKey((Object)"k2"));
        assert (!this.cacheMap.containsKey((Object)"k3"));
        assert (this.cacheMap.containsKey((Object)"old"));
    }

    public void testCommitAndRollbackWithoutPrepare() throws CacheLoaderException {
        this.store(InternalEntryFactory.create((Object)"old", (Object)"old"));
        Transaction tx = (Transaction)EasyMock.createNiceMock(Transaction.class);
        this.commit(tx);
        this.store(InternalEntryFactory.create((Object)"old", (Object)"old"));
        this.rollback(tx);
        assert (this.cacheMap.containsKey((Object)"old"));
    }

    public void testPreload() throws CacheLoaderException {
        this.store(InternalEntryFactory.create((Object)"k1", (Object)"v1"));
        this.store(InternalEntryFactory.create((Object)"k2", (Object)"v2"));
        this.store(InternalEntryFactory.create((Object)"k3", (Object)"v3"));
        Set set = this.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testPurgeExpired() throws Exception {
        long now = System.currentTimeMillis();
        long lifespan = 1000L;
        this.store(InternalEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan));
        this.store(InternalEntryFactory.create((Object)"k2", (Object)"v2", (long)lifespan));
        this.store(InternalEntryFactory.create((Object)"k3", (Object)"v3", (long)lifespan));
        assert (this.cacheMap.containsKey((Object)"k1"));
        assert (this.cacheMap.containsKey((Object)"k2"));
        assert (this.cacheMap.containsKey((Object)"k3"));
        Thread.sleep(lifespan + 100L);
        this.purgeExpired();
        assert (!this.cacheMap.containsKey((Object)"k1"));
        assert (!this.cacheMap.containsKey((Object)"k2"));
        assert (!this.cacheMap.containsKey((Object)"k3"));
    }

    public void testStreamingAPI() throws IOException, ClassNotFoundException, CacheLoaderException {
        this.store(InternalEntryFactory.create((Object)"k1", (Object)"v1"));
        this.store(InternalEntryFactory.create((Object)"k2", (Object)"v2"));
        this.store(InternalEntryFactory.create((Object)"k3", (Object)"v3"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toStream(out);
        out.close();
        this.cacheMap.clear();
        this.fromStream(new ByteArrayInputStream(out.toByteArray()));
        Set set = this.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testStreamingAPIReusingStreams() throws IOException, ClassNotFoundException, CacheLoaderException {
        byte i;
        this.store(InternalEntryFactory.create((Object)"k1", (Object)"v1"));
        this.store(InternalEntryFactory.create((Object)"k2", (Object)"v2"));
        this.store(InternalEntryFactory.create((Object)"k3", (Object)"v3"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dummyStartBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] dummyEndBytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        out.write(dummyStartBytes);
        this.toStream(out);
        out.write(dummyEndBytes);
        out.close();
        this.cacheMap.clear();
        byte[] dummy = new byte[8];
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        int bytesRead = in.read(dummy, 0, 8);
        assert (bytesRead == 8);
        for (i = 1; i < 9; ++i) {
            assert (dummy[i - 1] == i) : "Start byte stream corrupted!";
        }
        this.fromStream(in);
        bytesRead = in.read(dummy, 0, 8);
        assert (bytesRead == 8);
        for (i = 8; i > 0; --i) {
            assert (dummy[8 - i] == i) : "Start byte stream corrupted!";
        }
        Set set = this.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    @Test(enabled=false)
    public void testConcurrency() throws Throwable {
        int i;
        int numThreads = 3;
        int loops = 500;
        final String[] keys = new String[10];
        final String[] values = new String[10];
        for (i = 0; i < 10; ++i) {
            keys[i] = "k" + i;
        }
        for (i = 0; i < 10; ++i) {
            values[i] = "v" + i;
        }
        final Random r = new Random();
        final LinkedList throwables = new LinkedList();
        final Runnable store = new Runnable(){

            @Override
            public void run() {
                try {
                    int randomInt = r.nextInt(10);
                    BdbjeLearningTest.this.store(InternalEntryFactory.create((Object)keys[randomInt], (Object)values[randomInt]));
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
        };
        final Runnable remove = new Runnable(){

            @Override
            public void run() {
                try {
                    BdbjeLearningTest.this.cacheMap.remove((Object)keys[r.nextInt(10)]);
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
        };
        final Runnable get = new Runnable(){

            @Override
            public void run() {
                try {
                    int randomInt = r.nextInt(10);
                    InternalCacheEntry se = BdbjeLearningTest.this.load(keys[randomInt]);
                    assert (se == null || se.getValue().equals(values[randomInt]));
                    BdbjeLearningTest.this.loadAll();
                }
                catch (Throwable e) {
                    throwables.add(e);
                }
            }
        };
        Thread[] threads = new Thread[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            threads[i2] = new Thread(((Object)((Object)this)).getClass().getSimpleName() + "-" + i2){

                @Override
                public void run() {
                    for (int i = 0; i < 500; ++i) {
                        store.run();
                        remove.run();
                        get.run();
                    }
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (!throwables.isEmpty()) {
            throw (Throwable)throwables.get(0);
        }
    }

    class ModificationsTransactionWorker
    implements TransactionWorker {
        private List<? extends Modification> mods;

        ModificationsTransactionWorker(List<? extends Modification> mods) {
            this.mods = mods;
        }

        public void doWork() throws Exception {
            block6: for (Modification modification : this.mods) {
                switch (modification.getType()) {
                    case STORE: {
                        Store s = (Store)modification;
                        BdbjeLearningTest.this.store(s.getStoredEntry());
                        continue block6;
                    }
                    case CLEAR: {
                        BdbjeLearningTest.this.cacheMap.clear();
                        continue block6;
                    }
                    case REMOVE: {
                        Remove r = (Remove)modification;
                        BdbjeLearningTest.this.cacheMap.remove(r.getKey());
                        continue block6;
                    }
                    case PURGE_EXPIRED: {
                        BdbjeLearningTest.this.purgeExpired();
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unknown modification type " + modification.getType());
            }
        }
    }

    class PurgeExpiredTransactionWorker
    implements TransactionWorker {
        PurgeExpiredTransactionWorker() {
        }

        public void doWork() throws Exception {
            BdbjeLearningTest.this.purgeExpired();
        }
    }

    class RemoveTransactionWorker
    implements TransactionWorker {
        Object key;

        RemoveTransactionWorker(Object key) {
            this.key = key;
        }

        public void doWork() throws Exception {
            BdbjeLearningTest.this.cacheMap.remove(this.key);
        }
    }

    class ClearTransactionWorker
    implements TransactionWorker {
        ClearTransactionWorker() {
        }

        public void doWork() throws Exception {
            BdbjeLearningTest.this.cacheMap.clear();
        }
    }

    class StoreTransactionWorker
    implements TransactionWorker {
        private InternalCacheEntry entry;

        StoreTransactionWorker(InternalCacheEntry entry) {
            this.entry = entry;
        }

        public void doWork() throws Exception {
            BdbjeLearningTest.this.store(this.entry);
        }
    }

    private class PrintDatabase
    implements TransactionWorker {
        private PrintDatabase() {
        }

        public void doWork() throws Exception {
        }
    }

    private class PopulateDatabase
    implements TransactionWorker {
        private PopulateDatabase() {
        }

        public void doWork() throws Exception {
        }
    }
}

