/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Properties;
import org.easymock.classextension.EasyMock;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.BdbjeCacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.bdbje.BdbjeResourceFactory;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ReflectionUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.bdbje.BdbjeCacheStoreTest")
public class BdbjeCacheStoreTest {
    private BdbjeCacheStore cs;
    private BdbjeCacheStoreConfig cfg;
    private BdbjeResourceFactory factory;
    private Cache cache;
    private Environment env;
    private Database cacheDb;
    private Database catalogDb;
    private Database expiryDb;
    private StoredClassCatalog catalog;
    private StoredMap cacheMap;
    private StoredSortedMap expiryMap;
    private PreparableTransactionRunner runner;
    private CurrentTransaction currentTransaction;
    private TransactionFactory gtf;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cfg = new BdbjeCacheStoreConfig();
        this.factory = new MockBdbjeResourceFactory(this.cfg);
        this.cache = (Cache)EasyMock.createMock(Cache.class);
        this.cs = new BdbjeCacheStore();
        this.env = (Environment)EasyMock.createMock(Environment.class);
        this.cacheDb = (Database)EasyMock.createMock(Database.class);
        this.catalogDb = (Database)EasyMock.createMock(Database.class);
        this.expiryDb = (Database)EasyMock.createMock(Database.class);
        this.catalog = (StoredClassCatalog)EasyMock.createMock(StoredClassCatalog.class);
        this.cacheMap = (StoredMap)EasyMock.createMock(StoredMap.class);
        this.expiryMap = (StoredSortedMap)EasyMock.createMock(StoredSortedMap.class);
        this.currentTransaction = (CurrentTransaction)EasyMock.createMock(CurrentTransaction.class);
        this.gtf = new TransactionFactory();
        this.gtf.init(false, false, true);
        WeakReference<Environment> envRef = new WeakReference<Environment>(this.env);
        ReflectionUtil.setValue((Object)this.currentTransaction, (String)"envRef", envRef);
        ThreadLocal localTrans = new ThreadLocal();
        ReflectionUtil.setValue((Object)this.currentTransaction, (String)"localTrans", localTrans);
        this.runner = (PreparableTransactionRunner)EasyMock.createMock(PreparableTransactionRunner.class);
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        this.runner = null;
        this.currentTransaction = null;
        this.cacheMap = null;
        this.catalogDb = null;
        this.expiryDb = null;
        this.cacheDb = null;
        this.env = null;
        this.factory = null;
        this.cache = null;
        this.cfg = null;
        this.cs = null;
        this.gtf = null;
    }

    void start() throws DatabaseException, CacheLoaderException {
        this.cs.init(this.cfg, this.factory, this.cache, (StreamingMarshaller)new TestObjectStreamMarshaller());
        EasyMock.expect((Object)this.cache.getName()).andReturn((Object)"cache");
        EasyMock.expect((Object)this.cache.getConfiguration()).andReturn(null).anyTimes();
    }

    public void testGetConfigurationClass() throws Exception {
        this.replayAll();
        assert (this.cs.getConfigurationClass().equals(BdbjeCacheStoreConfig.class));
        this.verifyAll();
    }

    void replayAll() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.runner});
        EasyMock.replay((Object[])new Object[]{this.currentTransaction});
        EasyMock.replay((Object[])new Object[]{this.cacheMap});
        EasyMock.replay((Object[])new Object[]{this.expiryMap});
        EasyMock.replay((Object[])new Object[]{this.catalog});
        EasyMock.replay((Object[])new Object[]{this.catalogDb});
        EasyMock.replay((Object[])new Object[]{this.expiryDb});
        EasyMock.replay((Object[])new Object[]{this.cacheDb});
        EasyMock.replay((Object[])new Object[]{this.env});
        EasyMock.replay((Object[])new Object[]{this.cache});
    }

    void verifyAll() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.runner});
        EasyMock.verify((Object[])new Object[]{this.currentTransaction});
        EasyMock.verify((Object[])new Object[]{this.cacheMap});
        EasyMock.verify((Object[])new Object[]{this.expiryMap});
        EasyMock.verify((Object[])new Object[]{this.catalog});
        EasyMock.verify((Object[])new Object[]{this.catalogDb});
        EasyMock.verify((Object[])new Object[]{this.expiryDb});
        EasyMock.verify((Object[])new Object[]{this.env});
        EasyMock.verify((Object[])new Object[]{this.cache});
    }

    public void testInitNoMock() throws Exception {
        this.replayAll();
        this.cs.init((CacheLoaderConfig)this.cfg, this.cache, null);
        assert (this.cfg.equals(ReflectionUtil.getValue((Object)this.cs, (String)"cfg")));
        assert (this.cache.equals(ReflectionUtil.getValue((Object)this.cs, (String)"cache")));
        assert (ReflectionUtil.getValue((Object)this.cs, (String)"factory") instanceof BdbjeResourceFactory);
        this.verifyAll();
    }

    public void testExceptionClosingCacheDatabaseDoesNotPreventEnvironmentFromClosing() throws Exception {
        this.start();
        this.cacheDb.close();
        this.expiryDb.close();
        EasyMock.expectLastCall().andThrow((Throwable)new DatabaseException("Dummy"){});
        this.catalog.close();
        this.env.close();
        this.replayAll();
        this.cs.start();
        this.cs.stop();
        this.verifyAll();
    }

    public void testExceptionClosingCatalogDoesNotPreventEnvironmentFromClosing() throws Exception {
        this.start();
        this.cacheDb.close();
        this.expiryDb.close();
        this.catalog.close();
        EasyMock.expectLastCall().andThrow((Throwable)new DatabaseException("Dummy"){});
        this.env.close();
        this.replayAll();
        this.cs.start();
        this.cs.stop();
        this.verifyAll();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testExceptionClosingEnvironment() throws Exception {
        this.start();
        this.cacheDb.close();
        this.expiryDb.close();
        this.catalog.close();
        this.env.close();
        EasyMock.expectLastCall().andThrow((Throwable)new DatabaseException("Dummy"){});
        this.replayAll();
        this.cs.start();
        this.cs.stop();
        this.verifyAll();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testThrowsCorrectExceptionOnStartForDatabaseException() throws Exception {
        this.factory = new MockBdbjeResourceFactory(this.cfg){

            @Override
            public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
                throw new DatabaseException("Dummy"){};
            }
        };
        this.start();
        this.replayAll();
        this.cs.start();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testEnvironmentDirectoryExistsButNotAFile() throws Exception {
        File file = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)file.isDirectory()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{file});
        this.cs.verifyOrCreateEnvironmentDirectory(file);
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testCantCreateEnvironmentDirectory() throws Exception {
        File file = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)file.exists()).andReturn((Object)false);
        EasyMock.expect((Object)file.mkdirs()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{file});
        this.cs.verifyOrCreateEnvironmentDirectory(file);
    }

    public void testCanCreateEnvironmentDirectory() throws Exception {
        File file = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)file.exists()).andReturn((Object)false);
        EasyMock.expect((Object)file.mkdirs()).andReturn((Object)true);
        EasyMock.expect((Object)file.isDirectory()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{file});
        assert (file.equals(this.cs.verifyOrCreateEnvironmentDirectory(file)));
    }

    public void testNoExceptionOnRollback() throws Exception {
        this.start();
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.replayAll();
        this.cs.start();
        this.cs.rollback(tx);
        this.verifyAll();
    }

    public void testApplyModificationsThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        this.runner.run((TransactionWorker)EasyMock.isA(TransactionWorker.class));
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex));
        this.replayAll();
        this.cs.start();
        try {
            this.cs.applyModifications(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))));
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            this.verifyAll();
            return;
        }
        assert (false) : "should have returned";
    }

    public void testCommitThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        Transaction txn = (Transaction)EasyMock.createMock(Transaction.class);
        EasyMock.expect((Object)this.currentTransaction.beginTransaction(null)).andReturn((Object)txn);
        this.runner.prepare((TransactionWorker)EasyMock.isA(TransactionWorker.class));
        txn.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex));
        this.replayAll();
        EasyMock.replay((Object[])new Object[]{txn});
        this.cs.start();
        try {
            txn = this.currentTransaction.beginTransaction(null);
            GlobalTransaction t = this.gtf.newGlobalTransaction(null, false);
            this.cs.prepare(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))), t, false);
            this.cs.commit(t);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            this.verifyAll();
            return;
        }
        assert (false) : "should have returned";
    }

    public void testPrepareThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        this.runner.prepare((TransactionWorker)EasyMock.isA(TransactionWorker.class));
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex));
        this.replayAll();
        this.cs.start();
        try {
            GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
            this.cs.prepare(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))), tx, false);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            this.verifyAll();
            return;
        }
        assert (false) : "should have returned";
    }

    public void testClearOnAbortFromStream() throws Exception {
        this.start();
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)"key", (Object)"value");
        EasyMock.expect((Object)this.cacheMap.put(entry.getKey(), (Object)entry)).andReturn(null);
        ObjectInput ois = (ObjectInput)EasyMock.createMock(ObjectInput.class);
        EasyMock.expect((Object)ois.readLong()).andReturn((Object)1L);
        Transaction txn = (Transaction)EasyMock.createMock(Transaction.class);
        EasyMock.expect((Object)this.currentTransaction.beginTransaction(null)).andReturn((Object)txn);
        Cursor cursor = (Cursor)EasyMock.createMock(Cursor.class);
        EasyMock.expect((Object)this.cacheDb.openCursor(txn, null)).andReturn((Object)cursor);
        IOException ex = new IOException();
        EasyMock.expect((Object)ois.readObject()).andReturn((Object)new byte[0]);
        EasyMock.expectLastCall().andThrow((Throwable)ex);
        txn.abort();
        this.cacheMap.clear();
        this.expiryMap.clear();
        EasyMock.replay((Object[])new Object[]{ois});
        EasyMock.replay((Object[])new Object[]{txn});
        this.replayAll();
        this.cs.start();
        try {
            this.cs.store(entry);
            this.cs.fromStream(ois);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            this.verifyAll();
            EasyMock.verify((Object[])new Object[]{ois});
            EasyMock.verify((Object[])new Object[]{txn});
            return;
        }
        assert (false) : "should have returned";
    }

    private class MockBdbjeResourceFactory
    extends BdbjeResourceFactory {
        public PreparableTransactionRunner createPreparableTransactionRunner(Environment env) {
            return BdbjeCacheStoreTest.this.runner;
        }

        public CurrentTransaction createCurrentTransaction(Environment env) {
            return BdbjeCacheStoreTest.this.currentTransaction;
        }

        public Environment createEnvironment(File envLocation, Properties environmentProperties) throws DatabaseException {
            return BdbjeCacheStoreTest.this.env;
        }

        public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
            return BdbjeCacheStoreTest.this.catalog;
        }

        public Database createDatabase(Environment env, String name) throws DatabaseException {
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getCacheDbName())) {
                return BdbjeCacheStoreTest.this.cacheDb;
            }
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getCatalogDbName())) {
                return BdbjeCacheStoreTest.this.catalogDb;
            }
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getExpiryDbName())) {
                return BdbjeCacheStoreTest.this.expiryDb;
            }
            throw new IllegalStateException("Unknown name:" + name);
        }

        public StoredMap createStoredMapViewOfDatabase(Database database, StoredClassCatalog classCatalog, StreamingMarshaller m) throws DatabaseException {
            return BdbjeCacheStoreTest.this.cacheMap;
        }

        public StoredSortedMap<Long, Object> createStoredSortedMapForKeyExpiry(Database database, StoredClassCatalog classCatalog, StreamingMarshaller marshaller) throws DatabaseException {
            return BdbjeCacheStoreTest.this.expiryMap;
        }

        public MockBdbjeResourceFactory(BdbjeCacheStoreConfig config) {
            super(config);
        }
    }
}

