/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.ExceptionUnwrapper;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.bdbje.BdbjeResourceFactory;
import org.infinispan.loaders.bdbje.ModificationsTransactionWorker;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.infinispan.loaders.bdbje.logging.Log;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=BdbjeCacheStoreConfig.class)
public class BdbjeCacheStore
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(BdbjeCacheStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private BdbjeCacheStoreConfig cfg;
    private Environment env;
    private StoredClassCatalog catalog;
    private Database cacheDb;
    private Database expiryDb;
    private StoredMap<Object, InternalCacheEntry> cacheMap;
    private StoredSortedMap<Long, Object> expiryMap;
    private PreparableTransactionRunner transactionRunner;
    private Map<GlobalTransaction, Transaction> txnMap;
    private CurrentTransaction currentTransaction;
    private BdbjeResourceFactory factory;

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        BdbjeCacheStoreConfig cfg = (BdbjeCacheStoreConfig)config;
        this.init(cfg, new BdbjeResourceFactory(cfg), cache, m);
    }

    void init(BdbjeCacheStoreConfig cfg, BdbjeResourceFactory factory, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        if (trace) {
            log.trace("initializing BdbjeCacheStore");
        }
        this.printLicense();
        super.init((CacheLoaderConfig)cfg, cache, m);
        this.cfg = cfg;
        this.factory = factory;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return BdbjeCacheStoreConfig.class;
    }

    public void start() throws CacheLoaderException {
        if (trace) {
            log.trace("starting BdbjeCacheStore");
        }
        this.openSleepyCatResources();
        this.openTransactionServices();
        super.start();
        log.debugf("started cache store %s", (Object)this);
    }

    private void openTransactionServices() {
        this.txnMap = ConcurrentMapFactory.makeConcurrentMap((int)64, (int)this.getConcurrencyLevel());
        this.currentTransaction = this.factory.createCurrentTransaction(this.env);
        this.transactionRunner = this.factory.createPreparableTransactionRunner(this.env);
    }

    private void openSleepyCatResources() throws CacheLoaderException {
        if (trace) {
            log.tracef("creating je environment with home dir %s", this.cfg.getLocation());
        }
        this.cfg.setCacheName(this.cache.getName());
        if (this.cfg.getCatalogDbName() == null) {
            this.cfg.setCatalogDbName(this.cfg.getCacheDbName() + "_class_catalog");
        }
        File location = this.verifyOrCreateEnvironmentDirectory(new File(this.cfg.getLocation()));
        try {
            this.env = this.factory.createEnvironment(location, this.cfg.readEnvironmentProperties());
            this.cacheDb = this.factory.createDatabase(this.env, this.cfg.getCacheDbName());
            Database catalogDb = this.factory.createDatabase(this.env, this.cfg.getCatalogDbName());
            this.expiryDb = this.factory.createDatabase(this.env, this.cfg.getExpiryDbName());
            this.catalog = this.factory.createStoredClassCatalog(catalogDb);
            this.cacheMap = this.factory.createStoredMapViewOfDatabase(this.cacheDb, this.catalog, this.marshaller);
            this.expiryMap = this.factory.createStoredSortedMapForKeyExpiry(this.expiryDb, this.catalog, this.marshaller);
        }
        catch (DatabaseException e) {
            throw this.convertToCacheLoaderException("could not open sleepycat je resource", (Exception)((Object)e));
        }
    }

    File verifyOrCreateEnvironmentDirectory(File location) throws CacheLoaderException {
        boolean created;
        if (!location.exists() && !(created = location.mkdirs())) {
            throw new CacheLoaderException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new CacheLoaderException("Cache loader location [" + location + "] is not a directory!");
        }
        return location;
    }

    public void stop() throws CacheLoaderException {
        if (trace) {
            log.trace("stopping BdbjeCacheStore");
        }
        super.stop();
        this.closeTransactionServices();
        this.closeSleepyCatResources();
        log.debugf("started cache store %s", (Object)this);
    }

    private void closeTransactionServices() {
        this.transactionRunner = null;
        this.currentTransaction = null;
        this.txnMap = null;
    }

    private void closeSleepyCatResources() throws CacheLoaderException {
        this.cacheMap = null;
        this.expiryMap = null;
        this.closeDatabases();
        this.closeEnvironment();
    }

    private void closeDatabases() {
        if (trace) {
            log.trace("closing databases");
        }
        try {
            this.cacheDb.close();
        }
        catch (Exception e) {
            log.errorClosingDatabase(e);
        }
        try {
            this.expiryDb.close();
        }
        catch (Exception e) {
            log.errorClosingDatabase(e);
        }
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            log.errorClosingCatalog(e);
        }
        this.catalog = null;
        this.cacheDb = null;
        this.expiryDb = null;
    }

    private void closeEnvironment() throws CacheLoaderException {
        if (this.env != null) {
            try {
                this.env.close();
            }
            catch (DatabaseException e) {
                throw new CacheLoaderException("Unexpected exception closing cacheStore", (Throwable)e);
            }
        }
        this.env = null;
    }

    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.applyModifications(mods);
        } else {
            this.prepare(mods, tx);
        }
    }

    protected void applyModifications(List<? extends Modification> mods) throws CacheLoaderException {
        if (trace) {
            log.trace("performing one phase transaction");
        }
        try {
            this.transactionRunner.run(new ModificationsTransactionWorker((CacheStore)this, mods));
        }
        catch (Exception caught) {
            throw this.convertToCacheLoaderException("Problem committing modifications: " + mods, caught);
        }
    }

    protected void prepare(List<? extends Modification> mods, GlobalTransaction tx) throws CacheLoaderException {
        if (trace) {
            log.tracef("preparing transaction %s", tx);
        }
        try {
            this.transactionRunner.prepare(new ModificationsTransactionWorker((CacheStore)this, mods));
            Transaction txn = this.currentTransaction.getTransaction();
            if (trace) {
                log.tracef("transaction %s == sleepycat transaction %s", tx, txn);
            }
            this.txnMap.put(tx, txn);
            ReflectionUtil.setValue((Object)this.currentTransaction, (String)"localTrans", new ThreadLocal());
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Problem preparing transaction", e);
        }
    }

    public void rollback(GlobalTransaction tx) {
        try {
            this.completeTransaction(tx, false);
        }
        catch (Exception e) {
            log.rollingBackAfterError(e);
        }
    }

    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        this.completeTransaction(tx, true);
    }

    protected void completeTransaction(GlobalTransaction tx, boolean commit) throws CacheLoaderException {
        Transaction txn = this.txnMap.remove(tx);
        if (txn != null) {
            if (trace) {
                log.tracef("%s sleepycat transaction %s", commit ? "committing" : "aborting", txn);
            }
            try {
                if (commit) {
                    txn.commit();
                }
                txn.abort();
            }
            catch (Exception caught) {
                throw this.convertToCacheLoaderException("Problem completing transaction", caught);
            }
        } else if (trace) {
            log.tracef("no sleepycat transaction associated  transaction %s", tx);
        }
    }

    private void completeCurrentTransaction(boolean commit) throws CacheLoaderException {
        try {
            if (trace) {
                log.tracef("%s current sleepycat transaction %s", commit ? "committing" : "aborting", this.currentTransaction.getTransaction());
            }
            if (commit) {
                this.currentTransaction.commitTransaction();
            } else {
                this.currentTransaction.abortTransaction();
            }
        }
        catch (Exception caught) {
            throw this.convertToCacheLoaderException("Problem completing transaction", caught);
        }
    }

    public boolean remove(Object key) throws CacheLoaderException {
        try {
            if (this.cacheMap.containsKey(key)) {
                this.cacheMap.remove(key);
                return true;
            }
            return false;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error removing key " + key, caught);
        }
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        try {
            InternalCacheEntry s = (InternalCacheEntry)this.cacheMap.get(key);
            if (s != null && s.isExpired(System.currentTimeMillis())) {
                s = null;
            }
            return s;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading key " + key, caught);
        }
    }

    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        try {
            this.cacheMap.put(ed.getKey(), (Object)ed);
            if (ed.canExpire()) {
                this.addNewExpiry(ed);
            }
        }
        catch (IOException caught) {
            throw this.convertToCacheLoaderException("error storing entry " + ed, caught);
        }
    }

    private void addNewExpiry(InternalCacheEntry entry) throws IOException {
        long expiry = entry.getExpiryTime();
        if (entry.getMaxIdle() > 0L) {
            expiry = entry.getMaxIdle() + System.currentTimeMillis();
        }
        Long at = expiry;
        Object key = entry.getKey();
        this.expiryMap.put((Object)at, key);
    }

    public void clear() throws CacheLoaderException {
        try {
            this.cacheMap.clear();
            this.expiryMap.clear();
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error clearing store", caught);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        try {
            return new HashSet<InternalCacheEntry>(this.cacheMap.values());
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading all entries", caught);
        }
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        if (numEntries < 0) {
            return this.loadAll();
        }
        try {
            HashSet<InternalCacheEntry> s = new HashSet<InternalCacheEntry>(numEntries);
            Iterator i = this.cacheMap.values().iterator();
            while (i.hasNext() && s.size() < numEntries) {
                s.add((InternalCacheEntry)i.next());
            }
            return s;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading all entries", caught);
        }
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        try {
            HashSet<Object> s = new HashSet<Object>();
            for (Object o : this.cacheMap.keySet()) {
                if (keysToExclude != null && keysToExclude.contains(o)) continue;
                s.add(o);
            }
            return s;
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error loading all entries", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromStream(ObjectInput ois) throws CacheLoaderException {
        try {
            this.currentTransaction.beginTransaction(null);
            for (Database db : new Database[]{this.cacheDb, this.expiryDb}) {
                long recordCount = ois.readLong();
                log.debugf("clearing and reading %s records from stream", recordCount);
                Cursor cursor = null;
                try {
                    cursor = db.openCursor(this.currentTransaction.getTransaction(), null);
                    int i = 0;
                    while ((long)i < recordCount) {
                        byte[] keyBytes = (byte[])ois.readObject();
                        byte[] dataBytes = (byte[])ois.readObject();
                        DatabaseEntry key = new DatabaseEntry(keyBytes);
                        DatabaseEntry data = new DatabaseEntry(dataBytes);
                        cursor.put(key, data);
                        ++i;
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            this.completeCurrentTransaction(true);
        }
        catch (Exception caught) {
            this.completeCurrentTransaction(false);
            this.clear();
            throw this.convertToCacheLoaderException("Problems reading from stream", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(ObjectOutput oos) throws CacheLoaderException {
        try {
            this.currentTransaction.beginTransaction(null);
            for (Database db : new Database[]{this.cacheDb, this.expiryDb}) {
                long recordCount = db.count();
                oos.writeLong(recordCount);
                if (trace) {
                    log.tracef("writing %s records to stream", recordCount);
                }
                Cursor cursor = null;
                try {
                    cursor = db.openCursor(this.currentTransaction.getTransaction(), null);
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    int recordsWritten = 0;
                    while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                        oos.writeObject(key.getData());
                        oos.writeObject(data.getData());
                        ++recordsWritten;
                    }
                    if (trace) {
                        log.tracef("wrote %s records to stream", recordsWritten);
                    }
                    if ((long)recordsWritten == recordCount) continue;
                    log.unexpectedNumberRecordsWritten(recordCount, recordsWritten);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            this.completeCurrentTransaction(true);
        }
        catch (Exception caught) {
            this.completeCurrentTransaction(false);
            throw this.convertToCacheLoaderException("Problems writing to stream", caught);
        }
    }

    CacheLoaderException convertToCacheLoaderException(String message, Exception caught) {
        return (caught = ExceptionUnwrapper.unwrap((Exception)caught)) instanceof CacheLoaderException ? (CacheLoaderException)caught : new CacheLoaderException(message, (Throwable)caught);
    }

    protected void purgeInternal() throws CacheLoaderException {
        try {
            SortedMap expired = this.expiryMap.headMap((Object)System.currentTimeMillis(), true);
            for (Map.Entry entry : expired.entrySet()) {
                this.expiryMap.remove(entry.getKey());
                this.cacheMap.remove(entry.getValue());
            }
        }
        catch (RuntimeException caught) {
            throw this.convertToCacheLoaderException("error purging expired entries", caught);
        }
    }

    public void printLicense() {
        String license = "\n*************************************************************************************\nBerkeley DB Java Edition version: " + JEVersion.CURRENT_VERSION.toString() + "\n" + "Infinispan can use Berkeley DB Java Edition from Oracle \n" + "(http://www.oracle.com/database/berkeley-db/je/index.html)\n" + "for persistent, reliable and transaction-protected data storage.\n" + "If you choose to use Berkeley DB Java Edition with Infinispan, you must comply with the terms\n" + "of Oracle's public license, included in the file LICENSE.txt.\n" + "If you prefer not to release the source code for your own application in order to comply\n" + "with the Oracle public license, you may purchase a different license for use of\n" + "Berkeley DB Java Edition with Infinispan.\n" + "See http://www.oracle.com/database/berkeley-db/je/index.html for pricing and license terms\n" + "*************************************************************************************";
        System.out.println(license);
    }
}

