/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import java.io.File;
import java.util.ArrayList;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.BdbjeCacheStoreIntegrationTest")
public class BdbjeCacheStoreIntegrationTest
extends BaseCacheStoreTest {
    private String tmpDirectory;
    private TransactionFactory gts = new TransactionFactory();

    public BdbjeCacheStoreIntegrationTest() {
        this.gts.init(false, false, true, false);
    }

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    protected CacheStore createCacheStore() throws CacheLoaderException {
        BdbjeCacheStore cs = new BdbjeCacheStore();
        BdbjeCacheStoreConfig cfg = new BdbjeCacheStoreConfig();
        cfg.setLocation(this.tmpDirectory);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        cs.init((CacheLoaderConfig)cfg, this.getCache(), this.getMarshaller());
        cs.start();
        return cs;
    }

    public void testTwoPhaseCommit() throws CacheLoaderException {
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Remove((Object)"k1"));
        GlobalTransaction tx = this.gts.newGlobalTransaction(null, false);
        this.cs.prepare(mods, tx, false);
        this.cs.commit(tx);
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (!this.cs.containsKey((Object)"k1"));
        this.cs.clear();
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Clear());
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3")));
        this.cs.prepare(mods, tx, false);
        this.cs.commit(tx);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
    }

    public void testRollback() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"old", (Object)"old"));
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Remove((Object)"k1"));
        mods.add(new Remove((Object)"old"));
        GlobalTransaction tx = this.gts.newGlobalTransaction(null, false);
        this.cs.prepare(mods, tx, false);
        this.cs.rollback(tx);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"old"));
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2")));
        mods.add(new Clear());
        mods.add(new Store(TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3")));
        this.cs.prepare(mods, tx, false);
        this.cs.rollback(tx);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        assert (this.cs.containsKey((Object)"old"));
    }
}

