/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import java.util.Collections;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.bdbje.ModificationsTransactionWorker;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.PurgeExpired;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.ModificationsTransactionWorkerTest")
public class ModificationsTransactionWorkerTest {
    @Test
    public void testDoWorkOnStore() throws Exception {
        CacheStore cs = (CacheStore)Mockito.mock(CacheStore.class);
        Store store = (Store)Mockito.mock(Store.class);
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)"1", (Object)"2");
        Mockito.when((Object)store.getType()).thenReturn((Object)Modification.Type.STORE);
        Mockito.when((Object)store.getStoredEntry()).thenReturn((Object)entry);
        cs.store(entry);
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(store));
        worker.doWork();
    }

    @Test
    public void testDoWorkOnRemove() throws Exception {
        CacheStore cs = (CacheStore)Mockito.mock(CacheStore.class);
        Remove store = (Remove)Mockito.mock(Remove.class);
        Mockito.when((Object)store.getType()).thenReturn((Object)Modification.Type.REMOVE);
        Mockito.when((Object)store.getKey()).thenReturn((Object)"1");
        Mockito.when((Object)cs.remove((Object)"1")).thenReturn((Object)true);
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(store));
        worker.doWork();
    }

    @Test
    public void testDoWorkOnClear() throws Exception {
        CacheStore cs = (CacheStore)Mockito.mock(CacheStore.class);
        Clear clear = (Clear)Mockito.mock(Clear.class);
        Mockito.when((Object)clear.getType()).thenReturn((Object)Modification.Type.CLEAR);
        cs.clear();
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(clear));
        worker.doWork();
    }

    @Test
    public void testDoWorkOnPurgeExpired() throws Exception {
        CacheStore cs = (CacheStore)Mockito.mock(CacheStore.class);
        PurgeExpired purge = (PurgeExpired)Mockito.mock(PurgeExpired.class);
        Mockito.when((Object)purge.getType()).thenReturn((Object)Modification.Type.PURGE_EXPIRED);
        cs.purgeExpired();
        ModificationsTransactionWorker worker = new ModificationsTransactionWorker(cs, Collections.singletonList(purge));
        worker.doWork();
    }
}

