/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.bdbje.configuration.BdbjeCacheStoreConfigurationBuilder;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=BdbjeCacheStoreConfigurationBuilder.class)
public class BdbjeCacheStoreConfiguration
extends AbstractStoreConfiguration
implements LegacyLoaderAdapter<BdbjeCacheStoreConfig> {
    private final String location;
    private final long lockAcquistionTimeout;
    private final int maxTxRetries;
    private final String cacheDbNamePrefix;
    private final String catalogDbName;
    private final String expiryDbPrefix;
    private final String environmentPropertiesFile;

    public BdbjeCacheStoreConfiguration(String location, long lockAcquistionTimeout, int maxTxRetries, String cacheDbNamePrefix, String catalogDbName, String expiryDbPrefix, String environmentPropertiesFile, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration asyncStoreConfiguration, SingletonStoreConfiguration singletonStoreConfiguration) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, asyncStoreConfiguration, singletonStoreConfiguration);
        this.location = location;
        this.lockAcquistionTimeout = lockAcquistionTimeout;
        this.maxTxRetries = maxTxRetries;
        this.cacheDbNamePrefix = cacheDbNamePrefix;
        this.catalogDbName = catalogDbName;
        this.expiryDbPrefix = expiryDbPrefix;
        this.environmentPropertiesFile = environmentPropertiesFile;
    }

    public String location() {
        return this.location;
    }

    public long lockAcquisitionTimeout() {
        return this.lockAcquistionTimeout;
    }

    public int maxTxRetries() {
        return this.maxTxRetries;
    }

    public String cacheDbNamePrefix() {
        return this.cacheDbNamePrefix;
    }

    public String catalogDbName() {
        return this.catalogDbName;
    }

    public String expiryDbPrefix() {
        return this.expiryDbPrefix;
    }

    public String environmentPropertiesFile() {
        return this.environmentPropertiesFile;
    }

    public BdbjeCacheStoreConfig adapt() {
        BdbjeCacheStoreConfig config = new BdbjeCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((StoreConfiguration)this, (CacheStoreConfig)config);
        config.setCacheDbNamePrefix(this.cacheDbNamePrefix);
        config.setCatalogDbName(this.catalogDbName);
        config.setEnvironmentPropertiesFile(this.environmentPropertiesFile);
        config.setExpiryDbNamePrefix(this.expiryDbPrefix);
        config.setLocation(this.location);
        config.setLockAcquistionTimeout(this.lockAcquistionTimeout);
        config.setMaxTxRetries(this.maxTxRetries);
        return config;
    }
}

