/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.BdbjeCacheStore;
import org.infinispan.loaders.bdbje.BdbjeCacheStoreConfig;
import org.infinispan.loaders.bdbje.BdbjeResourceFactory;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ReflectionUtil;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.bdbje.BdbjeCacheStoreTest")
public class BdbjeCacheStoreTest {
    private BdbjeCacheStore cs;
    private BdbjeCacheStoreConfig cfg;
    private BdbjeResourceFactory factory;
    private Cache cache;
    private Environment env;
    private Database cacheDb;
    private Database catalogDb;
    private Database expiryDb;
    private StoredClassCatalog catalog;
    private StoredMap cacheMap;
    private StoredSortedMap expiryMap;
    private PreparableTransactionRunner runner;
    private CurrentTransaction currentTransaction;
    private TransactionFactory gtf;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cfg = new BdbjeCacheStoreConfig();
        this.factory = new MockBdbjeResourceFactory(this.cfg);
        this.cache = (Cache)Mockito.mock(Cache.class);
        this.cs = new BdbjeCacheStore();
        this.env = (Environment)Mockito.mock(Environment.class);
        this.cacheDb = (Database)Mockito.mock(Database.class);
        this.catalogDb = (Database)Mockito.mock(Database.class);
        this.expiryDb = (Database)Mockito.mock(Database.class);
        this.catalog = (StoredClassCatalog)Mockito.mock(StoredClassCatalog.class);
        this.cacheMap = (StoredMap)Mockito.mock(StoredMap.class);
        this.expiryMap = (StoredSortedMap)Mockito.mock(StoredSortedMap.class);
        this.currentTransaction = (CurrentTransaction)Mockito.mock(CurrentTransaction.class);
        this.gtf = new TransactionFactory();
        this.gtf.init(false, false, true, false);
        WeakReference<Environment> envRef = new WeakReference<Environment>(this.env);
        ReflectionUtil.setValue((Object)this.currentTransaction, (String)"envRef", envRef);
        ThreadLocal localTrans = new ThreadLocal();
        ReflectionUtil.setValue((Object)this.currentTransaction, (String)"localTrans", localTrans);
        this.runner = (PreparableTransactionRunner)Mockito.mock(PreparableTransactionRunner.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.runner = null;
        this.currentTransaction = null;
        this.cacheMap = null;
        this.catalogDb = null;
        this.expiryDb = null;
        this.cacheDb = null;
        this.env = null;
        this.factory = null;
        this.cache = null;
        this.cfg = null;
        this.cs = null;
        this.gtf = null;
    }

    void start() throws DatabaseException, CacheLoaderException {
        this.cs.init(this.cfg, this.factory, this.cache, (StreamingMarshaller)new TestObjectStreamMarshaller());
        Mockito.when((Object)this.cache.getName()).thenReturn((Object)"cache");
        Mockito.when((Object)this.cache.getConfiguration()).thenReturn(null);
    }

    public void testGetConfigurationClass() throws Exception {
        assert (this.cs.getConfigurationClass().equals(BdbjeCacheStoreConfig.class));
    }

    public void testInitNoMock() throws Exception {
        this.cs.init((CacheLoaderConfig)this.cfg, this.cache, null);
        assert (this.cfg.equals(ReflectionUtil.getValue((Object)this.cs, (String)"cfg")));
        assert (this.cache.equals(ReflectionUtil.getValue((Object)this.cs, (String)"cache")));
        assert (ReflectionUtil.getValue((Object)this.cs, (String)"factory") instanceof BdbjeResourceFactory);
    }

    public void testExceptionClosingCacheDatabaseDoesNotPreventEnvironmentFromClosing() throws Exception {
        this.start();
        ((Database)Mockito.doThrow((Throwable)new DatabaseException("Dummy"){}).when((Object)this.expiryDb)).close();
        this.cs.start();
        this.cs.stop();
    }

    public void testExceptionClosingCatalogDoesNotPreventEnvironmentFromClosing() throws Exception {
        this.start();
        ((StoredClassCatalog)Mockito.doThrow((Throwable)new DatabaseException("Dummy"){}).when((Object)this.catalog)).close();
        this.cs.start();
        this.cs.stop();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testExceptionClosingEnvironment() throws Exception {
        this.start();
        ((Environment)Mockito.doThrow((Throwable)new DatabaseException("Dummy"){}).when((Object)this.env)).close();
        this.cs.start();
        this.cs.stop();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testThrowsCorrectExceptionOnStartForDatabaseException() throws Exception {
        this.factory = new MockBdbjeResourceFactory(this.cfg){

            @Override
            public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
                throw new DatabaseException("Dummy"){};
            }
        };
        this.start();
        this.cs.start();
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testEnvironmentDirectoryExistsButNotAFile() throws Exception {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.exists()).thenReturn((Object)true);
        Mockito.when((Object)file.isDirectory()).thenReturn((Object)false);
        this.cs.verifyOrCreateEnvironmentDirectory(file);
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testCantCreateEnvironmentDirectory() throws Exception {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.exists()).thenReturn((Object)false);
        Mockito.when((Object)file.mkdirs()).thenReturn((Object)false);
        this.cs.verifyOrCreateEnvironmentDirectory(file);
    }

    public void testCanCreateEnvironmentDirectory() throws Exception {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.exists()).thenReturn((Object)false);
        Mockito.when((Object)file.mkdirs()).thenReturn((Object)true);
        Mockito.when((Object)file.isDirectory()).thenReturn((Object)true);
        assert (file.equals(this.cs.verifyOrCreateEnvironmentDirectory(file)));
    }

    public void testNoExceptionOnRollback() throws Exception {
        this.start();
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.start();
        this.cs.rollback(tx);
    }

    public void testApplyModificationsThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        ((PreparableTransactionRunner)Mockito.doThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex)).when((Object)this.runner)).run((TransactionWorker)Mockito.isA(TransactionWorker.class));
        this.cs.start();
        try {
            this.cs.applyModifications(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))));
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            return;
        }
        assert (false) : "should have returned";
    }

    public void testCommitThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        Transaction txn = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.currentTransaction.beginTransaction(null)).thenReturn((Object)txn);
        this.runner.prepare((TransactionWorker)Mockito.isA(TransactionWorker.class));
        ((Transaction)Mockito.doThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex)).when((Object)txn)).commit();
        this.cs.start();
        try {
            txn = this.currentTransaction.beginTransaction(null);
            GlobalTransaction t = this.gtf.newGlobalTransaction(null, false);
            this.cs.prepare(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))), t, false);
            this.cs.commit(t);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            return;
        }
        assert (false) : "should have returned";
    }

    public void testPrepareThrowsOriginalDatabaseException() throws Exception {
        this.start();
        DatabaseException ex = new DatabaseException("Dummy"){};
        ((PreparableTransactionRunner)Mockito.doThrow((Throwable)new RuntimeExceptionWrapper((Throwable)ex)).when((Object)this.runner)).prepare((TransactionWorker)Mockito.isA(TransactionWorker.class));
        this.cs.start();
        try {
            GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
            this.cs.prepare(Collections.singletonList(new Store(TestInternalCacheEntryFactory.create((Object)"k", (Object)"v"))), tx, false);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            return;
        }
        assert (false) : "should have returned";
    }

    public void testClearOnAbortFromStream() throws Exception {
        this.start();
        InternalCacheEntry entry = TestInternalCacheEntryFactory.create((Object)"key", (Object)"value");
        Mockito.when((Object)this.cacheMap.put(entry.getKey(), (Object)entry)).thenReturn(null);
        ObjectInput ois = (ObjectInput)Mockito.mock(ObjectInput.class);
        Mockito.when((Object)ois.readLong()).thenReturn((Object)1L);
        Transaction txn = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.currentTransaction.beginTransaction(null)).thenReturn((Object)txn);
        Cursor cursor = (Cursor)Mockito.mock(Cursor.class);
        Mockito.when((Object)this.cacheDb.openCursor(txn, null)).thenReturn((Object)cursor);
        IOException ex = new IOException();
        Mockito.when((Object)ois.readObject()).thenThrow(new Throwable[]{ex});
        this.cacheMap.clear();
        this.expiryMap.clear();
        this.cs.start();
        try {
            this.cs.store(entry);
            this.cs.fromStream(ois);
            assert (false) : "should have gotten an exception";
        }
        catch (CacheLoaderException e) {
            assert (ex.equals(e.getCause()));
            return;
        }
        assert (false) : "should have returned";
    }

    private class MockBdbjeResourceFactory
    extends BdbjeResourceFactory {
        public PreparableTransactionRunner createPreparableTransactionRunner(Environment env) {
            return BdbjeCacheStoreTest.this.runner;
        }

        public CurrentTransaction createCurrentTransaction(Environment env) {
            return BdbjeCacheStoreTest.this.currentTransaction;
        }

        public Environment createEnvironment(File envLocation, Properties environmentProperties) throws DatabaseException {
            return BdbjeCacheStoreTest.this.env;
        }

        public StoredClassCatalog createStoredClassCatalog(Database catalogDb) throws DatabaseException {
            return BdbjeCacheStoreTest.this.catalog;
        }

        public Database createDatabase(Environment env, String name) throws DatabaseException {
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getCacheDbName())) {
                return BdbjeCacheStoreTest.this.cacheDb;
            }
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getCatalogDbName())) {
                return BdbjeCacheStoreTest.this.catalogDb;
            }
            if (name.equals(BdbjeCacheStoreTest.this.cfg.getExpiryDbName())) {
                return BdbjeCacheStoreTest.this.expiryDb;
            }
            throw new IllegalStateException("Unknown name:" + name);
        }

        public StoredMap createStoredMapViewOfDatabase(Database database, StoredClassCatalog classCatalog, StreamingMarshaller m) throws DatabaseException {
            return BdbjeCacheStoreTest.this.cacheMap;
        }

        public StoredSortedMap<Long, Object> createStoredSortedMapForKeyExpiry(Database database, StoredClassCatalog classCatalog, StreamingMarshaller marshaller) throws DatabaseException {
            return BdbjeCacheStoreTest.this.expiryMap;
        }

        public MockBdbjeResourceFactory(BdbjeCacheStoreConfig config) {
            super(config);
        }
    }
}

