/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.TransactionRunner;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.util.ExceptionUnwrapper;

public class PreparableTransactionRunner
extends TransactionRunner {
    CurrentTransaction currentTxn;

    public PreparableTransactionRunner(Environment env, int maxRetries, TransactionConfig config) {
        super(env, maxRetries, config);
        this.currentTxn = CurrentTransaction.getInstance((Environment)env);
    }

    public PreparableTransactionRunner(Environment env) {
        super(env);
        this.currentTxn = CurrentTransaction.getInstance((Environment)env);
    }

    public void prepare(TransactionWorker worker) throws Exception {
        int currentTries = 0;
        while (true) {
            Transaction txn = null;
            try {
                txn = this.currentTxn.beginTransaction(this.getTransactionConfig());
                worker.doWork();
                return;
            }
            catch (Throwable caught) {
                currentTries = this.abortOverflowingCurrentTriesOnError(txn, currentTries);
                caught = ExceptionUnwrapper.unwrapAny((Throwable)caught);
                this.rethrowIfNotDeadLock(caught);
                if (currentTries >= this.getMaxRetries()) {
                    throw (LockConflictException)caught;
                }
                ++currentTries;
                continue;
            }
            break;
        }
    }

    int abortOverflowingCurrentTriesOnError(Transaction toAbort, int currentTries) {
        if (toAbort != null && toAbort == this.currentTxn.getTransaction()) {
            try {
                this.currentTxn.abortTransaction();
            }
            catch (Throwable problemAborting) {
                if (DbCompat.TRANSACTION_RUNNER_PRINT_STACK_TRACES) {
                    problemAborting.printStackTrace();
                }
                return Integer.MAX_VALUE;
            }
        }
        return currentTries;
    }

    void rethrowIfNotDeadLock(Throwable caught) throws Exception {
        if (!(caught instanceof LockConflictException)) {
            if (caught instanceof Exception) {
                throw (Exception)caught;
            }
            throw (Error)caught;
        }
    }
}

