/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    CACHE_DB_NAME_PREFIX("cacheDbNamePrefix"),
    CATALOG_DB_NAME("catalogDbName"),
    ENVIRONMENT_PROPERTIES_FILE("environmentPropertiesFile"),
    EXPIRY_DB_PREFIX("expiryDbPrefix"),
    LOCATION("location"),
    LOCK_ACQUISITION_TIMEOUT("lockAcquisitionTimeout"),
    MAX_TX_RETRIES("maxTxRetries");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

