/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.txn.Locker;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bdbje.PreparableTransactionRunner;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, enabled=true, testName="loaders.bdbje.PreparableTransactionRunnerTest")
public class PreparableTransactionRunnerTest {
    PreparableTransactionRunner runner;
    Environment env;
    EnvironmentConfig config;
    TransactionWorker worker;
    Transaction transaction;

    @BeforeMethod
    public void setUp() throws Exception {
        this.config = (EnvironmentConfig)Mockito.mock(EnvironmentConfig.class);
        Mockito.when((Object)this.config.getTransactional()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getLocking()).thenReturn((Object)true);
        this.transaction = (Transaction)Mockito.mock(Transaction.class);
        this.env = (Environment)Mockito.mock(Environment.class);
        Mockito.when((Object)this.env.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.env.beginTransaction(null, null)).thenReturn((Object)this.transaction);
        this.worker = (TransactionWorker)Mockito.mock(TransactionWorker.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.runner = null;
        this.env = null;
        this.config = null;
    }

    @Test
    public void testMoreDeadlocks() throws Exception {
        Locker mockLocker = (Locker)Mockito.mock(Locker.class);
        ((TransactionWorker)Mockito.doThrow((Throwable)new LockTimeoutException(mockLocker, "")).when((Object)this.worker)).doWork();
        Mockito.when((Object)this.env.beginTransaction(null, null)).thenReturn((Object)this.transaction);
        this.runner = new PreparableTransactionRunner(this.env, 2, null);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten a deadlock exception";
        }
        catch (LockTimeoutException lockTimeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testPrepare() throws Exception {
        this.worker.doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.prepare(this.worker);
    }

    @Test
    public void testRun() throws Exception {
        this.transaction.commit();
        this.worker.doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.run(this.worker);
    }

    @Test
    public void testOneArgConstructorSetsCurrentTxn() throws Exception {
        this.runner = new PreparableTransactionRunner(this.env);
        assert (CurrentTransaction.getInstance((Environment)this.env) == this.runner.currentTxn);
    }

    @Test
    public void testSetMaxRetries() throws Exception {
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setMaxRetries(1);
        assert (this.runner.getMaxRetries() == 1);
    }

    @Test
    public void testSetAllowNestedTransactions() throws Exception {
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setAllowNestedTransactions(false);
        assert (!this.runner.getAllowNestedTransactions());
        try {
            this.runner.setAllowNestedTransactions(true);
            assert (false) : "should have gotten Exception";
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTransactionConfig() throws Exception {
        TransactionConfig config = new TransactionConfig();
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.setTransactionConfig(config);
        assert (this.runner.getTransactionConfig().equals(config));
    }

    @Test
    public void testExceptionThrownInPrepare() throws Exception {
        ((TransactionWorker)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.worker)).doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testErrorThrownInPrepare() throws Exception {
        ((TransactionWorker)Mockito.doThrow((Throwable)new Error()).when((Object)this.worker)).doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Test
    public void testExceptionThrownInRun() throws Exception {
        ((TransactionWorker)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.worker)).doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.prepare(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testErrorThrownInRun() throws Exception {
        ((TransactionWorker)Mockito.doThrow((Throwable)new Error()).when((Object)this.worker)).doWork();
        this.runner = new PreparableTransactionRunner(this.env);
        try {
            this.runner.run(this.worker);
            assert (false) : "should have gotten an exception";
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void testRethrowIfNotDeadLockDoesntThrowWhenGivenDeadlockException() throws Exception {
        this.runner = new PreparableTransactionRunner(this.env);
        this.runner.rethrowIfNotDeadLock((Throwable)Mockito.mock(LockTimeoutException.class));
    }

    public void testThrowableDuringAbort() throws Exception {
        ((Transaction)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.transaction)).abort();
        this.runner = new PreparableTransactionRunner(this.env);
        CurrentTransaction.getInstance((Environment)this.env).beginTransaction(null);
        int max = this.runner.abortOverflowingCurrentTriesOnError(this.transaction, 2);
        assert (max == Integer.MAX_VALUE) : "should have overflowed max tries, but got " + max;
    }
}

