/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje.configuration;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.bdbje.configuration.BdbjeCacheStoreConfiguration;

public class BdbjeCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<BdbjeCacheStoreConfiguration, BdbjeCacheStoreConfigurationBuilder> {
    private String location = "Infinispan-BdbjeCacheStore";
    private long lockAcquistionTimeout = 60000L;
    private int maxTxRetries = 5;
    private String cacheDbNamePrefix;
    private String catalogDbName;
    private String expiryDbPrefix;
    private String environmentPropertiesFile;

    public BdbjeCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public BdbjeCacheStoreConfigurationBuilder self() {
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder lockAcquistionTimeout(long lockAcquistionTimeout) {
        this.lockAcquistionTimeout = lockAcquistionTimeout;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder maxTxRetries(int maxTxRetries) {
        this.maxTxRetries = maxTxRetries;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder cacheDbNamePrefix(String cacheDbNamePrefix) {
        this.cacheDbNamePrefix = cacheDbNamePrefix;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder catalogDbName(String catalogDbName) {
        this.catalogDbName = catalogDbName;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder expiryDbPrefix(String expiryDbPrefix) {
        this.expiryDbPrefix = expiryDbPrefix;
        return this;
    }

    public BdbjeCacheStoreConfigurationBuilder environmentPropertiesFile(String environmentPropertiesFile) {
        this.environmentPropertiesFile = environmentPropertiesFile;
        return this;
    }

    public BdbjeCacheStoreConfiguration create() {
        return new BdbjeCacheStoreConfiguration(this.location, this.lockAcquistionTimeout, this.maxTxRetries, this.cacheDbNamePrefix, this.catalogDbName, this.expiryDbPrefix, this.environmentPropertiesFile, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public BdbjeCacheStoreConfigurationBuilder read(BdbjeCacheStoreConfiguration template) {
        this.location = template.location();
        this.lockAcquistionTimeout = template.lockAcquisitionTimeout();
        this.maxTxRetries = template.maxTxRetries();
        this.cacheDbNamePrefix = template.cacheDbNamePrefix();
        this.catalogDbName = template.catalogDbName();
        this.expiryDbPrefix = template.expiryDbPrefix();
        this.environmentPropertiesFile = template.environmentPropertiesFile();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

