/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bdbje.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.loaders.bdbje.configuration.Attribute;
import org.infinispan.loaders.bdbje.configuration.BdbjeCacheStoreConfigurationBuilder;
import org.infinispan.loaders.bdbje.configuration.Element;

@Namespace(uri="urn:infinispan:config:bdbje:5.2", root="bdbjeStore")
public class BdbjeCacheStoreConfigurationParser52
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case BDBJE_STORE: {
                this.parseBdbjeStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseBdbjeStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        BdbjeCacheStoreConfigurationBuilder builder = new BdbjeCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseBdbjeStoreAttributes(reader, builder);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseBdbjeStoreAttributes(XMLExtendedStreamReader reader, BdbjeCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_DB_NAME_PREFIX: {
                    builder.cacheDbNamePrefix(value);
                    continue block9;
                }
                case CATALOG_DB_NAME: {
                    builder.catalogDbName(value);
                    continue block9;
                }
                case ENVIRONMENT_PROPERTIES_FILE: {
                    builder.environmentPropertiesFile(value);
                    continue block9;
                }
                case EXPIRY_DB_PREFIX: {
                    builder.expiryDbPrefix(value);
                    continue block9;
                }
                case LOCATION: {
                    builder.location(value);
                    continue block9;
                }
                case LOCK_ACQUISITION_TIMEOUT: {
                    builder.lockAcquistionTimeout(Long.parseLong(value));
                    continue block9;
                }
                case MAX_TX_RETRIES: {
                    builder.maxTxRetries(Integer.parseInt(value));
                    continue block9;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

