/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.cloud.CloudCacheStoreConfig;
import org.infinispan.loaders.cloud.configuration.CloudCacheStoreConfigurationBuilder;

@BuiltBy(value=CloudCacheStoreConfigurationBuilder.class)
public class CloudCacheStoreConfiguration
extends AbstractStoreConfiguration
implements LegacyLoaderAdapter<CloudCacheStoreConfig> {
    private final String identity;
    private final String password;
    private final String bucketPrefix;
    private final String proxyHost;
    private final int proxyPort;
    private final long requestTimeout;
    private final boolean lazyPurgingOnly;
    private final String cloudService;
    private final int maxConnections;
    private final boolean secure;
    private final boolean compress;
    private final String cloudServiceLocation;

    CloudCacheStoreConfiguration(String identity, String password, String bucketPrefix, String proxyHost, int proxyPort, long requestTimeout, boolean lazyPurgingOnly, String cloudService, String cloudServiceLocation, int maxConnections, boolean secure, boolean compress, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration asyncStoreConfiguration, SingletonStoreConfiguration singletonStoreConfiguration) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, asyncStoreConfiguration, singletonStoreConfiguration);
        this.identity = identity;
        this.password = password;
        this.bucketPrefix = bucketPrefix;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.requestTimeout = requestTimeout;
        this.lazyPurgingOnly = lazyPurgingOnly;
        this.cloudService = cloudService;
        this.cloudServiceLocation = cloudServiceLocation;
        this.maxConnections = maxConnections;
        this.secure = secure;
        this.compress = compress;
    }

    public CloudCacheStoreConfig adapt() {
        CloudCacheStoreConfig config = new CloudCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((CacheStoreConfiguration)this, (CacheStoreConfig)config);
        config.setIdentity(this.identity);
        config.setPassword(this.password);
        config.setBucketPrefix(this.bucketPrefix);
        config.setProxyHost(this.proxyHost);
        config.setProxyPort(Integer.toString(this.proxyPort));
        config.setRequestTimeout(this.requestTimeout);
        config.setLazyPurgingOnly(this.lazyPurgingOnly);
        config.setCloudService(this.cloudService);
        config.setCloudServiceLocation(this.cloudServiceLocation);
        config.setMaxConnections(this.maxConnections);
        config.setSecure(this.secure);
        config.setCompress(this.compress);
        return config;
    }

    public String bucketPrefix() {
        return this.bucketPrefix;
    }

    public String cloudService() {
        return this.cloudService;
    }

    public String cloudServiceLocation() {
        return this.cloudServiceLocation;
    }

    public boolean compress() {
        return this.compress;
    }

    public String identity() {
        return this.identity;
    }

    public boolean lazyPurgingOnly() {
        return this.lazyPurgingOnly;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    public String password() {
        return this.password;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public int proxyPort() {
        return this.proxyPort;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public boolean secure() {
        return this.secure;
    }
}

