/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud;

import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.infinispan.commons.util.Util;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfiguration;
import org.infinispan.persistence.cloud.logging.Log;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.stream.Streams;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;

public class CloudStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(CloudStore.class, Log.class);
    protected static final String LIFESPAN = "metadata_lifespan";
    protected static final String MAX_IDLE = "metadata_max_idle";
    protected static final String EXPIRE_TIME = "expire_time";
    protected static final int BATCH_SIZE = 1000;
    private CloudStoreConfiguration configuration;
    private InitializationContext initializationContext;
    private MarshallingTwoWayKey2StringMapper key2StringMapper;
    private BlobStoreContext blobStoreContext;
    private BlobStore blobStore;
    private String containerName;

    public CloudStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(InitializationContext initializationContext) {
        this.configuration = (CloudStoreConfiguration)initializationContext.getConfiguration();
        this.initializationContext = initializationContext;
    }

    public void start() {
        this.key2StringMapper = (MarshallingTwoWayKey2StringMapper)Util.getInstance((String)this.configuration.key2StringMapper(), (ClassLoader)this.initializationContext.getCache().getAdvancedCache().getClassLoader());
        this.key2StringMapper.setMarshaller(this.initializationContext.getMarshaller());
        ContextBuilder contextBuilder = ContextBuilder.newBuilder((String)this.configuration.provider()).credentials(this.configuration.identity(), this.configuration.credential());
        if (this.configuration.overrides() != null) {
            contextBuilder.overrides(this.configuration.overrides());
        }
        if (this.configuration.endpoint() != null && !this.configuration.endpoint().isEmpty()) {
            contextBuilder.endpoint(this.configuration.endpoint());
        }
        this.blobStoreContext = (BlobStoreContext)contextBuilder.buildView(BlobStoreContext.class);
        this.blobStore = this.blobStoreContext.getBlobStore();
        this.containerName = String.format("%s-%s", this.configuration.container(), this.initializationContext.getCache().getName());
        if (!this.blobStore.containerExists(this.containerName)) {
            Location location = new LocationBuilder().scope(LocationScope.REGION).id(this.configuration.location()).description(String.format("Infinispan cache store for %s", this.containerName)).build();
            this.blobStore.createContainerInLocation(location, this.containerName);
            if (!this.blobStore.containerExists(this.containerName)) {
                throw new PersistenceException(String.format("Unable to create blob container %s", this.containerName));
            }
        }
    }

    public void stop() {
        this.blobStoreContext.close();
    }

    private String encodeKey(Object key) {
        return this.key2StringMapper.getStringMapping(key);
    }

    private Object decodeKey(String key) {
        return this.key2StringMapper.getKeyMapping(key);
    }

    private byte[] marshall(MarshalledEntry<? extends K, ? extends V> entry) throws IOException, InterruptedException {
        return this.initializationContext.getMarshaller().objectToByteBuffer(entry.getValue());
    }

    private Object unmarshall(byte[] bytearray) throws IOException, ClassNotFoundException {
        return this.initializationContext.getMarshaller().objectFromByteBuffer(bytearray);
    }

    public void write(MarshalledEntry<? extends K, ? extends V> entry) {
        String objectName = this.encodeKey(entry.getKey());
        try {
            byte[] entryBytes = this.configuration.compress() ? this.compress(this.marshall(entry)) : this.marshall(entry);
            ByteSource payload = ByteSource.wrap((byte[])entryBytes);
            Date expiresDate = null;
            InternalMetadata metadata = entry.getMetadata();
            if (metadata != null && metadata.expiryTime() > -1L) {
                expiresDate = new Date(metadata.expiryTime());
            }
            HashMap<String, String> ispnMetadata = new HashMap<String, String>();
            ispnMetadata.put(LIFESPAN, metadata == null ? "-1" : String.valueOf(metadata.lifespan()));
            ispnMetadata.put(MAX_IDLE, metadata == null ? "-1" : String.valueOf(metadata.maxIdle()));
            ispnMetadata.put(EXPIRE_TIME, metadata == null ? "-1" : String.valueOf(metadata.expiryTime()));
            Blob blob = this.blobStore.blobBuilder(objectName).payload(payload).contentLength(payload.size()).contentType(MediaType.OCTET_STREAM).expires(expiresDate).userMetadata(ispnMetadata).build();
            this.blobStore.putBlob(this.containerName, blob);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void clear() {
        this.blobStore.clearContainer(this.containerName);
    }

    public boolean delete(Object key) {
        String objectName = this.encodeKey(key);
        if (this.blobStore.blobExists(this.containerName, objectName)) {
            this.blobStore.removeBlob(this.containerName, objectName);
            return true;
        }
        return false;
    }

    public MarshalledEntry<K, V> load(Object key) {
        byte[] payloadByteArray;
        String objectName = this.encodeKey(key);
        Blob blob = this.blobStore.getBlob(this.containerName, objectName);
        if (blob == null) {
            return null;
        }
        MutableBlobMetadata blobMetadata = blob.getMetadata();
        if (this.isExpired((BlobMetadata)blobMetadata)) {
            this.blobStore.removeBlob(this.containerName, objectName);
            return null;
        }
        try {
            HashCode actualHash;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Streams.copy((InputStream)blob.getPayload().openStream(), (OutputStream)bos);
            byte[] payloadRaw = bos.toByteArray();
            HashCode expectedHashCode = blob.getMetadata().getContentMetadata().getContentMD5AsHashCode();
            if (expectedHashCode != null && expectedHashCode.equals((Object)(actualHash = HashCode.fromBytes((byte[])payloadRaw)))) {
                throw new PersistenceException("MD5 hash failed when reading data from " + blob.getMetadata().getName());
            }
            payloadByteArray = this.configuration.compress() ? this.uncompress(payloadRaw) : payloadRaw;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        Map ispnMetadata = blob.getMetadata().getUserMetadata();
        Date expiresDate = blobMetadata.getContentMetadata().getExpires();
        long ttl = -1L;
        long maxIdle = -1L;
        long now = this.initializationContext.getTimeService().wallClockTime();
        if (ispnMetadata != null) {
            try {
                ttl = ispnMetadata.containsKey(LIFESPAN) ? Long.parseLong((String)ispnMetadata.get(LIFESPAN)) : -1L;
                maxIdle = ispnMetadata.containsKey(MAX_IDLE) ? Long.parseLong((String)ispnMetadata.get(MAX_IDLE)) : -1L;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (expiresDate != null) {
            ttl = expiresDate.getTime() - now;
        }
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(ttl, TimeUnit.MILLISECONDS).maxIdle(maxIdle, TimeUnit.MILLISECONDS).build();
        InternalMetadataImpl internalMetadata = new InternalMetadataImpl(metadata, now, now);
        try {
            return this.initializationContext.getMarshalledEntryFactory().newMarshalledEntry(key, this.unmarshall(payloadByteArray), (InternalMetadata)internalMetadata);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void process(KeyFilter<? super K> keyFilter, AdvancedCacheLoader.CacheLoaderTask<K, V> cacheLoaderTask, Executor executor, boolean loadValue, boolean loadMetadata) {
        PageSet pageSet;
        String nextMarker = null;
        do {
            ListContainerOptions.ImmutableListContainerOptions listOptions = nextMarker == null ? ListContainerOptions.NONE : ListContainerOptions.Builder.afterMarker(nextMarker);
            pageSet = this.blobStore.list(this.containerName, (ListContainerOptions)listOptions);
            ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
            TaskContextImpl taskContext = new TaskContextImpl();
            HashSet<Object> entries = new HashSet<Object>(1000);
            for (StorageMetadata blobMetadata : pageSet) {
                Object key = this.key2StringMapper.getKeyMapping(blobMetadata.getName());
                if (keyFilter == null || keyFilter.accept(key)) {
                    entries.add(key);
                }
                if (entries.size() != 1000) continue;
                HashSet<Object> batch = entries;
                entries = new HashSet(1000);
                this.submitProcessTask(cacheLoaderTask, (CompletionService<Void>)eacs, (AdvancedCacheLoader.TaskContext)taskContext, batch, loadValue, loadMetadata);
            }
            if (!entries.isEmpty()) {
                this.submitProcessTask(cacheLoaderTask, (CompletionService<Void>)eacs, (AdvancedCacheLoader.TaskContext)taskContext, entries, loadValue, loadMetadata);
            }
            eacs.waitUntilAllCompleted();
            if (!eacs.isExceptionThrown()) continue;
            throw new PersistenceException("Process execution exception!", (Throwable)eacs.getFirstException());
        } while ((nextMarker = pageSet.getNextMarker()) != null);
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask<K, V> cacheLoaderTask, CompletionService<Void> ecs, final AdvancedCacheLoader.TaskContext taskContext, final Set<Object> batch, final boolean loadEntry, final boolean loadMetadata) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    for (Object key : batch) {
                        if (!taskContext.isStopped()) {
                            if (!loadEntry && !loadMetadata) {
                                cacheLoaderTask.processEntry(CloudStore.this.initializationContext.getMarshalledEntryFactory().newMarshalledEntry(key, null, null), taskContext);
                                continue;
                            }
                            cacheLoaderTask.processEntry(CloudStore.this.load(key), taskContext);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    log.errorExecutingParallelStoreTask(e);
                    throw e;
                }
                return null;
            }
        });
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        PageSet pageSet;
        String nextMarker = null;
        do {
            ListContainerOptions.ImmutableListContainerOptions listOptions = nextMarker == null ? ListContainerOptions.NONE : ListContainerOptions.Builder.afterMarker(nextMarker);
            pageSet = this.blobStore.list(this.containerName, (ListContainerOptions)listOptions);
            ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
            HashSet<String> entries = new HashSet<String>(1000);
            for (StorageMetadata storageMetadata : pageSet) {
                Blob blob;
                MutableBlobMetadata blobMetadata;
                if (!storageMetadata.getType().equals((Object)StorageType.BLOB) || !this.isExpired((BlobMetadata)(blobMetadata = (blob = this.blobStore.getBlob(this.containerName, storageMetadata.getName())).getMetadata()))) continue;
                entries.add(storageMetadata.getName());
                if (entries.size() != 1000) continue;
                HashSet<String> batch = entries;
                entries = new HashSet(1000);
                this.submitPurgeTask((CompletionService<Void>)eacs, batch, purgeListener);
            }
            if (!entries.isEmpty()) {
                this.submitPurgeTask((CompletionService<Void>)eacs, entries, purgeListener);
            }
            eacs.waitUntilAllCompleted();
            if (!eacs.isExceptionThrown()) continue;
            throw new PersistenceException("Purge execution exception!", (Throwable)eacs.getFirstException());
        } while ((nextMarker = pageSet.getNextMarker()) != null);
    }

    private void submitPurgeTask(CompletionService<Void> ecs, final Set<String> batch, final AdvancedCacheWriter.PurgeListener<? super K> purgeListener) {
        ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    for (String key : batch) {
                        CloudStore.this.blobStore.removeBlob(CloudStore.this.containerName, key);
                        purgeListener.entryPurged(CloudStore.this.key2StringMapper.getKeyMapping(key));
                    }
                }
                catch (Exception e) {
                    log.errorExecutingParallelStoreTask(e);
                    throw e;
                }
                return null;
            }
        });
    }

    public int size() {
        return (int)this.blobStore.countBlobs(this.containerName);
    }

    public boolean contains(Object key) {
        String objectName = this.encodeKey(key);
        Blob blob = this.blobStore.getBlob(this.containerName, objectName);
        if (blob == null) {
            return false;
        }
        MutableBlobMetadata blobMetadata = blob.getMetadata();
        if (this.isExpired((BlobMetadata)blobMetadata)) {
            this.blobStore.removeBlob(this.containerName, objectName);
            return false;
        }
        return true;
    }

    protected boolean isExpired(BlobMetadata blobMetadata) {
        long now = this.initializationContext.getTimeService().wallClockTime();
        Map ispnMetadata = blobMetadata.getUserMetadata();
        long et = -1L;
        if (ispnMetadata != null && ispnMetadata.containsKey(EXPIRE_TIME)) {
            try {
                et = ispnMetadata.containsKey(EXPIRE_TIME) ? Long.parseLong((String)ispnMetadata.get(EXPIRE_TIME)) : -1L;
            }
            catch (NumberFormatException e) {
                if (blobMetadata.getContentMetadata().getExpires() != null) {
                    et = blobMetadata.getContentMetadata().getExpires().getTime();
                }
            }
        } else if (blobMetadata.getContentMetadata().getExpires() != null) {
            et = blobMetadata.getContentMetadata().getExpires().getTime();
        }
        return et > -1L && et < now;
    }

    private byte[] uncompress(byte[] compressedByteArray) throws IOException, PersistenceException {
        ByteArrayInputStream bis = new ByteArrayInputStream(compressedByteArray);
        GZIPInputStream is = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Streams.copy((InputStream)is, (OutputStream)bos);
        byte[] uncompressedByteArray = bos.toByteArray();
        is.close();
        bis.close();
        bos.close();
        return uncompressedByteArray;
    }

    private byte[] compress(byte[] uncompressedByteArray) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(uncompressedByteArray);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        Streams.copy((InputStream)input, (OutputStream)output);
        output.close();
        ((InputStream)input).close();
        byte[] compressedByteArray = baos.toByteArray();
        baos.close();
        return compressedByteArray;
    }
}

