/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    PROVIDER("provider"),
    LOCATION("location"),
    IDENTITY("identity"),
    CREDENTIAL("credential"),
    CONTAINER("container"),
    ENDPOINT("endpoint"),
    KEY_TO_STRING_MAPPER("key-to-string-mapper"),
    COMPRESS("compress"),
    OVERRIDES("overrides");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

