/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud.configuration;

import java.util.Properties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfiguration;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfigurationChildBuilder;
import org.infinispan.persistence.cloud.logging.Log;
import org.infinispan.persistence.keymappers.MarshalledValueOrPrimitiveMapper;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.util.logging.LogFactory;

public class CloudStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<CloudStoreConfiguration, CloudStoreConfigurationBuilder>
implements CloudStoreConfigurationChildBuilder<CloudStoreConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(CloudStoreConfigurationBuilder.class, Log.class);
    private String provider;
    private String location;
    private String identity;
    private String credential;
    private String container;
    private String endpoint;
    private String key2StringMapper = MarshalledValueOrPrimitiveMapper.class.getName();
    private boolean compress;
    private Properties overrides;

    public CloudStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public CloudStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder provider(String provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder identity(String identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder credential(String credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder container(String container) {
        this.container = container;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.key2StringMapper = key2StringMapper;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder key2StringMapper(Class<? extends MarshallingTwoWayKey2StringMapper> klass) {
        this.key2StringMapper = klass.getName();
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder overrides(Properties overrides) {
        this.overrides = overrides;
        return this;
    }

    public CloudStoreConfiguration create() {
        return new CloudStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.provider, this.location, this.identity, this.credential, this.container, this.endpoint, this.key2StringMapper, this.compress, this.overrides);
    }

    public CloudStoreConfigurationBuilder read(CloudStoreConfiguration template) {
        this.provider = template.provider();
        this.location = template.location();
        this.identity = template.identity();
        this.credential = template.credential();
        this.container = template.container();
        this.endpoint = template.endpoint();
        this.key2StringMapper = template.key2StringMapper();
        this.compress = template.compress();
        this.overrides = template.overrides();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.shared = template.shared();
        this.preload = template.preload();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public void validate() {
        if (this.provider == null) {
            throw log.providerNotSpecified();
        }
        if (this.location == null) {
            throw log.locationNotSpecified();
        }
        if (this.identity == null) {
            throw log.identityNotSpecified();
        }
        if (this.credential == null) {
            throw log.credentialNotSpecified();
        }
        if (this.container == null) {
            throw log.containerNotSpecified();
        }
    }
}

