/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.cloud.CloudStore;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfigurationBuilder;
import org.infinispan.persistence.cloud.configuration.parser.CloudStoreConfigurationSerializer;
import org.infinispan.persistence.keymappers.WrappedByteArrayOrPrimitiveMapper;

@BuiltBy(value=CloudStoreConfigurationBuilder.class)
@ConfigurationFor(value=CloudStore.class)
@SerializedWith(value=CloudStoreConfigurationSerializer.class)
public class CloudStoreConfiguration
extends AbstractStoreConfiguration {
    static final AttributeDefinition<String> PROVIDER = AttributeDefinition.builder((String)"provider", null, String.class).immutable().build();
    static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", null, String.class).immutable().build();
    static final AttributeDefinition<String> IDENTITY = AttributeDefinition.builder((String)"identity", null, String.class).immutable().build();
    static final AttributeDefinition<String> CREDENTIAL = AttributeDefinition.builder((String)"credential", null, String.class).immutable().build();
    static final AttributeDefinition<String> CONTAINER = AttributeDefinition.builder((String)"container", null, String.class).immutable().build();
    static final AttributeDefinition<String> ENDPOINT = AttributeDefinition.builder((String)"endpoint", null, String.class).immutable().build();
    static final AttributeDefinition<Boolean> COMPRESS = AttributeDefinition.builder((String)"compress", (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> NORMALIZE = AttributeDefinition.builder((String)"normalize-cache-names", (Object)false).immutable().build();
    static final AttributeDefinition<String> KEY2STRING_MAPPER = AttributeDefinition.builder((String)"key2StringMapper", (Object)WrappedByteArrayOrPrimitiveMapper.class.getName()).immutable().xmlName("key-to-string-mapper").build();
    private final Attribute<String> provider;
    private final Attribute<String> location;
    private final Attribute<String> identity;
    private final Attribute<String> credential;
    private final Attribute<String> container;
    private final Attribute<String> endpoint;
    private final Attribute<Boolean> compress;
    private final Attribute<Boolean> normalizeCacheNames;
    private final Attribute<String> key2StringMapper;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CloudStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{PROVIDER, LOCATION, IDENTITY, CREDENTIAL, CONTAINER, ENDPOINT, COMPRESS, NORMALIZE, KEY2STRING_MAPPER});
    }

    public CloudStoreConfiguration(AttributeSet attributeSet, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(attributeSet, async, singletonStore);
        this.provider = attributeSet.attribute(PROVIDER);
        this.location = attributeSet.attribute(LOCATION);
        this.identity = attributeSet.attribute(IDENTITY);
        this.credential = attributeSet.attribute(CREDENTIAL);
        this.container = attributeSet.attribute(CONTAINER);
        this.endpoint = attributeSet.attribute(ENDPOINT);
        this.compress = attributeSet.attribute(COMPRESS);
        this.normalizeCacheNames = attributeSet.attribute(NORMALIZE);
        this.key2StringMapper = attributeSet.attribute(KEY2STRING_MAPPER);
    }

    public String provider() {
        return (String)this.provider.get();
    }

    public String location() {
        return (String)this.location.get();
    }

    public String identity() {
        return (String)this.identity.get();
    }

    public String credential() {
        return (String)this.credential.get();
    }

    public String container() {
        return (String)this.container.get();
    }

    public String endpoint() {
        return (String)this.endpoint.get();
    }

    public String key2StringMapper() {
        return (String)this.key2StringMapper.get();
    }

    public boolean compress() {
        return (Boolean)this.compress.get();
    }

    public boolean normalizeCacheNames() {
        return (Boolean)this.normalizeCacheNames.get();
    }
}

