/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud.configuration;

import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfiguration;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfigurationChildBuilder;
import org.infinispan.persistence.cloud.logging.Log;
import org.infinispan.persistence.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.util.logging.LogFactory;

public class CloudStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<CloudStoreConfiguration, CloudStoreConfigurationBuilder>
implements CloudStoreConfigurationChildBuilder<CloudStoreConfigurationBuilder> {
    private static final Log log = (Log)LogFactory.getLog(CloudStoreConfigurationBuilder.class, Log.class);

    public CloudStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, CloudStoreConfiguration.attributeDefinitionSet());
    }

    public CloudStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    public CloudStoreConfigurationBuilder provider(String provider) {
        this.attributes.attribute(CloudStoreConfiguration.PROVIDER).set((Object)provider);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(CloudStoreConfiguration.LOCATION).set((Object)location);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder identity(String identity) {
        this.attributes.attribute(CloudStoreConfiguration.IDENTITY).set((Object)identity);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder credential(String credential) {
        this.attributes.attribute(CloudStoreConfiguration.CREDENTIAL).set((Object)credential);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder container(String container) {
        this.attributes.attribute(CloudStoreConfiguration.CONTAINER).set((Object)container);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder endpoint(String endpoint) {
        this.attributes.attribute(CloudStoreConfiguration.ENDPOINT).set((Object)endpoint);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.attributes.attribute(CloudStoreConfiguration.KEY2STRING_MAPPER).set((Object)key2StringMapper);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder key2StringMapper(Class<? extends MarshallingTwoWayKey2StringMapper> klass) {
        this.attributes.attribute(CloudStoreConfiguration.KEY2STRING_MAPPER).set((Object)klass.getName());
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder compress(boolean compress) {
        this.attributes.attribute(CloudStoreConfiguration.COMPRESS).set((Object)compress);
        return this.self();
    }

    @Override
    public CloudStoreConfigurationBuilder normalizeCacheNames(boolean normalizeCacheNames) {
        this.attributes.attribute(CloudStoreConfiguration.NORMALIZE).set((Object)normalizeCacheNames);
        return this.self();
    }

    public CloudStoreConfiguration create() {
        return new CloudStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create());
    }

    public CloudStoreConfigurationBuilder read(CloudStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        return this.self();
    }

    public void validate() {
        if (this.attributes.attribute(CloudStoreConfiguration.PROVIDER).isNull()) {
            throw log.providerNotSpecified();
        }
        if (this.attributes.attribute(CloudStoreConfiguration.IDENTITY).isNull()) {
            throw log.identityNotSpecified();
        }
        if (this.attributes.attribute(CloudStoreConfiguration.CREDENTIAL).isNull()) {
            throw log.credentialNotSpecified();
        }
        if (this.attributes.attribute(CloudStoreConfiguration.CONTAINER).isNull()) {
            throw log.containerNotSpecified();
        }
    }
}

