/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cloud.configuration.parser;

import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.cloud.configuration.CloudStoreConfigurationBuilder;
import org.infinispan.persistence.cloud.configuration.parser.Attribute;
import org.infinispan.persistence.cloud.configuration.parser.Element;

@Namespaces(value={@Namespace(root="cloud-store"), @Namespace(uri="urn:infinispan:config:store:cloud:*", root="cloud-store", since="7.2")})
public class CloudStoreConfigurationParser
implements ConfigurationParser {
    public static final String ROOT_ELEMENT = "cloud-store";
    public static final String OVERRIDES_SEPARATOR = ",";
    public static final String PROPERTY_SEPARATOR = "=";

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CLOUD_STORE: {
                this.parseCloudStore(reader, builder.persistence(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseCloudStore(XMLExtendedStreamReader reader, PersistenceConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        CloudStoreConfigurationBuilder builder = new CloudStoreConfigurationBuilder(loadersBuilder);
        this.parseCloudStoreAttributes(reader, builder, classLoader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((StoreConfigurationBuilder)builder);
    }

    private void parseCloudStoreAttributes(XMLExtendedStreamReader reader, CloudStoreConfigurationBuilder builder, ClassLoader classLoader) throws XMLStreamException {
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            String attributeName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attributeName);
            switch (attribute) {
                case PROVIDER: {
                    builder.provider(value);
                    continue block14;
                }
                case LOCATION: {
                    builder.location(value);
                    continue block14;
                }
                case IDENTITY: {
                    builder.identity(value);
                    continue block14;
                }
                case CREDENTIAL: {
                    builder.credential(value);
                    continue block14;
                }
                case CONTAINER: {
                    builder.container(value);
                    continue block14;
                }
                case ENDPOINT: {
                    builder.endpoint(value);
                    continue block14;
                }
                case KEY_TO_STRING_MAPPER: {
                    builder.key2StringMapper(value);
                    continue block14;
                }
                case COMPRESS: {
                    builder.compress(Boolean.parseBoolean(value));
                    continue block14;
                }
                case OVERRIDES: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                    }
                    try {
                        builder.properties(this.parseProperties(value));
                    }
                    catch (IllegalArgumentException e) {
                        ParseUtils.invalidAttributeValue((XMLStreamReader)reader, (int)i);
                    }
                    continue block14;
                }
                case NORMALIZE_CACHE_NAMES: {
                    builder.normalizeCacheNames(Boolean.parseBoolean(value));
                    continue block14;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private Properties parseProperties(String properties) throws IllegalArgumentException {
        String[] props;
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        Properties overrides = new Properties();
        for (String prop : props = properties.split(OVERRIDES_SEPARATOR)) {
            String[] keyVal = prop.split(PROPERTY_SEPARATOR);
            if (keyVal.length != 2 || keyVal[0] == null || keyVal[1] == null) {
                throw new IllegalArgumentException(prop);
            }
            overrides.put(keyVal[0].trim(), keyVal[1].trim());
        }
        return overrides;
    }
}

