/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.hbase.HBaseCacheStoreConfig;
import org.infinispan.loaders.hbase.configuration.HBaseCacheStoreConfigurationBuilder;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=HBaseCacheStoreConfigurationBuilder.class)
public class HBaseCacheStoreConfiguration
extends AbstractStoreConfiguration
implements LegacyLoaderAdapter<HBaseCacheStoreConfig> {
    private final boolean autoCreateTable;
    private final String entryColumnFamily;
    private final String entryTable;
    private final String entryValueField;
    private final String expirationColumnFamily;
    private final String expirationTable;
    private final String expirationValueField;
    private final String hbaseZookeeperQuorumHost;
    private final int hbaseZookeeperClientPort;
    private final String keyMapper;
    private final boolean sharedTable;

    public HBaseCacheStoreConfiguration(boolean autoCreateTable, String entryColumnFamily, String entryTable, String entryValueField, String expirationColumnFamily, String expirationTable, String expirationValueField, String hbaseZookeeperQuorumHost, int hbaseZookeeperClientPort, String keyMapper, boolean sharedTable, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration asyncStoreConfiguration, SingletonStoreConfiguration singletonStoreConfiguration) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, asyncStoreConfiguration, singletonStoreConfiguration);
        this.autoCreateTable = autoCreateTable;
        this.entryColumnFamily = entryColumnFamily;
        this.entryTable = entryTable;
        this.entryValueField = entryValueField;
        this.expirationColumnFamily = expirationColumnFamily;
        this.expirationTable = expirationTable;
        this.expirationValueField = expirationValueField;
        this.hbaseZookeeperQuorumHost = hbaseZookeeperQuorumHost;
        this.hbaseZookeeperClientPort = hbaseZookeeperClientPort;
        this.keyMapper = keyMapper;
        this.sharedTable = sharedTable;
    }

    public boolean autoCreateTable() {
        return this.autoCreateTable;
    }

    public String entryColumnFamily() {
        return this.entryColumnFamily;
    }

    public String entryTable() {
        return this.entryTable;
    }

    public String entryValueField() {
        return this.entryValueField;
    }

    public String expirationColumnFamily() {
        return this.expirationColumnFamily;
    }

    public String expirationTable() {
        return this.expirationTable;
    }

    public String expirationValueField() {
        return this.expirationValueField;
    }

    public String hbaseZookeeperQuorumHost() {
        return this.hbaseZookeeperQuorumHost;
    }

    public int hbaseZookeeperClientPort() {
        return this.hbaseZookeeperClientPort;
    }

    public String keyMapper() {
        return this.keyMapper;
    }

    public boolean sharedTable() {
        return this.sharedTable;
    }

    public HBaseCacheStoreConfig adapt() {
        HBaseCacheStoreConfig config = new HBaseCacheStoreConfig();
        LegacyConfigurationAdaptor.adapt((StoreConfiguration)this, (CacheStoreConfig)config);
        config.setAutoCreateTable(this.autoCreateTable);
        config.setEntryColumnFamily(this.entryColumnFamily);
        config.setEntryTable(this.entryTable);
        config.setEntryValueField(this.entryValueField);
        config.setExpirationColumnFamily(this.expirationColumnFamily);
        config.setExpirationTable(this.expirationTable);
        config.setExpirationValueField(this.expirationValueField);
        config.setHbaseZookeeperPropertyClientPort(this.hbaseZookeeperClientPort);
        config.setHbaseZookeeperQuorum(this.hbaseZookeeperQuorumHost);
        config.setKeyMapper(this.keyMapper);
        config.setSharedTable(this.sharedTable);
        return config;
    }
}

