/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.infinispan.loaders.hbase.HBaseException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HBaseFacade {
    private static final Log log = (Log)LogFactory.getLog(HBaseFacade.class, Log.class);
    private static final int SCAN_BATCH_SIZE = 100;
    private static Configuration CONFIG;

    public HBaseFacade() {
        CONFIG = HBaseConfiguration.create();
    }

    public HBaseFacade(Map<String, String> props) {
        this();
        for (Map.Entry<String, String> prop : props.entrySet()) {
            CONFIG.set(prop.getKey(), prop.getValue());
        }
    }

    private void close(HBaseAdmin admin) {
        if (admin != null) {
            try {
                admin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void createTable(String name, List<String> columnFamilies) throws HBaseException {
        this.createTable(name, columnFamilies, 3);
    }

    public void createTable(String name, List<String> columnFamilies, int maxVersions) throws HBaseException {
        if (name == null || "".equals(name)) {
            throw new HBaseException("Table name must not be empty.");
        }
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(CONFIG);
            HTableDescriptor desc = new HTableDescriptor(name.getBytes());
            if (columnFamilies != null) {
                for (String cf : columnFamilies) {
                    HColumnDescriptor colFamilyDesc = new HColumnDescriptor(cf.getBytes());
                    colFamilyDesc.setMaxVersions(maxVersions);
                    desc.addFamily(colFamilyDesc);
                }
            }
            int retries = 0;
            while (true) {
                try {
                    admin.createTable(desc);
                    return;
                }
                catch (PleaseHoldException e) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                        if (++retries < 10) continue;
                        admin.createTable(desc);
                        this.close(admin);
                    }
                    catch (Exception ex) {
                        throw new HBaseException("Exception occurred when creating HBase table.", ex);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                break;
            }
        }
        finally {
            this.close(admin);
        }
    }

    public void deleteTable(String name) throws HBaseException {
        if (name == null || "".equals(name)) {
            throw new HBaseException("Table name must not be empty.");
        }
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(CONFIG);
            admin.disableTable(name);
            admin.deleteTable(name);
        }
        catch (Exception ex) {
            throw new HBaseException("Exception occurred when deleting HBase table.", ex);
        }
        finally {
            this.close(admin);
        }
    }

    public boolean tableExists(String name) throws HBaseException {
        if (name == null || "".equals(name)) {
            throw new HBaseException("Table name must not be empty.");
        }
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(CONFIG);
            boolean bl = admin.isTableAvailable(name);
            return bl;
        }
        catch (Exception ex) {
            throw new HBaseException("Exception occurred when deleting HBase table.", ex);
        }
        finally {
            this.close(admin);
        }
    }

    public void addRow(String tableName, String key, Map<String, Map<String, byte[]>> dataMap) throws HBaseException {
        if (tableName == null || "".equals(tableName)) {
            throw new HBaseException("Table name must not be empty.");
        }
        if (this.isEmpty(key)) {
            throw new IllegalArgumentException("key cannot be null or empty.");
        }
        if (this.isEmpty(dataMap)) {
            throw new IllegalArgumentException("dataMap cannot be null or empty.");
        }
        log.debugf("Writing %s data values to table %s and key %s.", (Object)dataMap.size(), (Object)tableName, (Object)key);
        HTable table = null;
        try {
            table = new HTable(CONFIG, tableName);
            Put p = new Put(Bytes.toBytes((String)key));
            for (Map.Entry<String, Map<String, byte[]>> columFamilyEntry : dataMap.entrySet()) {
                String cfName = columFamilyEntry.getKey();
                Map<String, byte[]> cfDataCells = columFamilyEntry.getValue();
                for (Map.Entry<String, byte[]> dataCellEntry : cfDataCells.entrySet()) {
                    p.add(Bytes.toBytes((String)cfName), Bytes.toBytes((String)dataCellEntry.getKey()), Bytes.toBytes((ByteBuffer)ByteBuffer.wrap(dataCellEntry.getValue())));
                }
            }
            table.put(p);
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while writing row to HBase.", ex);
        }
        finally {
            try {
                table.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, Map<String, byte[]>> readRow(String tableName, String key, List<String> columnFamilies) throws HBaseException {
        HashMap<String, Map<String, byte[]>> hashMap;
        if (tableName == null || "".equals(tableName)) {
            throw new HBaseException("Table name must not be empty.");
        }
        if (this.isEmpty(key)) {
            throw new IllegalArgumentException("key cannot be null or empty.");
        }
        if (this.isEmpty(columnFamilies)) {
            throw new IllegalArgumentException("columnFamilies cannot be null or empty.");
        }
        log.debugf("Reading row from table %s and key %s.", (Object)tableName, (Object)key);
        HTable table = null;
        try {
            table = new HTable(CONFIG, tableName);
            Get g = new Get(Bytes.toBytes((String)key));
            Result result = table.get(g);
            HashMap<String, Map<String, byte[]>> resultMap = new HashMap<String, Map<String, byte[]>>(columnFamilies.size());
            if (result.isEmpty()) {
                HashMap<String, Map<String, byte[]>> hashMap2 = resultMap;
                return hashMap2;
            }
            for (String cfName : columnFamilies) {
                HashMap cfDataMap = new HashMap();
                NavigableMap familyMap = result.getFamilyMap(Bytes.toBytes((String)cfName));
                for (Map.Entry familyMapEntry : familyMap.entrySet()) {
                    cfDataMap.put(new String((byte[])familyMapEntry.getKey()), familyMapEntry.getValue());
                }
                resultMap.put(cfName, cfDataMap);
            }
            hashMap = resultMap;
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while reading row from HBase.", ex);
        }
        finally {
            try {
                table.close();
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public Map<String, Map<String, Map<String, byte[]>>> readRows(String tableName, String keyPrefix, long ts, String columnFamily, String qualifier) throws HBaseException {
        if (tableName == null || "".equals(tableName)) {
            throw new HBaseException("Table name must not be empty.");
        }
        if (this.isEmpty(keyPrefix)) {
            throw new IllegalArgumentException("keyPrefix cannot be null or empty.");
        }
        if (this.isEmpty(columnFamily)) {
            throw new IllegalArgumentException("columnFamily cannot be null or empty.");
        }
        log.debugf("Reading rows from table %s with key prefix %s and ts %s", (Object)tableName, (Object)keyPrefix, (Object)ts);
        HTable table = null;
        ResultScanner scanner = null;
        try {
            table = new HTable(CONFIG, tableName);
            Scan s = new Scan();
            s.setMaxVersions(Integer.MAX_VALUE);
            s.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)qualifier));
            s.setStartRow(Bytes.toBytes((String)keyPrefix));
            s.setStopRow(Bytes.toBytes((String)(keyPrefix + ts)));
            HashMap<String, Map<String, Map<String, byte[]>>> resultMaps = new HashMap<String, Map<String, Map<String, byte[]>>>();
            scanner = table.getScanner(s);
            Result[] resultBatch = scanner.next(100);
            while (resultBatch != null && resultBatch.length > 0) {
                for (int i = 0; i < resultBatch.length; ++i) {
                    if (resultBatch[i].isEmpty()) continue;
                    List kv = resultBatch[i].getColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)qualifier));
                    HashMap<String, byte[]> resultCFMap = new HashMap<String, byte[]>();
                    for (KeyValue keyValue : kv) {
                        resultCFMap.put(qualifier, keyValue.getValue());
                    }
                    Map resultMap = Collections.singletonMap(columnFamily, resultCFMap);
                    resultMaps.put(this.getKeyFromResult(resultBatch[i]), resultMap);
                }
                resultBatch = scanner.next(100);
            }
            HashMap<String, Map<String, Map<String, byte[]>>> hashMap = resultMaps;
            return hashMap;
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while reading rows from HBase.", ex);
        }
        finally {
            try {
                table.close();
                scanner.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean removeRow(String tableName, String key) throws HBaseException {
        if (tableName == null || "".equals(tableName)) {
            throw new HBaseException("Table name must not be empty.");
        }
        if (this.isEmpty(key)) {
            throw new IllegalArgumentException("key cannot be null or empty.");
        }
        log.debugf("Removing row from table %s with key %s.", (Object)tableName, (Object)key);
        HTable table = null;
        try {
            table = new HTable(CONFIG, tableName);
            Get get = new Get(Bytes.toBytes((String)key));
            boolean exists = table.exists(get);
            if (exists) {
                Delete d = new Delete(Bytes.toBytes((String)key));
                table.delete(d);
            }
            boolean bl = exists;
            return bl;
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while deleting row from HBase.", ex);
        }
        finally {
            try {
                table.close();
            }
            catch (Exception exception) {}
        }
    }

    public void removeRows(String tableName, Set<Object> keys) throws HBaseException {
        if (tableName == null || "".equals(tableName)) {
            throw new HBaseException("Table name must not be empty.");
        }
        if (this.isEmpty(keys)) {
            throw new IllegalArgumentException("keys cannot be null or empty.");
        }
        log.debugf("Removing rows from table %s.", (Object)tableName);
        HTable table = null;
        try {
            table = new HTable(CONFIG, tableName);
            ArrayList<Delete> deletes = new ArrayList<Delete>(keys.size());
            for (Object key : keys) {
                deletes.add(new Delete(Bytes.toBytes((String)((String)key))));
            }
            table.delete(deletes);
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while deleting rows from HBase.", ex);
        }
        finally {
            try {
                table.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, byte[]> scan(String tableName, String columnFamily, String qualifier) throws HBaseException {
        return this.scan(tableName, Integer.MAX_VALUE, columnFamily, qualifier);
    }

    public Map<String, byte[]> scan(String tableName, int numEntries, String columnFamily, String qualifier) throws HBaseException {
        if (this.isEmpty(tableName)) {
            throw new IllegalArgumentException("tableName cannot be null or empty.");
        }
        if (this.isEmpty(columnFamily)) {
            throw new IllegalArgumentException("colFamily cannot be null or empty.");
        }
        if (this.isEmpty(qualifier)) {
            throw new IllegalArgumentException("field cannot be null or empty.");
        }
        if (numEntries < 0) {
            numEntries = Integer.MAX_VALUE;
        }
        log.debugf("Scanning table %s.", (Object)tableName);
        ResultScanner scanner = null;
        HTable table = null;
        try {
            int batchSize;
            Result[] batch;
            table = new HTable(CONFIG, tableName);
            scanner = table.getScanner(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)qualifier));
            HashMap<String, byte[]> results = new HashMap<String, byte[]>();
            for (int ct = 0; ct < numEntries && (batch = scanner.next(batchSize = Math.min(100, numEntries - ct))).length > 0; ct += batch.length) {
                for (int i = 0; i < batch.length; ++i) {
                    Result curr = batch[i];
                    String key = this.getKeyFromResult(curr);
                    byte[] valueArr = null;
                    if (curr.containsColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)qualifier))) {
                        valueArr = curr.getValue(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)qualifier));
                        log.tracef("Value=%s", (Object)Bytes.toString((byte[])valueArr));
                    }
                    log.tracef("Added %s->%s", (Object)key, (Object)Bytes.toString(valueArr));
                    results.put(key, valueArr);
                }
            }
            HashMap<String, byte[]> hashMap = results;
            return hashMap;
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while scanning table " + tableName + ".", ex);
        }
        catch (Exception ex) {
            throw new HBaseException("Exception happened while scanning table " + tableName + ".", ex);
        }
        finally {
            scanner.close();
            try {
                table.close();
                scanner.close();
            }
            catch (Exception exception) {}
        }
    }

    public Set<Object> scanForKeys(String tableName) throws HBaseException {
        if (this.isEmpty(tableName)) {
            throw new IllegalArgumentException("tableName cannot be null or empty.");
        }
        log.debugf("Scanning table %s for keys.", (Object)tableName);
        ResultScanner scanner = null;
        HTable table = null;
        try {
            table = new HTable(CONFIG, tableName);
            scanner = table.getScanner(new Scan());
            HashSet<Object> results = new HashSet<Object>();
            Result[] resultBatch = scanner.next(100);
            while (resultBatch != null && resultBatch.length > 0) {
                for (int i = 0; i < resultBatch.length; ++i) {
                    String key = this.getKeyFromResult(resultBatch[i]);
                    results.add(key);
                }
                resultBatch = scanner.next(100);
            }
            HashSet<Object> hashSet = results;
            return hashSet;
        }
        catch (IOException ex) {
            throw new HBaseException("Exception happened while scanning table " + tableName + ".", ex);
        }
        finally {
            scanner.close();
            try {
                table.close();
                scanner.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getKeyFromResult(Result result) {
        List l = result.list();
        String key = null;
        KeyValue keyValue = (KeyValue)l.get(0);
        String keyValStr = keyValue.toString();
        int index = keyValStr.indexOf("/");
        key = keyValStr.substring(0, index);
        return key;
    }

    private boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && "".equals(o)) {
            return true;
        }
        if (o instanceof List && ((List)o).size() < 1) {
            return true;
        }
        if (o instanceof Map && ((Map)o).size() < 1) {
            return true;
        }
        return o instanceof byte[] && ((byte[])o).length < 1;
    }
}

