/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.util.Bytes;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.hbase.HBaseCacheStoreConfig;
import org.infinispan.loaders.hbase.HBaseException;
import org.infinispan.loaders.hbase.HBaseFacade;
import org.infinispan.loaders.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=HBaseCacheStoreConfig.class)
public class HBaseCacheStore
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(HBaseCacheStore.class, Log.class);
    private HBaseCacheStoreConfig config;
    private String cacheName;
    private TwoWayKey2StringMapper keyMapper;
    private String entryTable;
    private String entryColumnFamily;
    private String entryValueField;
    private String entryKeyPrefix;
    private String expirationTable;
    private String expirationColumnFamily;
    private String expirationValueField;
    private String expirationKeyPrefix;
    private HBaseFacade hbf;

    public void init(CacheLoaderConfig clc, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(clc, cache, m);
        this.cacheName = cache.getName();
        this.config = (HBaseCacheStoreConfig)clc;
    }

    public void start() throws CacheLoaderException {
        log.debug((Object)"In HBaseCacheStore.start");
        try {
            this.entryTable = this.config.entryTable;
            this.entryColumnFamily = this.config.entryColumnFamily;
            this.entryValueField = this.config.entryValueField;
            this.entryKeyPrefix = "e_" + (this.config.isSharedTable() ? this.cacheName + "_" : "");
            this.expirationTable = this.config.expirationTable;
            this.expirationKeyPrefix = "x_" + (this.config.isSharedTable() ? "_" + this.cacheName : "");
            this.expirationColumnFamily = this.config.expirationColumnFamily;
            this.expirationValueField = this.config.expirationValueField;
            this.keyMapper = (TwoWayKey2StringMapper)Util.getInstance((String)this.config.getKeyMapper(), (ClassLoader)this.config.getClassLoader());
            if (this.keyMapper instanceof MarshallingTwoWayKey2StringMapper) {
                ((MarshallingTwoWayKey2StringMapper)this.keyMapper).setMarshaller(this.getMarshaller());
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hbase.zookeeper.quorum", this.config.hbaseZookeeperQuorum);
            props.put("hbase.zookeeper.property.clientPort", Integer.toString(this.config.hbaseZookeeperPropertyClientPort));
            this.hbf = new HBaseFacade(props);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        if (this.config.autoCreateTable) {
            List<String> colFamilies;
            log.infof("Automatically creating %s and %s tables.", (Object)this.entryTable, (Object)this.expirationTable);
            try {
                colFamilies = Collections.singletonList(this.entryColumnFamily);
                this.hbf.createTable(this.entryTable, colFamilies, 1);
            }
            catch (HBaseException ex) {
                if (ex.getCause() instanceof TableExistsException) {
                    log.infof("Not creating %s because it already exists.", (Object)this.entryTable);
                }
                throw new CacheLoaderException("Got HadoopException while creating the " + this.entryTable + " cache store table.", (Throwable)ex);
            }
            try {
                colFamilies = Collections.singletonList(this.expirationColumnFamily);
                this.hbf.createTable(this.expirationTable, colFamilies, 1);
            }
            catch (HBaseException ex) {
                if (ex.getCause() instanceof TableExistsException) {
                    log.infof("Not creating %s because it already exists.", (Object)this.expirationTable);
                }
                throw new CacheLoaderException("Got HadoopException while creating the " + this.expirationTable + " cache store table.", (Throwable)ex);
            }
        }
        log.info((Object)"Cleaning up expired entries...");
        this.purgeInternal();
        log.info((Object)"HBaseCacheStore started");
        super.start();
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        log.debugf("In HBaseCacheStore.store for %s: %s", (Object)this.entryTable, entry.getKey());
        Object key = entry.getKey();
        String hashedKey = this.hashKey(this.entryKeyPrefix, key);
        try {
            byte[] val = this.marshall(entry);
            Map<String, byte[]> valMap = Collections.singletonMap(this.entryValueField, val);
            Map<String, Map<String, byte[]>> cfMap = Collections.singletonMap(this.entryColumnFamily, valMap);
            this.hbf.addRow(this.entryTable, hashedKey, cfMap);
            if (entry.canExpire()) {
                Map<String, byte[]> expValMap = Collections.singletonMap(this.expirationValueField, Bytes.toBytes((String)hashedKey));
                Map<String, Map<String, byte[]>> expCfMap = Collections.singletonMap(this.expirationColumnFamily, expValMap);
                String expKey = "ts_" + String.valueOf(this.timeService.wallClockTime());
                String hashedExpKey = this.hashKey(this.expirationKeyPrefix, expKey);
                this.hbf.addRow(this.expirationTable, hashedExpKey, expCfMap);
            }
        }
        catch (HBaseException ex) {
            log.error((Object)("HadoopException storing entry: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
        catch (Exception ex2) {
            log.error((Object)("Exception storing entry: " + ex2.getMessage()));
            throw new CacheLoaderException((Throwable)ex2);
        }
    }

    public void fromStream(ObjectInput in) throws CacheLoaderException {
        try {
            int count = 0;
            while (true) {
                ++count;
                InternalCacheEntry entry = (InternalCacheEntry)this.getMarshaller().objectFromObjectStream(in);
                if (entry != null) {
                    this.store(entry);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Interrupted while reading from stream");
            }
            Thread.currentThread().interrupt();
        }
    }

    public void toStream(ObjectOutput out) throws CacheLoaderException {
        try {
            Set<InternalCacheEntry> loadAll = this.loadAll();
            int count = 0;
            for (InternalCacheEntry entry : loadAll) {
                this.getMarshaller().objectToObjectStream((Object)entry, out);
                ++count;
            }
            this.getMarshaller().objectToObjectStream(null, out);
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    public void clear() throws CacheLoaderException {
        String[] tableNames = new String[]{this.entryTable, this.expirationTable};
        String[] keyPrefixes = new String[]{this.entryKeyPrefix, this.expirationKeyPrefix};
        for (int i = 0; i < tableNames.length; ++i) {
            Set<Object> allKeys = this.loadAllKeysForTable(tableNames[i], null);
            HashSet<Object> allKeysHashed = new HashSet<Object>(allKeys.size());
            for (Object key : allKeys) {
                allKeysHashed.add(this.hashKey(keyPrefixes[i], key));
            }
            try {
                this.hbf.removeRows(tableNames[i], allKeysHashed);
                continue;
            }
            catch (HBaseException ex) {
                log.error((Object)("Caught HadoopException clearing the " + tableNames[i] + " table: " + ex.getMessage()));
                throw new CacheLoaderException((Throwable)ex);
            }
        }
    }

    public boolean remove(Object key) throws CacheLoaderException {
        log.debugf("In HBaseCacheStore.remove for key %s", key);
        String hashedKey = this.hashKey(this.entryKeyPrefix, key);
        try {
            return this.hbf.removeRow(this.entryTable, hashedKey);
        }
        catch (HBaseException ex) {
            log.error((Object)("HadoopException removing an object from the cache: " + ex.getMessage()), (Throwable)ex);
            throw new CacheLoaderException("HadoopException removing an object from the cache: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        log.debugf("In HBaseCacheStore.load for key %s", key);
        String hashedKey = this.hashKey(this.entryKeyPrefix, key);
        List<String> colFamilies = Collections.singletonList(this.entryColumnFamily);
        try {
            Map<String, Map<String, byte[]>> resultMap = this.hbf.readRow(this.entryTable, hashedKey, colFamilies);
            if (resultMap.isEmpty()) {
                log.debugf("Key %s not found.", (Object)hashedKey);
                return null;
            }
            byte[] val = resultMap.get(this.entryColumnFamily).get(this.entryValueField);
            InternalCacheEntry ice = this.unmarshall(val, key);
            if (ice != null && ice.isExpired(this.timeService.wallClockTime())) {
                this.remove(key);
                return null;
            }
            return ice;
        }
        catch (HBaseException ex) {
            log.error((Object)("Caught HadoopException: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
        catch (Exception ex2) {
            log.error((Object)("Caught Exception: " + ex2.getMessage()));
            throw new CacheLoaderException((Throwable)ex2);
        }
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        log.debugf("In HBaseCacheStore.load for %s entries.", (Object)numEntries);
        Map<String, byte[]> items = null;
        try {
            items = this.hbf.scan(this.entryTable, numEntries, this.entryColumnFamily, this.entryValueField);
        }
        catch (HBaseException ex) {
            log.error((Object)("Caught HadoopException loading " + numEntries + " entries: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
        HashSet<InternalCacheEntry> iceSet = new HashSet<InternalCacheEntry>(items.size());
        try {
            for (Map.Entry<String, byte[]> entry : items.entrySet()) {
                Object unhashedKey = this.unhashKey(this.entryKeyPrefix, entry.getKey());
                iceSet.add(this.unmarshall(entry.getValue(), unhashedKey));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Caught exception loading items: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
        return iceSet;
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return this.loadAllKeysForTable(this.entryTable, keysToExclude);
    }

    private Set<Object> loadAllKeysForTable(String table, Set<Object> keysToExclude) throws CacheLoaderException {
        log.debugf("In HBaseCacheStore.loadAllKeys for %s", (Object)table);
        Set<Object> allKeys = null;
        try {
            allKeys = this.hbf.scanForKeys(table);
        }
        catch (HBaseException ex) {
            log.error((Object)("HadoopException loading all keys: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
        String keyPrefix = table.equals(this.entryTable) ? this.entryKeyPrefix : this.expirationKeyPrefix;
        HashSet<Object> unhashedKeys = new HashSet<Object>(allKeys.size());
        for (Object hashedKey : allKeys) {
            unhashedKeys.add(this.unhashKey(keyPrefix, hashedKey));
        }
        if (keysToExclude != null) {
            unhashedKeys.removeAll(keysToExclude);
        }
        return unhashedKeys;
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return HBaseCacheStoreConfig.class;
    }

    protected void purgeInternal() throws CacheLoaderException {
        log.debug((Object)"Purging expired entries.");
        try {
            long ts = this.timeService.wallClockTime();
            Map<String, Map<String, Map<String, byte[]>>> rowsToPurge = this.hbf.readRows(this.expirationTable, this.expirationKeyPrefix, ts, this.expirationColumnFamily, this.expirationValueField);
            HashSet<Object> keysToDelete = new HashSet<Object>();
            HashSet<Object> expKeysToDelete = new HashSet<Object>();
            for (Map.Entry<String, Map<String, Map<String, byte[]>>> entry : rowsToPurge.entrySet()) {
                expKeysToDelete.add(entry.getKey());
                byte[] targetKeyBytes = entry.getValue().get(this.expirationColumnFamily).get(this.expirationValueField);
                String targetKey = Bytes.toString((byte[])targetKeyBytes);
                keysToDelete.add(targetKey);
            }
            if (keysToDelete.size() > 0) {
                this.hbf.removeRows(this.entryTable, keysToDelete);
            }
            this.hbf.removeRows(this.expirationTable, expKeysToDelete);
        }
        catch (HBaseException ex) {
            log.error((Object)("HadoopException loading all keys: " + ex.getMessage()));
            throw new CacheLoaderException((Throwable)ex);
        }
    }

    public String toString() {
        return "HBaseCacheStore";
    }

    private String hashKey(String keyPrefix, Object key) throws UnsupportedKeyTypeException {
        if (key == null) {
            return "";
        }
        if (key != null && !this.keyMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return keyPrefix + this.keyMapper.getStringMapping(key);
    }

    private Object unhashKey(String keyPrefix, Object key) {
        String skey = new String(key.toString());
        if (skey.startsWith(keyPrefix)) {
            return this.keyMapper.getKeyMapping(skey.substring(keyPrefix.length()));
        }
        return null;
    }

    private byte[] marshall(InternalCacheEntry entry) throws IOException, InterruptedException {
        return this.getMarshaller().objectToByteBuffer((Object)entry.toInternalCacheValue());
    }

    private InternalCacheEntry unmarshall(Object o, Object key) throws IOException, ClassNotFoundException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        InternalCacheValue v = (InternalCacheValue)this.getMarshaller().objectFromByteBuffer(b);
        return v.toInternalCacheEntry(key);
    }
}

