/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.hbase.configuration;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.hbase.configuration.HBaseCacheStoreConfiguration;
import org.infinispan.loaders.keymappers.MarshalledValueOrPrimitiveMapper;
import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;

public class HBaseCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<HBaseCacheStoreConfiguration, HBaseCacheStoreConfigurationBuilder> {
    private boolean autoCreateTable = true;
    private String entryColumnFamily = "E";
    private String entryTable = "ISPNCacheStore";
    private String entryValueField = "EV";
    private String expirationColumnFamily = "X";
    private String expirationTable = "ISPNCacheStoreExpiration";
    private String expirationValueField = "XV";
    private String hbaseZookeeperQuorumHost = "localhost";
    private int hbaseZookeeperClientPort = 2181;
    private String keyMapper = MarshalledValueOrPrimitiveMapper.class.getName();
    private boolean sharedTable = false;

    public HBaseCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public HBaseCacheStoreConfigurationBuilder self() {
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder autoCreateTable(boolean autoCreateTable) {
        this.autoCreateTable = autoCreateTable;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder entryColumnFamily(String entryColumnFamily) {
        this.entryColumnFamily = entryColumnFamily;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder entryTable(String entryTable) {
        this.entryTable = entryTable;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder entryValueField(String entryValueField) {
        this.entryValueField = entryValueField;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder expirationColumnFamily(String expirationColumnFamily) {
        this.expirationColumnFamily = expirationColumnFamily;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder expirationTable(String expirationTable) {
        this.expirationTable = expirationTable;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder expirationValueField(String expirationValueField) {
        this.expirationValueField = expirationValueField;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder hbaseZookeeperQuorumHost(String hbaseZookeeperQuorumHost) {
        this.hbaseZookeeperQuorumHost = hbaseZookeeperQuorumHost;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder hbaseZookeeperClientPort(int hbaseZookeeperClientPort) {
        this.hbaseZookeeperClientPort = hbaseZookeeperClientPort;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder keyMapper(String keyMapper) {
        this.keyMapper = keyMapper;
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder keyMapper(Class<? extends TwoWayKey2StringMapper> keyMapper) {
        this.keyMapper = keyMapper.getName();
        return this;
    }

    public HBaseCacheStoreConfigurationBuilder sharedTable(boolean sharedTable) {
        this.sharedTable = sharedTable;
        return this;
    }

    public HBaseCacheStoreConfiguration create() {
        return new HBaseCacheStoreConfiguration(this.autoCreateTable, this.entryColumnFamily, this.entryTable, this.entryValueField, this.expirationColumnFamily, this.expirationTable, this.expirationValueField, this.hbaseZookeeperQuorumHost, this.hbaseZookeeperClientPort, this.keyMapper, this.sharedTable, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public HBaseCacheStoreConfigurationBuilder read(HBaseCacheStoreConfiguration template) {
        this.autoCreateTable = template.autoCreateTable();
        this.entryColumnFamily = template.entryColumnFamily();
        this.entryTable = template.entryTable();
        this.entryValueField = template.entryValueField();
        this.expirationColumnFamily = template.expirationColumnFamily();
        this.expirationTable = template.expirationTable();
        this.expirationValueField = template.expirationValueField();
        this.hbaseZookeeperQuorumHost = template.hbaseZookeeperQuorumHost();
        this.hbaseZookeeperClientPort = template.hbaseZookeeperClientPort();
        this.keyMapper = template.keyMapper();
        this.sharedTable = template.sharedTable();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

