package org.infinispan.persistence.jdbc.common.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.sql.SQLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.sql.Connection;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.List;
import java.util.Arrays;
import java.lang.ClassNotFoundException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-01-30T06:58:28-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorMarshallingObject(final Throwable ioe, final Object obj) {
        super.log.logf(FQCN, ERROR, ioe, errorMarshallingObject$str(), obj);
    }
    protected String errorMarshallingObject$str() {
        return "ISPN000065: Exception while marshalling object: %s";
    }
    @Override
    public final void failedClearingJdbcCacheStore(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedClearingJdbcCacheStore$str());
    }
    protected String failedClearingJdbcCacheStore$str() {
        return "ISPN008001: Failed clearing cache store";
    }
    @Override
    public final void sqlFailureIntegratingState(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureIntegratingState$str());
    }
    protected String sqlFailureIntegratingState$str() {
        return "ISPN008003: SQL failure while integrating state into store";
    }
    @Override
    public final void ioErrorUnmarshalling(final IOException e) {
        super.log.logf(FQCN, ERROR, e, ioErrorUnmarshalling$str());
    }
    protected String ioErrorUnmarshalling$str() {
        return "ISPN008009: I/O error while unmarshalling from stream";
    }
    @Override
    public final void unexpectedClassNotFoundException(final ClassNotFoundException e) {
        super.log.logf(FQCN, ERROR, e, unexpectedClassNotFoundException$str());
    }
    protected String unexpectedClassNotFoundException$str() {
        return "ISPN008010: *UNEXPECTED* ClassNotFoundException.";
    }
    @Override
    public final void errorCreatingTable(final String sql, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, errorCreatingTable$str(), sql);
    }
    protected String errorCreatingTable$str() {
        return "ISPN008011: Error while creating table; used DDL statement: '%s'";
    }
    protected String connectionNotFound$str() {
        return "ISPN008015: Could not find a connection in %s under the name '%s'";
    }
    @Override
    public final IllegalStateException connectionNotFound(final String where, final String dataSourceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), connectionNotFound$str(), where, dataSourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void namingExceptionLookingUpConnection(final String dataSourceName, final NamingException e) {
        super.log.logf(FQCN, ERROR, e, namingExceptionLookingUpConnection$str(), dataSourceName);
    }
    protected String namingExceptionLookingUpConnection$str() {
        return "ISPN008016: Could not lookup connection with datasource %s";
    }
    @Override
    public final void failedClosingNamingCtx(final NamingException e) {
        super.log.logf(FQCN, WARN, e, failedClosingNamingCtx$str());
    }
    protected String failedClosingNamingCtx$str() {
        return "ISPN008017: Failed to close naming context.";
    }
    protected String sqlFailureRetrievingConnection$str() {
        return "ISPN008018: Sql failure retrieving connection from datasource";
    }
    @Override
    public final PersistenceException sqlFailureRetrievingConnection(final SQLException e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureRetrievingConnection$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void sqlFailureClosingConnection(final Connection conn, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureClosingConnection$str(), conn);
    }
    protected String sqlFailureClosingConnection$str() {
        return "ISPN008019: Issues while closing connection %s";
    }
    @Override
    public final void sqlFailureUnexpected(final SQLException e) {
        super.log.logf(FQCN, WARN, e, sqlFailureUnexpected$str());
    }
    protected String sqlFailureUnexpected$str() {
        return "ISPN008022: Unexpected sql failure";
    }
    @Override
    public final void failureClosingConnection(final SQLException e) {
        super.log.logf(FQCN, WARN, e, failureClosingConnection$str());
    }
    protected String failureClosingConnection$str() {
        return "ISPN008023: Failure while closing the connection to the database";
    }
    @Override
    public final void sqlFailureStoringKey(final Object lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureStoringKey$str(), lockingKey);
    }
    protected String sqlFailureStoringKey$str() {
        return "ISPN008024: Error while storing string key to database; key: '%s'";
    }
    @Override
    public final void sqlFailureRemovingKeys(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureRemovingKeys$str());
    }
    protected String sqlFailureRemovingKeys$str() {
        return "ISPN008025: Error while removing string keys from database";
    }
    @Override
    public final void invalidKey2StringMapper(final String where, final String className) {
        super.log.logf(FQCN, ERROR, null, invalidKey2StringMapper$str(), where, className);
    }
    protected String invalidKey2StringMapper$str() {
        return "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    }
    @Override
    public final void sqlFailureReadingKey(final Object key, final Object lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureReadingKey$str(), key, lockingKey);
    }
    protected String sqlFailureReadingKey$str() {
        return "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    }
    protected String tableManipulationAttributeNotSet$str() {
        return "ISPN008028: Attribute '%2$s' has not been set on '%1$s'";
    }
    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(final String groupName, final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableManipulationAttributeNotSet$str(), groupName, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingConnectionFactory$str() {
        return "ISPN008029: A ConnectionFactory has not been specified for this store";
    }
    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingConnectionFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void sqlFailureTxCommit(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxCommit$str());
    }
    protected String sqlFailureTxCommit$str() {
        return "ISPN008031: Error committing JDBC transaction";
    }
    @Override
    public final void sqlFailureTxRollback(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxRollback$str());
    }
    protected String sqlFailureTxRollback$str() {
        return "ISPN008032: Error during rollback of JDBC transaction";
    }
    protected String prepareTxFailure$str() {
        return "ISPN008033: Exception encountered when preparing JDBC store Tx";
    }
    @Override
    public final PersistenceException prepareTxFailure(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), prepareTxFailure$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void twoWayKey2StringMapperIsMissing(final String className) {
        super.log.logf(FQCN, WARN, null, twoWayKey2StringMapperIsMissing$str(), className);
    }
    protected String twoWayKey2StringMapperIsMissing$str() {
        return "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    }
    protected String sqlFailureWritingBatch$str() {
        return "ISPN008037: Error while writing entries in batch to the database:";
    }
    @Override
    public final PersistenceException sqlFailureWritingBatch(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureWritingBatch$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String existingStoreNoSegmentation$str() {
        return "ISPN008039: The existing store was created without segmentation enabled";
    }
    @Override
    public final CacheConfigurationException existingStoreNoSegmentation() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingStoreNoSegmentation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String existingStoreSegmentMismatch$str() {
        return "ISPN008040: The existing store was created with %d segments configured, but the cache is configured with %d";
    }
    @Override
    public final CacheConfigurationException existingStoreSegmentMismatch(final int existing, final int cache) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingStoreSegmentMismatch$str(), existing, cache));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void sqlFailureMetaRetrieval(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureMetaRetrieval$str());
    }
    protected String sqlFailureMetaRetrieval$str() {
        return "ISPN008041: Error retrieving JDBC metadata";
    }
    @Override
    public final void sqlFailureSize(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureSize$str());
    }
    protected String sqlFailureSize$str() {
        return "ISPN008042: SQL failure while retrieving size";
    }
    protected String primaryKeyMultipleColumnWithoutSchema$str() {
        return "ISPN008043: Primary key has multiple columns but no key message schema defined, which is required when there is more than one key column";
    }
    @Override
    public final CacheConfigurationException primaryKeyMultipleColumnWithoutSchema() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), primaryKeyMultipleColumnWithoutSchema$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueMultipleColumnWithoutSchema$str() {
        return "ISPN008044: Multiple non key columns but no value message schema defined, which is required when there is more than one value column";
    }
    @Override
    public final CacheConfigurationException valueMultipleColumnWithoutSchema() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), valueMultipleColumnWithoutSchema$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyNotInSchema$str() {
        return "ISPN008045: Primary key %s was not found in the key schema %s";
    }
    @Override
    public final CacheConfigurationException keyNotInSchema(final String primaryKeyName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyNotInSchema$str(), primaryKeyName, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueNotInSchema$str() {
        return "ISPN008046: Additional value columns %s found that were not part of the schema, make sure the columns returned match the value schema %s";
    }
    @Override
    public final CacheConfigurationException valueNotInSchema(final List<String> columnNames, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), valueNotInSchema$str(), columnNames, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String schemaNotFound$str() {
        return "ISPN008047: Schema not found for : %s";
    }
    @Override
    public final CacheConfigurationException schemaNotFound(final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), schemaNotFound$str(), schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyCannotEmbedWithEnum$str() {
        return "ISPN008048: Key cannot be embedded when the value schema %s is an enum";
    }
    @Override
    public final CacheConfigurationException keyCannotEmbedWithEnum(final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyCannotEmbedWithEnum$str(), schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String repeatedFieldsNotSupported$str() {
        return "ISPN008049: Repeated fields are not supported, found %s in schema %s";
    }
    @Override
    public final CacheConfigurationException repeatedFieldsNotSupported(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), repeatedFieldsNotSupported$str(), fieldName, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateFieldInSchema$str() {
        return "ISPN008050: Duplicate name %s found for nested schema: %s";
    }
    @Override
    public final CacheConfigurationException duplicateFieldInSchema(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateFieldInSchema$str(), fieldName, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredSchemaFieldNotPresent$str() {
        return "ISPN008051: Schema contained a field %s that is required but wasn't found in the query for schema %s";
    }
    @Override
    public final CacheConfigurationException requiredSchemaFieldNotPresent(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredSchemaFieldNotPresent$str(), fieldName, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String primaryKeyPresentButNotEmbedded$str() {
        return "ISPN008052: Primary key %s was found in the value schema %s but embedded key was not true";
    }
    @Override
    public final CacheConfigurationException primaryKeyPresentButNotEmbedded(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), primaryKeyPresentButNotEmbedded$str(), fieldName, schemaName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteAndSelectQueryMismatchArguments2$str() {
        return "ISPN008053: Delete and select queries do not have matching arguments. Delete was %s and select was %s";
    }
    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(final List<String> deleteParams, final List<String> selectParams) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAndSelectQueryMismatchArguments2$str(), deleteParams, selectParams));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteAndSelectQueryMismatchArguments3$str() {
        return "ISPN008054: Named parameter %s in upsert statement [%s] is not available in columns from selectAll statement [%s]";
    }
    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(final String paramName, final String upsertStatement, final String selectStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAndSelectQueryMismatchArguments3$str(), paramName, upsertStatement, selectStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String selectAllCannotHaveParameters$str() {
        return "ISPN008055: No parameters are allowed for select all statement %s";
    }
    @Override
    public final CacheConfigurationException selectAllCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), selectAllCannotHaveParameters$str(), selectAllStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteAllCannotHaveParameters$str() {
        return "ISPN008056: No parameters are allowed for delete all statement %s";
    }
    @Override
    public final CacheConfigurationException deleteAllCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAllCannotHaveParameters$str(), selectAllStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sizeCannotHaveParameters$str() {
        return "ISPN008057: No parameters are allowed for sizer statement %s";
    }
    @Override
    public final CacheConfigurationException sizeCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sizeCannotHaveParameters$str(), selectAllStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyColumnsNotReturnedFromSelectAll$str() {
        return "ISPN008058: Not all key columns %s were returned from select all statement %s";
    }
    @Override
    public final CacheConfigurationException keyColumnsNotReturnedFromSelectAll(final String keyColumns, final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyColumnsNotReturnedFromSelectAll$str(), keyColumns, selectAllStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedParamNotReturnedFromSelect$str() {
        return "ISPN008059: Select parameter %s is not returned from select all statement %s, select statement is %s";
    }
    @Override
    public final CacheConfigurationException namedParamNotReturnedFromSelect(final String paramName, final String selectAllStatement, final String selectStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), namedParamNotReturnedFromSelect$str(), paramName, selectAllStatement, selectStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonTerminatedNamedParamInSql$str() {
        return "ISPN008060: Non-terminated named parameter declaration at position %d in statement: %s";
    }
    @Override
    public final CacheConfigurationException nonTerminatedNamedParamInSql(final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonTerminatedNamedParamInSql$str(), position, sqlStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCharacterInSql$str() {
        return "ISPN008061: Invalid character %s at position %d in statement: %s";
    }
    @Override
    public final CacheConfigurationException invalidCharacterInSql(final char character, final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCharacterInSql$str(), character, position, sqlStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unnamedParametersNotAllowed$str() {
        return "ISPN008062: Unnamed parameters are not allowed, found one at %d in statement %s";
    }
    @Override
    public final CacheConfigurationException unnamedParametersNotAllowed(final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unnamedParametersNotAllowed$str(), position, sqlStatement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tableNotInCorrectFormat$str() {
        return "ISPN008063: Provided table name %s is not in form of (<SCHEMA>.)<TABLE-NAME> where SCHEMA is optional";
    }
    @Override
    public final CacheConfigurationException tableNotInCorrectFormat(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableNotInCorrectFormat$str(), tableName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPrimaryKeysFoundForTable$str() {
        return "ISPN008064: No primary keys found for table %s, check case sensitivity";
    }
    @Override
    public final CacheConfigurationException noPrimaryKeysFoundForTable(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noPrimaryKeysFoundForTable$str(), tableName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noValueColumnForTable$str() {
        return "ISPN008065: No column found that wasn't a primary key for table: %s";
    }
    @Override
    public final CacheConfigurationException noValueColumnForTable(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noValueColumnForTable$str(), tableName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetectDialect$str() {
        return "ISPN008066: Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are %s";
    }
    @Override
    public final CacheConfigurationException unableToDetectDialect(final String supportedDialects) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToDetectDialect$str(), supportedDialects));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredStatementsForQueryStoreLoader$str() {
        return "ISPN008067: The size, select and select all attributes must be set for a query store";
    }
    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreLoader() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredStatementsForQueryStoreLoader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredStatementsForQueryStoreWriter$str() {
        return "ISPN008068: The delete, delete all and upsert attributes must be set for a query store that allows writes";
    }
    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreWriter() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredStatementsForQueryStoreWriter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyColumnsRequired$str() {
        return "ISPN008069: Key columns are required for QueryStore";
    }
    @Override
    public final CacheConfigurationException keyColumnsRequired() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyColumnsRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageNameRequiredIfEmbeddedKey$str() {
        return "ISPN008070: Message name must not be null if embedded key is true";
    }
    @Override
    public final CacheConfigurationException messageNameRequiredIfEmbeddedKey() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), messageNameRequiredIfEmbeddedKey$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tableNameMissing$str() {
        return "ISPN008071: Table name must be non null";
    }
    @Override
    public final CacheConfigurationException tableNameMissing() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableNameMissing$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void sqlMetadataNotPresent(final String tableName) {
        super.log.logf(FQCN, WARN, null, sqlMetadataNotPresent$str(), tableName);
    }
    protected String sqlMetadataNotPresent$str() {
        return "ISPN008072: There was no JDBC metadata present in table %s, unable to confirm if segments are properly configured! Segments are assumed to be properly configured.";
    }
}
