/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.CDIConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.SimpleConnectionFactoryConfiguration;

public abstract class AbstractJdbcStoreConfigurationSerializer
extends AbstractStoreSerializer {
    protected void writeJdbcStoreAttributes(ConfigurationWriter writer, AbstractJdbcStoreConfiguration<?> configuration) {
        configuration.attributes().write(writer);
    }

    protected void writeJDBCStoreConnection(ConfigurationWriter writer, AbstractJdbcStoreConfiguration<?> configuration) {
        ConnectionFactoryConfiguration cfc = configuration.connectionFactory();
        if (cfc instanceof SimpleConnectionFactoryConfiguration) {
            this.writeAttributes(writer, Element.SIMPLE_CONNECTION, cfc.attributes());
        } else if (cfc instanceof PooledConnectionFactoryConfiguration) {
            this.writeAttributes(writer, Element.CONNECTION_POOL, cfc.attributes());
        } else if (cfc instanceof ManagedConnectionFactoryConfiguration) {
            this.writeAttributes(writer, Element.DATA_SOURCE, cfc.attributes());
        } else if (cfc instanceof CDIConnectionFactoryConfiguration) {
            this.writeAttributes(writer, Element.CDI_DATA_SOURCE, cfc.attributes());
        }
    }

    private void writeAttributes(ConfigurationWriter writer, Element element, AttributeSet attributes) {
        writer.writeStartElement((Enum)element);
        attributes.write(writer);
        writer.writeEndElement();
    }
}

