/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.connectionfactory;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ManagedConnectionFactory
extends ConnectionFactory {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataSource dataSource;

    @Override
    public void start(ConnectionFactoryConfig config) throws CacheLoaderException {
        InitialContext ctx = null;
        String datasourceName = config.getDatasourceJndiLocation();
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(datasourceName);
            if (trace) {
                log.trace((Object)("Datasource lookup for " + datasourceName + " succeeded: " + this.dataSource));
            }
            if (this.dataSource == null) {
                String msg = "Could not find a connection in jndi under the name '" + datasourceName + "'";
                log.error((Object)msg);
                throw new CacheLoaderException(msg);
            }
        }
        catch (NamingException e) {
            log.error((Object)("Could not lookup connection with datasource " + datasourceName), (Throwable)e);
            throw new CacheLoaderException((Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn((Object)"Failed to close naming context.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws CacheLoaderException {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new CacheLoaderException("This might be related to https://jira.jboss.org/browse/ISPN-604", (Throwable)e);
        }
        if (trace) {
            log.trace((Object)("Connection checked out: " + connection));
        }
        return connection;
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)("Issues while closing connection " + conn), (Throwable)e);
        }
    }
}

