/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import javax.transaction.Transaction;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.common.AbstractJdbcStore;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.jdbc.table.management.TableManagerFactory;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JdbcStringBasedStoreConfiguration.class)
public class JdbcStringBasedStore<K, V>
extends AbstractJdbcStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JdbcStringBasedStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private JdbcStringBasedStoreConfiguration configuration;
    private Key2StringMapper key2StringMapper;
    private GlobalConfiguration globalConfiguration;

    public JdbcStringBasedStore() {
        super(log);
    }

    @Override
    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.configuration = (JdbcStringBasedStoreConfiguration)ctx.getConfiguration();
        this.globalConfiguration = ctx.getCache().getCacheManager().getCacheManagerConfiguration();
    }

    @Override
    public void start() {
        super.start();
        try {
            Object mapper = Util.loadClassStrict((String)this.configuration.key2StringMapper(), (ClassLoader)this.globalConfiguration.classLoader()).newInstance();
            if (mapper instanceof Key2StringMapper) {
                this.key2StringMapper = (Key2StringMapper)mapper;
            }
        }
        catch (Exception e) {
            log.errorf("Trying to instantiate %s, however it failed due to %s", this.configuration.key2StringMapper(), e.getClass().getName());
            throw new IllegalStateException("This should not happen.", e);
        }
        if (trace) {
            log.tracef("Using key2StringMapper: %s", this.key2StringMapper.getClass().getName());
        }
        if (this.configuration.preload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (this.isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshalledEntry entry) {
        Connection connection = null;
        String keyStr = this.key2Str(entry.getKey());
        try {
            connection = this.connectionFactory.getConnection();
            this.write(entry, connection, keyStr);
        }
        catch (SQLException ex) {
            log.sqlFailureStoringKey(keyStr, ex);
            throw new PersistenceException(String.format("Error while storing string key to database; key: '%s'", keyStr), (Throwable)ex);
        }
        catch (InterruptedException e) {
            if (trace) {
                log.trace("Interrupted while marshalling to store");
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    private void write(MarshalledEntry entry, Connection connection) throws SQLException, InterruptedException {
        this.write(entry, connection, this.key2Str(entry.getKey()));
    }

    private void write(MarshalledEntry entry, Connection connection, String keyStr) throws SQLException, InterruptedException {
        if (this.tableManager.isUpsertSupported()) {
            this.executeUpsert(connection, entry, keyStr);
        } else {
            this.executeLegacyUpdate(connection, entry, keyStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpsert(Connection connection, MarshalledEntry entry, String keyStr) throws InterruptedException, SQLException {
        PreparedStatement ps = null;
        String sql = this.tableManager.getUpsertRowSql();
        if (trace) {
            log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
        }
        try {
            ps = connection.prepareStatement(sql);
            this.prepareUpdateStatement(entry, keyStr, ps);
            ps.executeUpdate();
        }
        finally {
            JdbcUtil.safeClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLegacyUpdate(Connection connection, MarshalledEntry entry, String keyStr) throws InterruptedException, SQLException {
        String sql = this.tableManager.getSelectIdRowSql();
        if (trace) {
            log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
        }
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            ResultSet rs = ps.executeQuery();
            sql = rs.next() ? this.tableManager.getUpdateRowSql() : this.tableManager.getInsertRowSql();
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            if (trace) {
                log.tracef("Running sql '%s'. Key string is '%s'", sql, keyStr);
            }
            ps = connection.prepareStatement(sql);
            this.prepareUpdateStatement(entry, keyStr, ps);
            ps.executeUpdate();
        }
        finally {
            JdbcUtil.safeClose(ps);
        }
    }

    public MarshalledEntry load(Object key) {
        String lockingKey = this.key2Str(key);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        MarshalledEntry storedValue = null;
        try {
            String sql = this.tableManager.getSelectRowSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, lockingKey);
            rs = ps.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getBinaryStream(2);
                KeyValuePair icv = (KeyValuePair)this.unmarshall(inputStream);
                storedValue = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, (ByteBuffer)icv.getKey(), (ByteBuffer)icv.getValue());
            }
        }
        catch (SQLException e) {
            try {
                log.sqlFailureReadingKey(key, lockingKey, e);
                throw new PersistenceException(String.format("SQL error while fetching stored entry with key: %s, lockingKey: %s", key, lockingKey), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        if (storedValue != null && storedValue.getMetadata() != null && storedValue.getMetadata().isExpired(this.ctx.getTimeService().wallClockTime())) {
            return null;
        }
        return storedValue;
    }

    public boolean delete(Object key) {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        String keyStr = this.key2Str(key);
        try {
            String sql = this.tableManager.getDeleteRowSql();
            if (trace) {
                log.tracef("Running sql '%s' on %s", sql, keyStr);
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                log.sqlFailureRemovingKeys(ex);
                throw new PersistenceException("Error while removing string keys from database", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener task) {
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        Future<Void> future = ecs.submit(() -> {
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                String sql = this.tableManager.getDeleteExpiredRowsSql();
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setLong(1, this.ctx.getTimeService().wallClockTime());
                int result = ps.executeUpdate();
                if (trace) {
                    log.tracef("Successfully purged %d rows.", result);
                }
            }
            catch (SQLException ex) {
                try {
                    log.failedClearingJdbcCacheStore(ex);
                    throw new PersistenceException("Failed clearing string based JDBC store", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(conn);
                    throw throwable;
                }
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return null;
        });
        this.waitForFutureToComplete(future);
    }

    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        Future<Void> future = ecs.submit(() -> {
            Void void_;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                String sql = this.tableManager.getLoadNonExpiredAllRowsSql();
                if (trace) {
                    log.tracef("Running sql %s", sql);
                }
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql, 1003, 1007);
                ps.setLong(1, this.ctx.getTimeService().wallClockTime());
                ps.setFetchSize(this.tableManager.getFetchSize());
                rs = ps.executeQuery();
                TaskContextImpl taskContext = new TaskContextImpl();
                while (rs.next()) {
                    MarshalledEntry entry;
                    String keyStr = rs.getString(2);
                    Object key = ((TwoWayKey2StringMapper)this.key2StringMapper).getKeyMapping(keyStr);
                    if (taskContext.isStopped()) break;
                    if (filter != null && !filter.accept(key)) continue;
                    InputStream inputStream = rs.getBinaryStream(1);
                    if (fetchValue || fetchMetadata) {
                        KeyValuePair kvp = (KeyValuePair)this.unmarshall(inputStream);
                        entry = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, fetchValue ? (ByteBuffer)kvp.getKey() : null, fetchMetadata ? (ByteBuffer)kvp.getValue() : null);
                    } else {
                        entry = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, null, null);
                    }
                    task.processEntry(entry, (AdvancedCacheLoader.TaskContext)taskContext);
                }
                void_ = null;
            }
            catch (SQLException e) {
                try {
                    log.sqlFailureFetchingAllStoredEntries(e);
                    throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(rs);
                    JdbcUtil.safeClose(ps);
                    this.connectionFactory.releaseConnection(conn);
                    throw throwable;
                }
            }
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return void_;
        });
        this.waitForFutureToComplete(future);
    }

    public void prepareWithModifications(Transaction transaction, BatchModification batchModification) throws PersistenceException {
        try {
            Connection connection = this.getTxConnection(transaction);
            connection.setAutoCommit(false);
            boolean upsertSupported = this.tableManager.isUpsertSupported();
            try (PreparedStatement upsertBatch = upsertSupported ? connection.prepareStatement(this.tableManager.getUpsertRowSql()) : null;
                 PreparedStatement deleteBatch = connection.prepareStatement(this.tableManager.getDeleteRowSql());){
                String keyStr;
                for (MarshalledEntry entry : batchModification.getMarshalledEntries()) {
                    if (upsertSupported) {
                        keyStr = this.key2Str(entry.getKey());
                        this.prepareUpdateStatement(entry, keyStr, upsertBatch);
                        upsertBatch.addBatch();
                        continue;
                    }
                    this.write(entry, connection);
                }
                for (Object key : batchModification.getKeysToRemove()) {
                    keyStr = this.key2Str(key);
                    deleteBatch.setString(1, keyStr);
                    deleteBatch.addBatch();
                }
                if (upsertSupported && !batchModification.getMarshalledEntries().isEmpty()) {
                    upsertBatch.executeBatch();
                }
                if (!batchModification.getKeysToRemove().isEmpty()) {
                    deleteBatch.executeUpdate();
                }
            }
        }
        catch (InterruptedException | SQLException e) {
            throw log.prepareTxFailure(e);
        }
    }

    public int size() {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            String sql = this.tableManager.getCountRowsSql();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                log.sqlFailureIntegratingState(e);
                throw new PersistenceException("SQL failure while integrating state into store", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return n;
    }

    private void prepareUpdateStatement(MarshalledEntry entry, String key, PreparedStatement ps) throws InterruptedException, SQLException {
        ByteBuffer byteBuffer = this.marshall(new KeyValuePair((Object)entry.getValueBytes(), (Object)entry.getMetadataBytes()));
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setLong(2, PersistenceUtil.getExpiryTime((InternalMetadata)entry.getMetadata()));
        ps.setString(3, key);
    }

    private String key2Str(Object key) throws PersistenceException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        return this.key2StringMapper.getStringMapping(key);
    }

    public boolean supportsKey(Class<?> keyType) {
        return this.key2StringMapper.isSupportedType(keyType);
    }

    @Override
    public TableManager getTableManager() {
        if (this.tableManager == null) {
            this.tableManager = TableManagerFactory.getManager(this.connectionFactory, this.configuration);
        }
        return this.tableManager;
    }

    private void enforceTwoWayMapper(String where) throws PersistenceException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            log.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new PersistenceException(String.format("Invalid key to string mapper : %s", this.key2StringMapper.getClass().getName()));
        }
    }

    public boolean isDistributed() {
        return this.ctx.getCache().getCacheConfiguration() != null && this.ctx.getCache().getCacheConfiguration().clustering().cacheMode().isDistributed();
    }
}

