/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbm.configuration;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.jdbm.NaturalComparator;
import org.infinispan.loaders.jdbm.configuration.JdbmCacheStoreConfiguration;

public class JdbmCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<JdbmCacheStoreConfiguration, JdbmCacheStoreConfigurationBuilder> {
    private String comparatorClassName = NaturalComparator.class.getName();
    private int expiryQueueSize = 10000;
    private String location = "jdbm";

    public JdbmCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public JdbmCacheStoreConfigurationBuilder self() {
        return this;
    }

    public JdbmCacheStoreConfigurationBuilder comparatorClassName(String comparatorClassName) {
        this.comparatorClassName = comparatorClassName;
        return this;
    }

    public JdbmCacheStoreConfigurationBuilder expiryQueueSize(int expiryQueueSize) {
        this.expiryQueueSize = expiryQueueSize;
        return this;
    }

    public JdbmCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public JdbmCacheStoreConfiguration create() {
        return new JdbmCacheStoreConfiguration(this.comparatorClassName, this.expiryQueueSize, this.location, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public JdbmCacheStoreConfigurationBuilder read(JdbmCacheStoreConfiguration template) {
        this.comparatorClassName = template.comparatorClassName();
        this.expiryQueueSize = template.expiryQueueSize();
        this.location = template.location();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

