/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.jpa.JpaStoreException;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.jpa.impl.EntityManagerFactoryRegistry;
import org.infinispan.persistence.jpa.impl.MetadataEntity;
import org.infinispan.persistence.jpa.impl.MetadataEntityKey;
import org.infinispan.persistence.jpa.impl.Stats;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Store(shared=true)
@ConfiguredBy(value=JpaStoreConfiguration.class)
public class JpaStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private static final Log log = LogFactory.getLog(JpaStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private JpaStoreConfiguration configuration;
    private EntityManagerFactory emf;
    private EntityManagerFactoryRegistry emfRegistry;
    private PersistenceMarshaller marshaller;
    private MarshallableEntryFactory<K, V> marshallerEntryFactory;
    private TimeService timeService;
    private Scheduler scheduler;
    private Stats stats = new Stats();
    private boolean setFetchSizeMinInteger = false;

    public void init(InitializationContext ctx) {
        this.configuration = (JpaStoreConfiguration)ctx.getConfiguration();
        this.emfRegistry = (EntityManagerFactoryRegistry)ctx.getCache().getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry().getComponent(EntityManagerFactoryRegistry.class);
        this.marshallerEntryFactory = ctx.getMarshallableEntryFactory();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.timeService = ctx.getTimeService();
        this.scheduler = Schedulers.from((Executor)ctx.getExecutor());
    }

    public void start() {
        Dialect dialect;
        EntityType it;
        this.emf = this.emfRegistry.getEntityManagerFactory(this.configuration.persistenceUnitName());
        try {
            it = this.emf.getMetamodel().entity(this.configuration.entityClass());
        }
        catch (IllegalArgumentException e) {
            throw new JpaStoreException("Entity class [" + this.configuration.entityClass().getName() + " specified in configuration is not recognized by the EntityManagerFactory with Persistence Unit [" + this.configuration.persistenceUnitName() + "]", e);
        }
        if (it == null) {
            throw new JpaStoreException("Entity class must have one and only one identifier (@Id or @EmbeddedId)");
        }
        if (!it.hasSingleIdAttribute()) {
            throw new JpaStoreException("Entity class has more than one identifier.  It must have only one identifier.");
        }
        Type idType = it.getIdType();
        Class idJavaType = idType.getJavaType();
        if (idJavaType.isAnnotationPresent(GeneratedValue.class)) {
            throw new JpaStoreException("Entity class has one identifier, but it must not have @GeneratedValue annotation");
        }
        SessionFactory sessionFactory = ((Session)this.emf.createEntityManager().unwrap(Session.class)).getSessionFactory();
        if (sessionFactory instanceof SessionFactoryImplementor && (dialect = ((SessionFactoryImplementor)sessionFactory).getDialect()) instanceof MySQLDialect) {
            this.setFetchSizeMinInteger = true;
        }
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public void stop() {
        try {
            this.emfRegistry.closeEntityManagerFactory(this.configuration.persistenceUnitName());
        }
        catch (Exception e) {
            throw new JpaStoreException("Exceptions occurred while stopping store", e);
        }
        finally {
            log.debug((Object)("JPA Store stopped, stats: " + this.stats));
        }
    }

    protected boolean isValidKeyType(Object key) {
        return this.emf.getMetamodel().entity(this.configuration.entityClass()).getIdType().getJavaType().isAssignableFrom(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findEntity(EntityManager em, Object key) {
        long begin = this.timeService.time();
        try {
            Object object = em.find(this.configuration.entityClass(), key);
            return object;
        }
        finally {
            this.stats.addEntityFind(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataEntity findMetadata(EntityManager em, Object key) {
        long begin = this.timeService.time();
        try {
            MetadataEntity metadataEntity = (MetadataEntity)em.find(MetadataEntity.class, key);
            return metadataEntity;
        }
        finally {
            this.stats.addMetadataFind(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(EntityManager em, Object entity) {
        long begin = this.timeService.time();
        try {
            em.remove(entity);
        }
        finally {
            this.stats.addEntityRemove(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadata(EntityManager em, MetadataEntity metadata) {
        long begin = this.timeService.time();
        try {
            em.remove((Object)metadata);
        }
        finally {
            this.stats.addMetadataRemove(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeEntity(EntityManager em, Object entity) {
        long begin = this.timeService.time();
        try {
            em.merge(entity);
        }
        finally {
            this.stats.addEntityMerge(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeMetadata(EntityManager em, MetadataEntity metadata) {
        long begin = this.timeService.time();
        try {
            em.merge((Object)metadata);
        }
        finally {
            this.stats.addMetadataMerge(this.timeService.time() - begin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try (EntityManager emStream = this.emf.createEntityManager();){
            ScrollableResults results = null;
            ArrayList<Object> batch = this.configuration.maxBatchSize() > 0 ? new ArrayList<Object>(this.configuration.maxBatchSize()) : new ArrayList();
            EntityTransaction txStream = emStream.getTransaction();
            txStream.begin();
            try {
                log.trace((Object)"Clearing JPA Store");
                Session session = (Session)emStream.unwrap(Session.class);
                Criteria criteria = session.createCriteria(this.configuration.entityClass()).setReadOnly(true).setProjection((Projection)Projections.id());
                if (this.setFetchSizeMinInteger) {
                    criteria.setFetchSize(Integer.MIN_VALUE);
                }
                results = criteria.scroll(ScrollMode.FORWARD_ONLY);
                while (results.next()) {
                    Object o = results.get(0);
                    batch.add(o);
                    if (batch.size() != this.configuration.maxBatchSize()) continue;
                    session.clear();
                    this.removeBatch(batch);
                }
                if (this.configuration.storeMetadata()) {
                    results.close();
                    results = null;
                    String metadataTable = emStream.getMetamodel().entity(MetadataEntity.class).getName();
                    Query clearMetadata = emStream.createQuery("DELETE FROM " + metadataTable);
                    clearMetadata.executeUpdate();
                }
                txStream.commit();
            }
            finally {
                this.removeBatch(batch);
                if (results != null) {
                    results.close();
                }
                if (txStream.isActive()) {
                    txStream.rollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeBatch(ArrayList<Object> batch) {
        for (int i = 10; i >= 0; --i) {
            EntityManager emExec = this.emf.createEntityManager();
            EntityTransaction txn = null;
            txn = emExec.getTransaction();
            txn.begin();
            for (Object key : batch) {
                try {
                    Object entity = emExec.getReference(this.configuration.entityClass(), key);
                    this.removeEntity(emExec, entity);
                }
                catch (EntityNotFoundException e) {
                    log.trace((Object)("Cleared entity with key " + key + " not found"), (Throwable)e);
                }
            }
            txn.commit();
            batch.clear();
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            emExec.close();
            break;
            {
                catch (Exception e) {
                    try {
                        if (i != 0) {
                            log.trace((Object)"Remove batch failed once", (Throwable)e);
                            continue;
                        }
                        throw new JpaStoreException("Remove batch failing", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (txn != null && txn.isActive()) {
                            txn.rollback();
                        }
                        emExec.close();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean delete(Object key) {
        if (!this.isValidKeyType(key)) {
            return false;
        }
        try (EntityManager em = this.emf.createEntityManager();){
            Object entity = this.findEntity(em, key);
            if (entity == null) {
                boolean bl = false;
                return bl;
            }
            MetadataEntity metadata = this.getMetadataEntity(key, em);
            EntityTransaction txn = em.getTransaction();
            if (trace) {
                log.trace((Object)("Removing " + entity + "(" + this.toString(metadata) + ")"));
            }
            long txnBegin = this.timeService.time();
            txn.begin();
            try {
                this.removeEntity(em, entity);
                if (metadata != null) {
                    this.removeMetadata(em, metadata);
                }
                txn.commit();
                this.stats.addRemoveTxCommitted(this.timeService.time() - txnBegin);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                this.stats.addRemoveTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in delete()", e);
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBatch(Iterable<Object> keys) {
        List keyCollection = StreamSupport.stream(keys.spliterator(), false).collect(Collectors.toList());
        if (keyCollection.isEmpty()) {
            return;
        }
        try (EntityManager em = this.emf.createEntityManager();){
            EntityTransaction txn = em.getTransaction();
            long txnBegin = this.timeService.time();
            try {
                txn.begin();
                CriteriaBuilder cb = em.getCriteriaBuilder();
                CriteriaDelete query = cb.createCriteriaDelete(this.configuration.entityClass());
                Root root = query.from(this.configuration.entityClass());
                SingularAttribute id = this.getEntityId(em, this.configuration.entityClass());
                query.where((Expression)root.get(id).in(keyCollection));
                em.createQuery(query).executeUpdate();
                if (this.configuration.storeMetadata()) {
                    List metaKeys = keyCollection.stream().map(this::getMetadataKey).collect(Collectors.toList());
                    CriteriaDelete metaQuery = cb.createCriteriaDelete(MetadataEntity.class);
                    Root metaRoot = metaQuery.from(MetadataEntity.class);
                    id = this.getEntityId(em, MetadataEntity.class);
                    query.where((Expression)metaRoot.get(id).in(metaKeys));
                    em.createQuery(metaQuery).executeUpdate();
                }
                txn.commit();
                this.stats.addBatchRemoveTxCommitted(this.timeService.time() - txnBegin);
            }
            catch (Exception e) {
                this.stats.addBatchRemoveTxFailed(this.timeService.time() - txnBegin);
                if (e instanceof JpaStoreException) {
                    throw e;
                }
                throw new JpaStoreException("Exception caught in deleteBatch()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
        }
    }

    private SingularAttribute getEntityId(EntityManager em, Class clazz) {
        Metamodel meta = em.getMetamodel();
        IdentifiableType identifiableType = (IdentifiableType)meta.managedType(clazz);
        return identifiableType.getId(identifiableType.getIdType().getJavaType());
    }

    private MetadataEntityKey getMetadataKey(Object key) {
        byte[] keyBytes;
        try {
            keyBytes = this.marshaller.objectToByteBuffer(key);
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to marshall key", e);
        }
        return new MetadataEntityKey(keyBytes);
    }

    private MetadataEntity getMetadataEntity(Object key, EntityManager em) {
        return this.configuration.storeMetadata() ? this.findMetadata(em, this.getMetadataKey(key)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MarshallableEntry entry) {
        EntityManager em = this.emf.createEntityManager();
        Object entity = entry.getValue();
        MetadataEntity metadata = this.configuration.storeMetadata() ? new MetadataEntity(entry) : null;
        try {
            this.validateEntityIsAssignable(entity);
            this.validateObjectId(entry);
            EntityTransaction txn = em.getTransaction();
            long txnBegin = this.timeService.time();
            try {
                if (trace) {
                    log.trace((Object)("Writing " + entity + "(" + this.toString(metadata) + ")"));
                }
                txn.begin();
                this.mergeEntity(em, entity);
                if (metadata != null && metadata.hasBytes()) {
                    this.mergeMetadata(em, metadata);
                }
                txn.commit();
                this.stats.addWriteTxCommited(this.timeService.time() - txnBegin);
            }
            catch (Exception e) {
                this.stats.addWriteTxFailed(this.timeService.time() - txnBegin);
                throw new JpaStoreException("Exception caught in write()", e);
            }
            finally {
                if (txn != null && txn.isActive()) {
                    txn.rollback();
                }
            }
        }
        finally {
            em.close();
        }
    }

    public CompletionStage<Void> bulkUpdate(Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Flowable.using(() -> {
            EntityManager em = this.emf.createEntityManager();
            EntityTransaction txn = em.getTransaction();
            return new KeyValuePair((Object)em, (Object)txn);
        }, kvp -> this.createBatchFlowable((EntityManager)kvp.getKey(), (EntityTransaction)kvp.getValue(), publisher), kvp -> {
            EntityTransaction txn = (EntityTransaction)kvp.getValue();
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            ((EntityManager)kvp.getKey()).close();
        }).doOnError(e -> {
            if (e instanceof JpaStoreException) {
                throw (JpaStoreException)((Object)((Object)e));
            }
            throw new JpaStoreException("Exception caught in bulkUpdate()", (Throwable)e);
        }).subscribe(RxJavaInterop.emptyConsumer(), future::completeExceptionally, () -> future.complete(null));
        return future;
    }

    private Flowable<MarshallableEntry<? extends K, ? extends V>> createBatchFlowable(EntityManager em, EntityTransaction txn, Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
        long txnBegin = this.timeService.time();
        txn.begin();
        return Flowable.fromPublisher(publisher).doOnNext(entry -> {
            Object entity = entry.getValue();
            this.validateEntityIsAssignable(entity);
            this.validateObjectId((MarshallableEntry)entry);
            MetadataEntity metadata = this.configuration.storeMetadata() ? new MetadataEntity((MarshallableEntry)entry) : null;
            this.mergeEntity(em, entity);
            if (metadata != null && metadata.hasBytes()) {
                this.mergeMetadata(em, metadata);
            }
        }).doOnComplete(() -> {
            this.stats.addBatchWriteTxCommitted(this.timeService.time() - txnBegin);
            txn.commit();
        }).doOnError(e -> this.stats.addBatchWriteTxFailed(this.timeService.time() - txnBegin)).doFinally(() -> {
            if (txn.isActive()) {
                txn.rollback();
            }
        });
    }

    private void validateObjectId(MarshallableEntry entry) {
        Object id = this.emf.getPersistenceUnitUtil().getIdentifier(entry.getValue());
        if (!entry.getKey().equals(id)) {
            throw new JpaStoreException("Entity id value must equal to key of cache entry: key = [" + entry.getKey() + "], id = [" + id + "]");
        }
    }

    private void validateEntityIsAssignable(Object entity) {
        if (!this.configuration.entityClass().isAssignableFrom(entity.getClass())) {
            throw new JpaStoreException(String.format("This cache is configured with JPA CacheStore to only store values of type %s - cannot write %s = %s", this.configuration.entityClass().getName(), entity, entity.getClass().getName()));
        }
    }

    /*
     * Exception decompiling
     */
    public boolean contains(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public MarshallableEntry loadEntry(Object key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Flowable<K> publishKeys(Predicate<? super K> filter) {
        return Flowable.using(() -> {
            EntityManager emStream = this.emf.createEntityManager();
            Session session = (Session)emStream.unwrap(Session.class);
            Criteria criteria = session.createCriteria(this.configuration.entityClass()).setProjection((Projection)Projections.id()).setReadOnly(true);
            if (this.setFetchSizeMinInteger) {
                criteria.setFetchSize(Integer.MIN_VALUE);
            }
            ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
            return new KeyValuePair((Object)emStream, (Object)results);
        }, kvp -> {
            ScrollableResults results = (ScrollableResults)kvp.getValue();
            return Flowable.fromIterable(() -> new ScrollableResultsIterator(results, filter));
        }, kvp -> {
            try {
                ((ScrollableResults)kvp.getValue()).close();
            }
            finally {
                ((EntityManager)kvp.getKey()).close();
            }
        });
    }

    public Flowable<MarshallableEntry<K, V>> entryPublisher(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        boolean innerFetchMetadata;
        if (fetchMetadata && !this.configuration.storeMetadata()) {
            log.debug((Object)"Metadata cannot be retrieved as JPA Store is not configured to persist metadata.");
            innerFetchMetadata = false;
        } else {
            innerFetchMetadata = fetchMetadata;
        }
        Flowable<? super K> keyPublisher = this.publishKeys(filter);
        if (fetchValue || innerFetchMetadata) {
            return keyPublisher.parallel().runOn(this.scheduler).map(k -> this.loadEntry(k, fetchValue, innerFetchMetadata)).sequential();
        }
        return keyPublisher.map(k -> this.marshallerEntryFactory.create(k));
    }

    private boolean isExpired(MetadataEntity entity) {
        long expiry = entity.getExpiration();
        return expiry > 0L && expiry <= this.timeService.wallClockTime();
    }

    private Metadata getMetadata(MetadataEntity entity) {
        if (entity == null || entity.getMetadata() == null) {
            return null;
        }
        try {
            return (Metadata)this.marshaller.objectFromByteBuffer(entity.getMetadata());
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to unmarshall metadata", e);
        }
    }

    private PrivateMetadata getInternalMetadata(MetadataEntity entity) {
        if (entity == null || entity.getInternalMetadata() == null) {
            return null;
        }
        try {
            return (PrivateMetadata)this.marshaller.objectFromByteBuffer(entity.getInternalMetadata());
        }
        catch (Exception e) {
            throw new JpaStoreException("Failed to unmarshall internal metadata", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EntityManager em = this.emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        txn.begin();
        try {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery cq = builder.createQuery(Long.class);
            cq.select((Selection)builder.count((Expression)cq.from(this.configuration.entityClass())));
            int n = ((Long)em.createQuery(cq).getSingleResult()).intValue();
            return n;
        }
        finally {
            try {
                txn.commit();
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
        if (!this.configuration.storeMetadata()) {
            log.debug((Object)"JPA Store cannot be purged as metadata holding expirations are not available");
            return;
        }
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(threadPool);
        try (EntityManager emStream = this.emf.createEntityManager();){
            EntityTransaction txStream = emStream.getTransaction();
            ScrollableResults metadataKeys = null;
            txStream.begin();
            try {
                ArrayList<MetadataEntityKey> batch;
                long currentTime = this.timeService.wallClockTime();
                Session session = (Session)emStream.unwrap(Session.class);
                Criteria criteria = session.createCriteria(MetadataEntity.class).setReadOnly(true).add((Criterion)Restrictions.le((String)"expiration", (Object)currentTime)).setProjection((Projection)Projections.id());
                if (this.setFetchSizeMinInteger) {
                    criteria.setFetchSize(Integer.MIN_VALUE);
                }
                metadataKeys = criteria.scroll(ScrollMode.FORWARD_ONLY);
                ArrayList<MetadataEntityKey> arrayList = batch = this.configuration.maxBatchSize() > 0 ? new ArrayList<MetadataEntityKey>(this.configuration.maxBatchSize()) : new ArrayList();
                while (metadataKeys.next()) {
                    MetadataEntityKey mKey = (MetadataEntityKey)metadataKeys.get(0);
                    batch.add(mKey);
                    if (batch.size() != this.configuration.maxBatchSize()) continue;
                    this.purgeBatch(batch, listener, eacs, currentTime);
                    batch.clear();
                }
                this.purgeBatch(batch, listener, eacs, currentTime);
                txStream.commit();
            }
            finally {
                if (metadataKeys != null) {
                    metadataKeys.close();
                }
                if (txStream.isActive()) {
                    txStream.rollback();
                }
            }
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new JpaStoreException(eacs.getFirstException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeBatch(List<MetadataEntityKey> batch, AdvancedCacheWriter.PurgeListener listener, ExecutorAllCompletionService eacs, long currentTime) {
        try (EntityManager emExec = this.emf.createEntityManager();){
            EntityTransaction txn = emExec.getTransaction();
            txn.begin();
            try {
                for (MetadataEntityKey metadataKey : batch) {
                    Object key;
                    MetadataEntity metadata = this.findMetadata(emExec, metadataKey);
                    if (metadata.getExpiration() > currentTime) continue;
                    try {
                        key = this.marshaller.objectFromByteBuffer(metadata.getKeyBytes());
                    }
                    catch (Exception e) {
                        throw new JpaStoreException("Cannot unmarshall key", e);
                    }
                    Object entity = null;
                    try {
                        entity = emExec.getReference(this.configuration.entityClass(), key);
                        this.removeEntity(emExec, entity);
                    }
                    catch (EntityNotFoundException e) {
                        log.trace((Object)("Expired entity with key " + key + " not found"), (Throwable)e);
                    }
                    this.removeMetadata(emExec, metadata);
                    if (trace) {
                        log.trace((Object)("Expired " + key + " -> " + entity + "(" + this.toString(metadata) + ")"));
                    }
                    if (listener == null) continue;
                    eacs.submit(() -> listener.entryPurged(key), null);
                }
                txn.commit();
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
        }
    }

    private String toString(MetadataEntity metadata) {
        if (metadata == null || !metadata.hasBytes()) {
            return "<no metadata>";
        }
        try {
            return this.marshaller.objectFromByteBuffer(metadata.getMetadata()).toString();
        }
        catch (Exception e) {
            log.trace((Object)"Failed to unmarshall metadata", (Throwable)e);
            return "<metadata: " + e + ">";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshallableEntry<K, V> loadEntry(Object key, boolean fetchValue, boolean fetchMetadata) {
        Object entity;
        Metadata metadata;
        MetadataEntity metaEntity;
        try (EntityManager emExec = this.emf.createEntityManager();){
            metaEntity = fetchMetadata ? this.getMetadataEntity(key, emExec) : null;
            metadata = this.getMetadata(metaEntity);
            if (trace) {
                log.tracef("Fetched metadata (fetching? %s) %s", (Object)fetchMetadata, (Object)metadata);
            }
            if (metaEntity != null && this.isExpired(metaEntity)) {
                MarshallableEntry<K, V> marshallableEntry = null;
                return marshallableEntry;
            }
            if (fetchValue) {
                entity = this.findEntity(emExec, key);
                if (trace) {
                    log.tracef("Fetched value %s", entity);
                }
            } else {
                entity = null;
            }
        }
        try {
            return metaEntity == null ? this.marshallerEntryFactory.create(key, entity) : this.marshallerEntryFactory.create(key, entity, metadata, this.getInternalMetadata(metaEntity), metaEntity.getCreated(), metaEntity.getLastUsed());
        }
        catch (Exception e) {
            Log.PERSISTENCE.errorExecutingParallelStoreTask((Throwable)e);
            throw e;
        }
    }

    private class ScrollableResultsIterator
    extends AbstractIterator<K> {
        private final ScrollableResults results;
        private final Predicate<? super K> filter;

        public ScrollableResultsIterator(ScrollableResults results, Predicate<? super K> filter) {
            this.results = results;
            this.filter = filter;
        }

        protected K getNext() {
            Object key = null;
            while (key == null && this.results.next()) {
                Object testKey = this.results.get(0);
                if (this.filter != null && !this.filter.test(testKey)) continue;
                key = testKey;
            }
            return key;
        }
    }
}

