/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.persistence.KeyValueWrapper;
import org.infinispan.persistence.PersistenceCompatibilityTest;
import org.infinispan.persistence.jpa.JpaKeyValueWrapper;
import org.infinispan.persistence.jpa.JpaSCI;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.jpa.entity.KeyValueEntity;
import org.infinispan.protostream.SerializationContextInitializer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jpa.JpaStoreCompatibilityTest")
public class JpaStoreCompatibilityTest
extends PersistenceCompatibilityTest<KeyValueEntity> {
    private static final String DB_FILE_NAME = "jpa_db.mv.db";
    private static final String DATA_10_1_FOLDER = "10_1_x_jpa_data";

    protected JpaStoreCompatibilityTest() {
        super((KeyValueWrapper)JpaKeyValueWrapper.INSTANCE);
    }

    protected void amendGlobalConfigurationBuilder(GlobalConfigurationBuilder builder) {
        super.amendGlobalConfigurationBuilder(builder);
        builder.serialization().addContextInitializer((SerializationContextInitializer)JpaSCI.INSTANCE);
    }

    protected void beforeStartCache() throws Exception {
        new File(this.tmpDirectory).mkdirs();
        JpaStoreCompatibilityTest.copyFile((String)this.combinePath(DATA_10_1_FOLDER, DB_FILE_NAME), (Path)Paths.get(this.tmpDirectory, new String[0]), (String)DB_FILE_NAME);
    }

    protected String cacheName() {
        return "jps-store-cache";
    }

    protected void configurePersistence(ConfigurationBuilder builder) {
        ((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).entityClass(KeyValueEntity.class).storeMetadata(true).persistenceUnitName("org.infinispan.persistence.jpa.compatibility_test").segmented(false);
    }
}

