/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jpa.JpaSCI;
import org.infinispan.persistence.jpa.JpaStore;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.jpa.entity.KeyValueEntity;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.JpaStoreAsyncFunctionalTest")
public class JpaStoreAsyncFunctionalTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass()));
        global.serialization().addContextInitializer((SerializationContextInitializer)JpaSCI.INSTANCE);
        return TestCacheManagerFactory.newDefaultCacheManager((boolean)false, (GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
    }

    private JpaStoreConfigurationBuilder createJpaConfig() {
        return (JpaStoreConfigurationBuilder)((JpaStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName("org.infinispan.persistence.jpa").entityClass(KeyValueEntity.class).segmented(false);
    }

    public void testAsyncWriteAndDelete() {
        this.cacheManager.defineConfiguration("ASYNC_STORE", this.createJpaConfig().async().enable().build());
        this.cacheManager.defineConfiguration("SYNC_STORE", this.createJpaConfig().build());
        Cache asyncStore = this.cacheManager.getCache("ASYNC_STORE");
        JpaStore syncStore = (JpaStore)TestingUtil.getFirstWriter((Cache)this.cacheManager.getCache("SYNC_STORE"));
        String key = "1";
        asyncStore.put((Object)key, (Object)new KeyValueEntity(key, "Example"));
        this.eventually(() -> syncStore.contains((Object)key));
        asyncStore.remove((Object)key);
        this.eventually(() -> !syncStore.contains((Object)key));
    }
}

